/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.config;

import com.github.glodblock.extendedae.util.FCUtil;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.format.ConfigFormats;
import dev.toma.configuration.config.format.IConfigFormatHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

@Config(id="extendedae")
public class EPPConfig {
    public static EPPConfig INSTANCE;
    @Configurable
    @Configurable.Comment(value={"ME Extend Import/Export Bus speed multiplier"})
    @Configurable.Range(min=2L, max=128L)
    public int busSpeed = 8;
    @Configurable
    @Configurable.Comment(value={"ME Infinity Cell idle energy cost (unit: AE/t)"})
    @Configurable.DecimalRange(min=0.1, max=64.0)
    public double infCellCost = 8.0;
    @Configurable
    @Configurable.Comment(value={"ME Infinity Cell types (item or fluid's id)"})
    public String[] infCellTypeID = new String[]{"minecraft:water", "minecraft:cobblestone"};
    @Configurable
    @Configurable.Comment(value={"The max range between two wireless connector"})
    @Configurable.DecimalRange(min=10.0, max=10000.0)
    public double wirelessConnectorMaxRange = 1000.0;
    @Configurable
    @Configurable.Comment(value={"The AE device/part that can be packed by ME Packing Tape"})
    public String[] tapeWhitelist = new String[]{"expatternprovider:ex_interface_part", "expatternprovider:ex_pattern_provider_part", "expatternprovider:ex_interface", "expatternprovider:ex_pattern_provider", "ae2:cable_interface", "ae2:cable_pattern_provider", "ae2:interface", "ae2:pattern_provider", "ae2:drive"};

    public static void onInit() {
        assert (INSTANCE == null);
        INSTANCE = (EPPConfig)Configuration.registerConfig(EPPConfig.class, (IConfigFormatHandler)ConfigFormats.yaml()).getConfigInstance();
    }

    public List<class_1792> getInfCellItem() {
        return ((Stream)Arrays.stream(this.infCellTypeID).parallel()).filter(s -> FCUtil.checkInvalidRL(s, class_7923.field_41178)).map(s -> (class_1792)class_7923.field_41178.method_10223(new class_2960(s))).collect(Collectors.toList());
    }

    public List<class_3611> getInfCellFluid() {
        return ((Stream)Arrays.stream(this.infCellTypeID).parallel()).filter(s -> FCUtil.checkInvalidRL(s, class_7923.field_41173)).map(s -> (class_3611)class_7923.field_41173.method_10223(new class_2960(s))).collect(Collectors.toList());
    }
}

