/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTRecipeBuilder
extends class_7798
implements class_5797 {
    private final class_7800 category;
    private final class_1799 result;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    @Nullable
    private String group;
    private boolean showNotification = true;

    public NBTRecipeBuilder(class_7800 p_249996_, class_1799 p_251475_) {
        this.category = p_249996_;
        this.result = p_251475_;
    }

    public static NBTRecipeBuilder shaped(class_7800 p_250853_, class_1935 p_249747_) {
        return NBTRecipeBuilder.shaped(p_250853_, p_249747_, 1);
    }

    public static NBTRecipeBuilder shaped(class_7800 p_251325_, class_1935 p_250636_, int p_249081_) {
        return NBTRecipeBuilder.shaped(p_251325_, new class_1799(p_250636_, p_249081_));
    }

    public static NBTRecipeBuilder shaped(class_7800 p_251325_, class_1799 p_251475_) {
        return new NBTRecipeBuilder(p_251325_, p_251475_);
    }

    public NBTRecipeBuilder define(Character p_206417_, class_6862<class_1792> p_206418_) {
        return this.define(p_206417_, class_1856.method_8106(p_206418_));
    }

    public NBTRecipeBuilder define(Character p_126128_, class_1935 p_126129_) {
        return this.define(p_126128_, class_1856.method_8091((class_1935[])new class_1935[]{p_126129_}));
    }

    public NBTRecipeBuilder define(Character p_126128_, class_1799 p_126129_) {
        return this.define(p_126128_, class_1856.method_8101((class_1799[])new class_1799[]{p_126129_}));
    }

    public NBTRecipeBuilder define(Character p_126125_, class_1856 p_126126_) {
        if (this.key.containsKey(p_126125_)) {
            throw new IllegalArgumentException("Symbol '" + p_126125_ + "' is already defined!");
        }
        if (p_126125_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(p_126125_, p_126126_);
        return this;
    }

    public NBTRecipeBuilder pattern(String p_126131_) {
        if (!this.rows.isEmpty() && p_126131_.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(p_126131_);
        return this;
    }

    @NotNull
    public NBTRecipeBuilder unlockedBy(@NotNull String p_126133_, @NotNull class_184 p_126134_) {
        this.advancement.method_709(p_126133_, p_126134_);
        return this;
    }

    @NotNull
    public NBTRecipeBuilder group(@Nullable String p_126146_) {
        this.group = p_126146_;
        return this;
    }

    public NBTRecipeBuilder showNotification(boolean p_273326_) {
        this.showNotification = p_273326_;
        return this;
    }

    @NotNull
    public class_1792 method_36441() {
        return this.result.method_7909();
    }

    public void method_17972(Consumer<class_2444> p_126141_, @NotNull class_2960 p_126142_) {
        this.ensureValid(p_126142_);
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)p_126142_)).method_703(class_170.class_171.method_753((class_2960)p_126142_)).method_704(class_193.field_1257);
        p_126141_.accept((class_2444)new Result(p_126142_, this.result, this.group == null ? "" : this.group, NBTRecipeBuilder.method_46202((class_7800)this.category), this.rows, this.key, this.advancement, p_126142_.method_45138("recipes/" + this.category.method_46203() + "/"), this.showNotification));
    }

    private void ensureValid(class_2960 p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + p_126144_ + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + p_126144_ + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + p_126144_);
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + p_126144_ + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126144_);
        }
    }

    public static class Result
    extends class_7798.class_7799 {
        private final class_2960 id;
        private final class_1799 result;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, class_1856> key;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private final boolean showNotification;

        public Result(class_2960 p_273548_, class_1799 p_273530_, String p_273549_, class_7710 p_273500_, List<String> p_273744_, Map<Character, class_1856> p_272991_, class_161.class_162 p_273260_, class_2960 p_273106_, boolean p_272862_) {
            super(p_273500_);
            this.id = p_273548_;
            this.result = p_273530_;
            this.group = p_273549_;
            this.pattern = p_273744_;
            this.key = p_272991_;
            this.advancement = p_273260_;
            this.advancementId = p_273106_;
            this.showNotification = p_272862_;
        }

        public void method_10416(@NotNull JsonObject p_126167_) {
            super.method_10416(p_126167_);
            if (!this.group.isEmpty()) {
                p_126167_.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            p_126167_.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            p_126167_.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.result.method_7909()).toString());
            if (this.result.method_7919() > 0) {
                jsonObject.addProperty("meta", (Number)this.result.method_7919());
            }
            if (this.result.method_7985()) {
                jsonObject.addProperty("nbt", this.result.method_7969().method_10714());
            }
            if (this.result.method_7947() > 1) {
                jsonObject.addProperty("count", (Number)this.result.method_7947());
            }
            p_126167_.add("result", (JsonElement)jsonObject);
            p_126167_.addProperty("show_notification", Boolean.valueOf(this.showNotification));
        }

        @NotNull
        public class_1865<?> method_17800() {
            return class_1865.field_9035;
        }

        @NotNull
        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

