/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1294;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class ComfortHealthOverlay {
    protected static int healthIconsOffset;
    private static final class_2960 MOD_ICONS_TEXTURE;

    public static void init() {
        HudRenderCallback.EVENT.register(ComfortHealthOverlay::onRenderGuiOverlayPost);
    }

    private static void onRenderGuiOverlayPost(class_332 graphics, float partialTicks) {
        class_310 mc = class_310.method_1551();
        class_329 gui = mc.field_1705;
        if (!mc.field_1690.field_1842 && mc.field_1761.method_2908()) {
            ComfortHealthOverlay.renderComfortOverlay(mc, gui, graphics);
        }
    }

    public static void renderComfortOverlay(class_310 mc, class_329 gui, class_332 graphics) {
        boolean isPlayerEligibleForComfort;
        if (!Configuration.COMFORT_HEALTH_OVERLAY.get().booleanValue()) {
            return;
        }
        healthIconsOffset = 49;
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1702 stats = player.method_7344();
        int top = mc.method_22683().method_4502() - healthIconsOffset + 10;
        int left = mc.method_22683().method_4486() / 2 - 91;
        boolean bl = isPlayerEligibleForComfort = stats.method_7589() == 0.0f && player.method_7317() && !player.method_6059(class_1294.field_5924);
        if (player.method_6112(ModEffects.COMFORT.get()) != null && isPlayerEligibleForComfort) {
            ComfortHealthOverlay.drawComfortOverlay((class_1657)player, mc, graphics, left, top);
        }
    }

    public static void drawComfortOverlay(class_1657 player, class_310 minecraft, class_332 graphics, int left, int top) {
        int ticks = minecraft.field_1705.method_1738();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        int health = class_3532.method_15386((float)player.method_6032());
        float absorb = class_3532.method_15386((float)player.method_6067());
        class_1324 attrMaxHealth = player.method_5996(class_5134.field_23716);
        float healthMax = (float)attrMaxHealth.method_6194();
        int regen = -1;
        if (player.method_6059(class_1294.field_5924)) {
            regen = ticks % 25;
        }
        int healthRows = class_3532.method_15386((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int comfortSheen = ticks % 50;
        int comfortHeartFrame = comfortSheen % 2;
        int[] textureWidth = new int[]{5, 9};
        RenderSystem.setShaderTexture((int)0, (class_2960)MOD_ICONS_TEXTURE);
        RenderSystem.enableBlend();
        int healthMaxSingleRow = class_3532.method_15386((float)(Math.min(healthMax, 20.0f) / 2.0f));
        int leftHeightOffset = (healthRows - 1) * rowHeight;
        for (int i = 0; i < healthMaxSingleRow; ++i) {
            int column = i % 10;
            int x = left + column * 8;
            int y = top + leftHeightOffset;
            if (health <= 4) {
                y += rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            if (column == comfortSheen / 2) {
                graphics.method_25302(MOD_ICONS_TEXTURE, x, y, 0, 9, textureWidth[comfortHeartFrame], 9);
            }
            if (column != comfortSheen / 2 - 1 || comfortHeartFrame != 0) continue;
            graphics.method_25302(MOD_ICONS_TEXTURE, x + 5, y, 5, 9, 4, 9);
        }
        RenderSystem.disableBlend();
    }

    static {
        MOD_ICONS_TEXTURE = new class_2960("farmersdelight", "textures/gui/fd_icons.png");
    }
}

