/*
 * Decompiled with CFR 0.152.
 */
package com.faux.customentitydata.api.playersaves;

import com.faux.customentitydata.api.playersaves.IPlayerLoadListener;
import com.faux.customentitydata.api.playersaves.IPlayerSaveListener;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CustomPlayerSave
implements IPlayerSaveListener,
IPlayerLoadListener {
    private final class_2960 handlerId;
    private final Logger log;

    public CustomPlayerSave(class_2960 handlerId) {
        this.handlerId = handlerId;
        this.log = LoggerFactory.getLogger((String)handlerId.toString());
        IPlayerLoadListener.EVENT.register((Object)this);
        IPlayerSaveListener.EVENT.register((Object)this);
    }

    public abstract class_2487 savePlayer(class_1657 var1);

    public abstract void loadPlayer(class_1657 var1, class_2487 var2);

    @Override
    public void loadPlayerData(class_1657 player, File saveDir) {
        long startTime = System.nanoTime();
        File customSaveDir = this.getCustomSaveDir(saveDir);
        class_2487 data = new class_2487();
        try {
            File targetSave = new File(customSaveDir, player.method_5845() + ".dat");
            if (targetSave.exists() && targetSave.isFile()) {
                data = class_2507.method_30613((File)targetSave);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to read custom data file for player {} ({}).", new Object[]{player.method_5477().getString(), player.method_5845(), e});
        }
        try {
            this.loadPlayer(player, data);
            long endTime = System.nanoTime();
            this.log.debug("Loaded data for {}. Took {}ns.", (Object)player.method_5477().getString(), (Object)(endTime - startTime));
        }
        catch (Exception e) {
            this.log.error("Failed to read custom data for player {} ({}).", new Object[]{player.method_5477().getString(), player.method_5845(), e});
        }
    }

    @Override
    public void savePlayerData(class_1657 player, File saveDir) {
        try {
            long startTime = System.nanoTime();
            File customSaveDir = this.getCustomSaveDir(saveDir);
            File tempSave = File.createTempFile(player.method_5845() + "-", ".dat", customSaveDir);
            class_2507.method_30614((class_2487)this.savePlayer(player), (File)tempSave);
            File targetSave = new File(customSaveDir, player.method_5845() + ".dat");
            File backupSave = new File(customSaveDir, player.method_5845() + ".dat_old");
            class_156.method_27760((File)targetSave, (File)tempSave, (File)backupSave);
            long endTime = System.nanoTime();
            this.log.debug("Saved data for {}. Took {}ns.", (Object)player.method_5477().getString(), (Object)(endTime - startTime));
        }
        catch (IOException e) {
            this.log.error("Failed to write custom data for player {} ({}).", new Object[]{player.method_5477().getString(), player.method_5845(), e});
        }
    }

    private File getCustomSaveDir(File saveDir) {
        File customSaveDir = new File(new File(saveDir, this.handlerId.method_12836()), this.handlerId.method_12832());
        if (!customSaveDir.exists() && !customSaveDir.mkdirs()) {
            this.log.error("Failed to create custom save directory {}.", (Object)customSaveDir.getPath());
        }
        return customSaveDir;
    }
}

