/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.components;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.gui.screens.ConfigScreen;
import fuzs.forgeconfigscreens.client.gui.screens.SelectConfigWorldScreen;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ConfigWorldSelectionList
extends class_4280<ConfigWorldListEntry> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private static final class_2960 ICON_MISSING = new class_2960("textures/misc/unknown_server.png");
    private static final class_2960 ICON_OVERLAY_LOCATION = new class_2960("textures/gui/world_selection.png");
    private static final class_2561 FROM_NEWER_TOOLTIP_1 = class_2561.method_43471((String)"selectWorld.tooltip.fromNewerVersion1").method_27692(class_124.field_1061);
    private static final class_2561 FROM_NEWER_TOOLTIP_2 = class_2561.method_43471((String)"selectWorld.tooltip.fromNewerVersion2").method_27692(class_124.field_1061);
    private static final class_2561 SNAPSHOT_TOOLTIP_1 = class_2561.method_43471((String)"selectWorld.tooltip.snapshot1").method_27692(class_124.field_1065);
    private static final class_2561 SNAPSHOT_TOOLTIP_2 = class_2561.method_43471((String)"selectWorld.tooltip.snapshot2").method_27692(class_124.field_1065);
    private static final class_2561 WORLD_LOCKED_TOOLTIP = class_2561.method_43471((String)"selectWorld.locked").method_27692(class_124.field_1061);
    private static final class_2561 WORLD_REQUIRES_CONVERSION = class_2561.method_43471((String)"selectWorld.conversion.tooltip").method_27692(class_124.field_1061);
    private static final String SERVER_CONFIG_NAME = "serverconfig";
    private static final Marker CONFIG = MarkerFactory.getMarker((String)"CONFIG");
    private final SelectConfigWorldScreen screen;
    private final List<class_34> levelList;
    private final class_2561 createConfigTooltip;

    public ConfigWorldSelectionList(SelectConfigWorldScreen selectConfigWorldScreen, class_310 minecraft, int width, int height, int y0, int y1, int itemHeight, String query, List<class_34> levelList) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.screen = selectConfigWorldScreen;
        this.levelList = levelList;
        this.createConfigTooltip = class_2561.method_43469((String)"configmenusforge.gui.select.create_config", (Object[])new Object[]{selectConfigWorldScreen.getDisplayName()}).method_27692(class_124.field_1065);
        this.refreshList(query);
    }

    public void refreshList(String query) {
        this.method_25339();
        String s = query.toLowerCase(Locale.ROOT);
        for (class_34 levelsummary : this.levelList) {
            if (!levelsummary.method_252().toLowerCase(Locale.ROOT).contains(s) && !levelsummary.method_248().toLowerCase(Locale.ROOT).contains(s)) continue;
            this.method_25321((class_350.class_351)new ConfigWorldListEntry(this.screen, this.field_22740, levelsummary));
        }
    }

    protected int method_25329() {
        return this.field_22742 / 2 + 144;
    }

    public int method_25322() {
        return 260;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    public void setSelected(@Nullable ConfigWorldListEntry configWorldListEntry) {
        super.method_25313((class_350.class_351)configWorldListEntry);
        this.screen.updateButtonStatus(configWorldListEntry != null && !configWorldListEntry.summary.method_33784());
    }

    public final class ConfigWorldListEntry
    extends class_4280.class_4281<ConfigWorldListEntry>
    implements AutoCloseable {
        final class_34 summary;
        private final SelectConfigWorldScreen screen;
        private final class_310 minecraft;
        private final class_2960 iconLocation;
        @Nullable
        private final class_1043 icon;
        private File iconFile;
        private long lastClickTime;

        public ConfigWorldListEntry(SelectConfigWorldScreen selectConfigWorldScreen, class_310 minecraft, class_34 levelSummary) {
            this.screen = selectConfigWorldScreen;
            this.summary = levelSummary;
            this.minecraft = minecraft;
            String s = levelSummary.method_248();
            this.iconLocation = new class_2960("minecraft", "worlds/" + class_156.method_30309((String)s, class_2960::method_29184) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)s) + "/icon");
            this.iconFile = levelSummary.method_27020().toFile();
            if (!this.iconFile.isFile()) {
                this.iconFile = null;
            }
            this.icon = this.loadServerIcon();
        }

        private static void loadModConfig(ModConfig config, Path configBasePath) {
            ForgeConfigScreens.LOGGER.trace(CONFIG, "Loading config file type {} at {} for {}", new Object[]{config.getType(), config.getFileName(), config.getModId()});
            try {
                Files.createDirectories(configBasePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            CommentedFileConfig configData = (CommentedFileConfig)config.getHandler().reader(configBasePath).apply(config);
            CommonAbstractions.INSTANCE.setConfigData(config, (CommentedConfig)configData);
            config.save();
        }

        public class_2561 method_37006() {
            class_5250 translatablecomponent = class_2561.method_43469((String)"narrator.select.world", (Object[])new Object[]{this.summary.method_252(), new Date(this.summary.method_249()), this.summary.method_257() ? class_2561.method_43471((String)"gameMode.hardcore") : class_2561.method_43471((String)("gameMode." + this.summary.method_247().method_8381())), this.summary.method_259() ? class_2561.method_43471((String)"selectWorld.cheats") : class_2561.method_43473(), this.summary.method_258()});
            class_5250 component = this.summary.method_27021() ? class_5244.method_37111((class_2561[])new class_2561[]{translatablecomponent, WORLD_LOCKED_TOOLTIP}) : translatablecomponent;
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{component});
        }

        public void method_25343(class_332 guiGraphics, int pIndex, int top, int left, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean hovered, float pPartialTicks) {
            Object s = this.summary.method_252();
            String s1 = this.summary.method_248() + " (" + DATE_FORMAT.format(new Date(this.summary.method_249())) + ")";
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = class_1074.method_4662((String)"selectWorld.world", (Object[])new Object[0]) + " " + (pIndex + 1);
            }
            class_2561 component = this.summary.method_27429();
            guiGraphics.method_25303(this.minecraft.field_1772, (String)s, left + 32 + 3, top + 1, 0xFFFFFF);
            guiGraphics.method_25303(this.minecraft.field_1772, s1, left + 32 + 3, top + 9 + 3, 0x808080);
            guiGraphics.method_27535(this.minecraft.field_1772, component, left + 32 + 3, top + 9 + 9 + 3, 0x808080);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            guiGraphics.method_25290(this.icon != null ? this.iconLocation : ICON_MISSING, left, top, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            if (((Boolean)this.minecraft.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                int textureY;
                guiGraphics.method_25294(left, top, left + 32, top + 32, -1601138544);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean leftHovered = pMouseX - left < 32;
                int n = textureY = leftHovered ? 32 : 0;
                if (this.summary.method_27021()) {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, left, top, 96.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_1772.method_1728((class_5348)WORLD_LOCKED_TOOLTIP, 175));
                    }
                } else if (this.summary.method_255()) {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, left, top, 96.0f, 32.0f, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_1772.method_1728((class_5348)WORLD_REQUIRES_CONVERSION, 175));
                    }
                } else if (this.summary.method_256()) {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, left, top, 32.0f, (float)textureY, 32, 32, 256, 256);
                    if (this.summary.method_260()) {
                        guiGraphics.method_25290(ICON_OVERLAY_LOCATION, left, top, 96.0f, (float)textureY, 32, 32, 256, 256);
                        if (leftHovered) {
                            this.screen.setActiveTooltip((List<class_5481>)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.method_30937(), (Object)FROM_NEWER_TOOLTIP_2.method_30937()));
                        }
                    } else if (!class_155.method_16673().method_48022()) {
                        guiGraphics.method_25290(ICON_OVERLAY_LOCATION, left, top, 64.0f, (float)textureY, 32, 32, 256, 256);
                        if (leftHovered) {
                            this.screen.setActiveTooltip((List<class_5481>)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.method_30937(), (Object)SNAPSHOT_TOOLTIP_2.method_30937()));
                        }
                    }
                } else if (!this.fileExists()) {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, left, top, 32.0f, (float)textureY, 32, 32, 256, 256);
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, left, top, 64.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.field_1772.method_1728((class_5348)ConfigWorldSelectionList.this.createConfigTooltip, 200));
                    }
                } else {
                    guiGraphics.method_25290(ICON_OVERLAY_LOCATION, left, top, 0.0f, (float)textureY, 32, 32, 256, 256);
                }
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.summary.method_33784()) {
                return true;
            }
            ConfigWorldSelectionList.this.setSelected(this);
            this.screen.updateButtonStatus(ConfigWorldSelectionList.this.method_25334() != null);
            if (mouseX - (double)ConfigWorldSelectionList.this.method_25342() <= 32.0) {
                this.openConfig();
                return true;
            }
            if (class_156.method_658() - this.lastClickTime < 250L) {
                this.openConfig();
                return true;
            }
            this.lastClickTime = class_156.method_658();
            return false;
        }

        public void openConfig() {
            this.loadModConfig(this.screen.getConfig());
            ConfigScreen configScreen = ConfigScreen.create(this.screen, this.screen.getDisplayName(), this.screen.getConfig(), IEntryData.makeValueToDataMap(this.screen.getConfig()));
            this.minecraft.method_1507((class_437)configScreen);
        }

        public void loadModConfig(ModConfig config) {
            ConfigWorldListEntry.loadModConfig(config, this.getConfigBasePath());
        }

        private Path getConfigBasePath() {
            return this.minecraft.method_1586().method_19636().resolve(this.summary.method_248()).resolve(ConfigWorldSelectionList.SERVER_CONFIG_NAME);
        }

        public boolean fileExists() {
            return Files.exists(this.getConfigBasePath().resolve(this.screen.getConfig().getFileName()), new LinkOption[0]);
        }

        @Nullable
        private class_1043 loadServerIcon() {
            boolean flag;
            boolean bl = flag = this.iconFile != null && this.iconFile.isFile();
            if (flag) {
                try {
                    class_1043 dynamictexture1;
                    try (FileInputStream inputstream = new FileInputStream(this.iconFile);){
                        class_1011 nativeimage = class_1011.method_4309((InputStream)inputstream);
                        Validate.validState((nativeimage.method_4307() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                        Validate.validState((nativeimage.method_4323() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                        class_1043 dynamictexture = new class_1043(nativeimage);
                        this.minecraft.method_1531().method_4616(this.iconLocation, (class_1044)dynamictexture);
                        dynamictexture1 = dynamictexture;
                    }
                    return dynamictexture1;
                }
                catch (Throwable throwable2) {
                    ForgeConfigScreens.LOGGER.error("Invalid icon for world {}", (Object)this.summary.method_248(), (Object)throwable2);
                    this.iconFile = null;
                    return null;
                }
            }
            this.minecraft.method_1531().method_4615(this.iconLocation);
            return null;
        }

        @Override
        public void close() {
            if (this.icon != null) {
                this.icon.close();
            }
        }
    }
}

