/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.config;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2350;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SimpleConfig {
    public final ForgeConfigSpec.ConfigValue<String> stringValue;
    public final ForgeConfigSpec.BooleanValue booleanValue;
    public final ForgeConfigSpec.IntValue intValue;
    public final ForgeConfigSpec.DoubleValue doubleValue;
    public final ForgeConfigSpec.LongValue longValue;
    public final ForgeConfigSpec.EnumValue<class_124> enumValue;
    public final ForgeConfigSpec.ConfigValue<List<? extends Boolean>> booleanListValue;
    public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> intListValue;
    public final ForgeConfigSpec.ConfigValue<List<? extends Long>> longListValue;
    public final ForgeConfigSpec.ConfigValue<List<? extends Double>> doubleListValue;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> stringListValue;
    public final ForgeConfigSpec.ConfigValue<List<? extends Enum<?>>> enumListValue;
    public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> listValue;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final SimpleConfig CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final SimpleConfig COMMON;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final SimpleConfig SERVER;

    public SimpleConfig(ForgeConfigSpec.Builder builder) {
        this.booleanValue = builder.comment("This is a Boolean value").define("booleanValue", false);
        this.intValue = builder.comment("This is an Integer value").defineInRange("int_Value", 5, 0, 10);
        this.longValue = builder.comment("This is a Long value").defineInRange("long_value", 2L, 0L, 10L);
        this.doubleValue = builder.comment("This is a Double value").defineInRange("double_Value", 1.0, 0.0, 10.0);
        this.stringValue = builder.comment("This is an String value").define("stringValue", (Object)"YEP");
        this.enumValue = builder.comment("This is an Enum value").defineEnum("enumValue", (Enum)class_124.field_1068);
        builder.comment("YEP").push("list_properties");
        this.booleanListValue = builder.comment("This is a List of Boolean values").defineList("booleanListValue", (List)Lists.newArrayList((Object[])new Boolean[]{true, true, false, true, false}), o -> true);
        this.intListValue = builder.comment("This is a List of Integer values").defineList("intListValue", (List)Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4, 5}), o -> true);
        this.longListValue = builder.comment("This is a List of Long values").defineList("longListValue", (List)Lists.newArrayList((Object[])new Long[]{0L, 1L, 2L, 3L, 4L, 5L}), o -> true);
        this.doubleListValue = builder.comment("This is a List of Double values").defineList("doubleListValue", (List)Lists.newArrayList((Object[])new Double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0}), o -> true);
        this.stringListValue = builder.comment("This is a List of String values").defineList("stringListValue", (List)Lists.newArrayList((Object[])new String[]{"YEP", "YEP", "YEP"}), o -> true);
        this.enumListValue = builder.comment("This is a List of Enum values").defineList("enumListValue", (List)Lists.newArrayList((Object[])new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039}), o -> true);
        this.listValue = builder.comment("This is a List of unknown values").defineList("unknownListValue", Collections.emptyList(), o -> true);
        builder.pop();
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(SimpleConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (SimpleConfig)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(SimpleConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (SimpleConfig)commonSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(SimpleConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (SimpleConfig)serverSpecPair.getLeft();
    }
}

