/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigPaths;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.core.CommonAbstractions;
import fuzs.forgeconfigscreens.core.NetworkingHelper;
import fuzs.forgeconfigscreens.core.WritableMessage;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class FabricAbstractions
implements CommonAbstractions {
    private final BiMap<Class<? extends WritableMessage>, class_2960> messageRegistry = HashBiMap.create();
    private final AtomicInteger discriminator = new AtomicInteger();

    @Override
    public Optional<String> getModDisplayName(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(ModContainer::getMetadata).map(ModMetadata::getName);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public boolean isClientEnvironment() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public Path getDefaultConfigPath() {
        return FabricLoader.getInstance().getGameDir().resolve(ForgeConfigPaths.INSTANCE.getDefaultConfigsDirectory());
    }

    @Override
    public void fireReloadingEvent(ModConfig modConfig) {
        ((ModConfigEvents.Reloading)ModConfigEvents.reloading((String)modConfig.getModId()).invoker()).onModConfigReloading(modConfig);
    }

    @Override
    public <T extends WritableMessage> void registerClientboundMessage(Class<T> clazz, Supplier<NetworkingHelper.ClientMessageListener<T>> listener) {
        class_2960 channelName = this.registerChannelName(clazz);
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        Function factory = CommonAbstractions.findMessageConstructor(clazz);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)channelName, (client, handler, buf, responseSender) -> client.execute(() -> FabricAbstractions.lambda$registerClientboundMessage$0(client, (Supplier)listener, factory, buf, handler)));
    }

    @Override
    public <T extends WritableMessage> void registerServerboundMessage(Class<T> clazz, Supplier<NetworkingHelper.ServerMessageListener<T>> listener) {
        class_2960 channelName = this.registerChannelName(clazz);
        Function factory = CommonAbstractions.findMessageConstructor(clazz);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)channelName, (server, player, handler, buf, responseSender) -> server.execute(() -> FabricAbstractions.lambda$registerServerboundMessage$2((Supplier)listener, factory, buf, server, handler, player)));
    }

    private <T extends WritableMessage> class_2960 registerChannelName(Class<T> clazz) {
        class_2960 channelName = ForgeConfigScreens.id("play/" + this.discriminator.getAndIncrement());
        this.messageRegistry.put(clazz, (Object)channelName);
        return channelName;
    }

    @Override
    public class_2596<?> toClientboundPacket(WritableMessage message) {
        return this.toPacket(message, ServerPlayNetworking::createS2CPacket);
    }

    @Override
    public class_2596<?> toServerboundPacket(WritableMessage message) {
        return this.toPacket(message, ClientPlayNetworking::createC2SPacket);
    }

    private class_2596<?> toPacket(WritableMessage message, BiFunction<class_2960, class_2540, class_2596<?>> factory) {
        class_2960 identifier = (class_2960)this.messageRegistry.get(message.getClass());
        Objects.requireNonNull(identifier, "identifier for " + message.getClass() + " is null");
        return factory.apply(identifier, (class_2540)class_156.method_654((Object)PacketByteBufs.create(), message::write));
    }

    @Override
    public void registerConfig(String modId, ModConfig.Type type, IConfigSpec<?> spec) {
        ForgeConfigRegistry.INSTANCE.register(modId, type, spec);
    }

    @Override
    public void registerConfig(String modId, ModConfig.Type type, IConfigSpec<?> spec, String fileName) {
        ForgeConfigRegistry.INSTANCE.register(modId, type, spec, fileName);
    }

    private static /* synthetic */ void lambda$registerServerboundMessage$2(Supplier listener, Function factory, class_2540 buf, MinecraftServer server, class_3244 handler, class_3222 player) {
        ((NetworkingHelper.ServerMessageListener)listener.get()).handle((WritableMessage)factory.apply(buf), server, handler, player, player.method_51469());
    }

    private static /* synthetic */ void lambda$registerClientboundMessage$0(class_310 client, Supplier listener, Function factory, class_2540 buf, class_634 handler) {
        class_746 player = client.field_1724;
        Objects.requireNonNull(player, "player is null");
        ((NetworkingHelper.ClientMessageListener)listener.get()).handle((WritableMessage)factory.apply(buf), client, handler, player, client.field_1687);
    }
}

