/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.highlighter;

import com.anthonyhilyard.iceberg.util.ItemColor;
import com.electronwill.nightconfig.core.Config;
import com.google.common.collect.Maps;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5251;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class HighlighterConfig {
    public static final ForgeConfigSpec SPEC;
    public static final HighlighterConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue clearOnInventoryClose;
    public final ForgeConfigSpec.BooleanValue clearOnHover;
    public final ForgeConfigSpec.BooleanValue useItemNameColor;
    public final ForgeConfigSpec.BooleanValue showOnHotbar;
    private static Map<Pair<class_1792, class_2487>, class_5251> colorCache;

    public HighlighterConfig(ForgeConfigSpec.Builder build) {
        ModConfigEvents.reloading((String)"highlighter").register(HighlighterConfig::onReload);
        build.comment("Client Configuration").push("client").push("options");
        this.clearOnInventoryClose = build.comment(" If new item markers should be cleared when the inventory is closed.").define("clear_on_close", true);
        this.clearOnHover = build.comment(" If new item markers should be cleared when the item tooltip is displayed.").define("clear_on_hover", true);
        this.useItemNameColor = build.comment(" If icons should match the color of items names (as shown in tooltips).  Otherwise icons will all be gold.").define("item_name_color", false);
        this.showOnHotbar = build.comment(" If new item markers should show on the hotbar.").define("show_on_hotbar", true);
        build.pop().pop();
    }

    public static class_5251 getColorForItem(class_1799 itemStack, class_5251 defaultColor) {
        Pair key = Pair.of((Object)itemStack.method_7909(), (Object)itemStack.method_7969());
        if (!colorCache.containsKey(key)) {
            class_5251 color = ItemColor.getColorForItem((class_1799)itemStack, (class_5251)defaultColor);
            colorCache.put((Pair<class_1792, class_2487>)key, color);
        }
        return colorCache.get(key);
    }

    public static void onReload(ModConfig config) {
        if (config.getModId().equals("highlighter")) {
            colorCache.clear();
        }
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(HighlighterConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (HighlighterConfig)specPair.getLeft();
        colorCache = Maps.newHashMap();
    }
}

