/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.batching;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4597;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.batching.BatchingBuffer;
import net.raphimc.immediatelyfast.feature.batching.GuiOverlayFirstBatchingBuffer;
import net.raphimc.immediatelyfast.feature.batching.ItemModelBatchingBuffer;
import net.raphimc.immediatelyfast.feature.batching.RenderSystemState;

public class BatchingBuffers {
    public static class_4597 FILL_CONSUMER = null;
    public static class_4597 TEXTURE_CONSUMER = null;
    public static class_4597 TEXT_CONSUMER = null;
    public static class_4597 ITEM_MODEL_CONSUMER = null;
    public static class_4597 ITEM_OVERLAY_CONSUMER = null;
    private static final BatchingBuffer HUD_BATCH = new BatchingBuffer();
    private static final BatchingBuffer DEBUG_HUD_BATCH = new GuiOverlayFirstBatchingBuffer();
    private static final BatchingBuffer ITEM_MODEL_BATCH = new ItemModelBatchingBuffer();
    private static final BatchingBuffer ITEM_OVERLAY_BATCH = new BatchingBuffer();
    private static class_4597 PREV_FILL_CONSUMER = null;
    private static class_4597 PREV_TEXT_CONSUMER = null;
    private static class_4597 PREV_TEXTURE_CONSUMER = null;

    public static void beginHudBatching() {
        BatchingBuffers.beginHudBatching(HUD_BATCH);
    }

    public static void beginDebugHudBatching() {
        BatchingBuffers.beginHudBatching(DEBUG_HUD_BATCH);
    }

    public static void beginHudBatching(BatchingBuffer batch) {
        if (batch.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("HUD batching was already active! endHudBatching() was not called before beginHudBatching(). This will cause rendering issues.");
            batch.close();
        }
        FILL_CONSUMER = batch;
        TEXTURE_CONSUMER = batch;
        TEXT_CONSUMER = batch;
        BatchingBuffers.beginItemModelBatching();
        BatchingBuffers.beginItemOverlayBatching();
    }

    public static void endHudBatching() {
        BatchingBuffers.endHudBatching(HUD_BATCH);
    }

    public static void endDebugHudBatching() {
        BatchingBuffers.endHudBatching(DEBUG_HUD_BATCH);
    }

    public static void endHudBatching(BatchingBuffer batch) {
        FILL_CONSUMER = null;
        TEXTURE_CONSUMER = null;
        TEXT_CONSUMER = null;
        RenderSystemState renderSystemState = RenderSystemState.current();
        batch.method_22993();
        BatchingBuffers.endItemModelBatching();
        BatchingBuffers.endItemOverlayBatching();
        renderSystemState.apply();
    }

    public static boolean isHudBatching() {
        return TEXT_CONSUMER != null || TEXTURE_CONSUMER != null || FILL_CONSUMER != null || ITEM_MODEL_CONSUMER != null || ITEM_OVERLAY_CONSUMER != null;
    }

    public static boolean hasDataToDraw() {
        return HUD_BATCH.hasActiveLayers() || DEBUG_HUD_BATCH.hasActiveLayers() || ITEM_MODEL_BATCH.hasActiveLayers() || ITEM_OVERLAY_BATCH.hasActiveLayers();
    }

    public static void forceDrawBuffers() {
        RenderSystemState renderSystemState = RenderSystemState.current();
        HUD_BATCH.method_22993();
        DEBUG_HUD_BATCH.method_22993();
        ITEM_MODEL_BATCH.method_22993();
        ITEM_OVERLAY_BATCH.method_22993();
        renderSystemState.apply();
    }

    private static void beginItemModelBatching() {
        if (ITEM_MODEL_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Item model batching was already active! endItemModelBatching() was not called before beginItemModelBatching(). This will cause rendering issues.");
            ITEM_MODEL_BATCH.close();
        }
        ITEM_MODEL_CONSUMER = ITEM_MODEL_BATCH;
    }

    private static void endItemModelBatching() {
        ITEM_MODEL_CONSUMER = null;
        ITEM_MODEL_BATCH.method_22993();
    }

    private static void beginItemOverlayBatching() {
        if (ITEM_OVERLAY_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Item overlay batching was already active! endItemOverlayBatching() was not called before beginItemOverlayBatching(). This will cause rendering issues.");
            ITEM_OVERLAY_BATCH.close();
        }
        ITEM_OVERLAY_CONSUMER = ITEM_OVERLAY_BATCH;
    }

    private static void endItemOverlayBatching() {
        ITEM_OVERLAY_CONSUMER = null;
        ITEM_OVERLAY_BATCH.method_22993();
    }

    public static void beginItemOverlayRendering() {
        if (ITEM_OVERLAY_CONSUMER != null) {
            PREV_FILL_CONSUMER = FILL_CONSUMER;
            PREV_TEXT_CONSUMER = TEXT_CONSUMER;
            PREV_TEXTURE_CONSUMER = TEXTURE_CONSUMER;
            FILL_CONSUMER = ITEM_OVERLAY_CONSUMER;
            TEXT_CONSUMER = ITEM_OVERLAY_CONSUMER;
            TEXTURE_CONSUMER = ITEM_OVERLAY_CONSUMER;
        }
    }

    public static void endItemOverlayRendering() {
        if (ITEM_OVERLAY_CONSUMER != null) {
            FILL_CONSUMER = PREV_FILL_CONSUMER;
            TEXT_CONSUMER = PREV_TEXT_CONSUMER;
            TEXTURE_CONSUMER = PREV_TEXTURE_CONSUMER;
        }
    }

    public static Map<class_1921, class_287> createLayerBuffers(class_1921 ... layers) {
        Object2ObjectLinkedOpenHashMap layerBuffers = new Object2ObjectLinkedOpenHashMap(layers.length);
        for (class_1921 layer : layers) {
            layerBuffers.put((Object)layer, (Object)new class_287(layer.method_22722()));
        }
        return layerBuffers;
    }
}

