/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5819;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.JadeFont;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.gui.WailaConfigScreen;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.SmoothChasingValue;

public class HomeConfigScreen
extends class_437 {
    private final class_5819 random = class_5819.method_43049((long)42L);
    private final class_437 parent;
    private final SmoothChasingValue titleY;
    private final SmoothChasingValue creditHover;
    private final class_2561 credit;
    private final List<TextParticle> particles = Lists.newArrayList();
    private int creditWidth;
    private boolean hovered;
    private float ticks;
    private byte festival;

    public HomeConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.jade.configuration"));
        this.parent = parent;
        this.titleY = new SmoothChasingValue().start(8.0f).target(32.0f).withSpeed(0.1f);
        this.creditHover = new SmoothChasingValue();
        LocalDate now = LocalDate.now();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        if (month == 12 && day >= 24 && day <= 26) {
            this.festival = 1;
        } else if (month == 6 && day == 28) {
            this.festival = (byte)2;
        } else {
            Int2IntOpenHashMap newyears = new Int2IntOpenHashMap();
            newyears.put(2024, 210);
            newyears.put(2025, 129);
            newyears.put(2026, 217);
            newyears.put(2027, 206);
            newyears.put(2028, 126);
            newyears.put(2029, 213);
            newyears.put(2030, 203);
            newyears.put(2031, 123);
            newyears.put(2032, 211);
            newyears.put(2033, 131);
            newyears.put(2034, 219);
            newyears.put(2035, 208);
            newyears.put(2036, 128);
            newyears.put(2037, 215);
            newyears.put(2038, 204);
            newyears.put(2039, 124);
            newyears.put(2040, 212);
            newyears.put(2041, 201);
            newyears.put(2042, 122);
            newyears.put(2043, 210);
            int year = now.getYear();
            if (newyears.containsKey(year)) {
                int newyearMonth = newyears.get(year) / 100;
                int newyearDay = newyears.get(year) % 100;
                LocalDate newyearDate = LocalDate.of(year, newyearMonth, newyearDay);
                int newyearDayofyear = newyearDate.getDayOfYear();
                int dayofyear = now.getDayOfYear();
                if (dayofyear >= newyearDayofyear - 1 && dayofyear <= newyearDayofyear + 2) {
                    this.festival = (byte)99;
                }
            }
        }
        this.credit = class_2561.method_43469((String)"gui.jade.by", (Object[])new Object[]{class_2561.method_43470((String)"\u2764").method_27692(class_124.field_1061)}).method_27694(s -> {
            if (this.festival != 0) {
                s = s.method_36139(15852452);
            }
            return s;
        });
    }

    protected void method_25426() {
        Objects.requireNonNull(this.field_22787);
        this.creditWidth = this.field_22793.method_27525((class_5348)this.credit);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.jade.jade_settings"), w -> this.field_22787.method_1507((class_437)new WailaConfigScreen(this))).method_46434(this.field_22789 / 2 - 105, this.field_22790 / 2 - 10, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.jade.plugin_settings"), w -> this.field_22787.method_1507((class_437)new PluginsConfigScreen(this))).method_46434(this.field_22789 / 2 + 5, this.field_22790 / 2 - 10, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, w -> this.method_25419()).method_46434(this.field_22789 / 2 - 50, this.field_22790 / 2 + 20, 100, 20).method_46431());
    }

    public void method_25419() {
        Jade.CONFIG.save();
        PluginConfig.INSTANCE.save();
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        boolean hover;
        float scaledY;
        float scaledX;
        Objects.requireNonNull(this.field_22787);
        this.ticks += partialTicks;
        this.method_25420(guiGraphics);
        boolean smallUI = this.field_22787.method_22683().method_4495() < 3.0;
        int left = this.field_22789 / 2 - 105;
        int top = this.field_22790 / 4 - 20;
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)left, (float)top, 0.0f);
        float scale = smallUI ? 2.0f : 1.5f;
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_25303(this.field_22793, ModIdentification.getModName("jade"), 0, 0, 0xFFFFFF);
        guiGraphics.method_51448().method_22905(0.5f, 0.5f, 0.5f);
        this.titleY.tick(partialTicks);
        String desc2 = class_1074.method_4662((String)"gui.jade.configuration.desc2", (Object[])new Object[0]);
        if (desc2.isEmpty()) {
            guiGraphics.method_51448().method_22909();
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416((float)left, (float)top, 0.0f);
            scaledX = x - left;
            scaledY = y - top;
        } else {
            scaledX = (float)(x - left) / scale * 2.0f;
            scaledY = (float)(y - top) / scale * 2.0f;
        }
        this.drawFancyTitle(guiGraphics, class_1074.method_4662((String)"gui.jade.configuration.desc1", (Object[])new Object[0]), Math.min(this.titleY.value, 20.0f), 20.0f, scaledX, scaledY);
        if (!desc2.isEmpty()) {
            this.drawFancyTitle(guiGraphics, desc2, this.titleY.value, 32.0f, scaledX, scaledY);
        }
        guiGraphics.method_51448().method_22909();
        super.method_25394(guiGraphics, x, y, partialTicks);
        int creditX = (int)((float)this.field_22789 * 0.5f - (float)this.creditWidth * 0.5f);
        int creditY = (int)((float)this.field_22790 * 0.9f - 5.0f);
        boolean bl = hover = x >= creditX && x < creditX + this.creditWidth && y >= creditY && y < creditY + 10;
        if (!this.hovered && hover) {
            this.creditHover.target(1.0f);
        } else if (!hover) {
            this.creditHover.target(0.0f);
        } else if ((double)this.creditHover.value > 0.5) {
            this.creditHover.target(0.0f);
            IntArrayList colors = new IntArrayList();
            String text = "\u2744";
            if (this.festival == 2) {
                for (int i = 0; i < 11; ++i) {
                    colors.add(class_3532.method_15369((float)this.random.method_43057(), (float)0.8f, (float)0.9f));
                }
                text = "\u2764";
            } else if (this.festival == 1) {
                IntList palette = IntList.of((int[])new int[]{14083301, 14083301, 0xEFF5F5, 0xEFF5F5, 4813172, 15426624});
                for (int i = 0; i < 11; ++i) {
                    colors.add(palette.getInt(this.random.method_43048(palette.size())));
                }
            } else if (this.festival == 99) {
                for (int i = 0; i < 11; ++i) {
                    colors.add(this.random.method_43056() ? 0xA80000 : 12589056);
                }
                text = "\u2710";
            } else {
                for (int i = 0; i < 11; ++i) {
                    colors.add(class_3532.method_15353((float)(1.0f - this.random.method_43057() * 0.6f), (float)1.0f, (float)1.0f));
                }
            }
            IntListIterator intListIterator = colors.iterator();
            while (intListIterator.hasNext()) {
                int color = (Integer)intListIterator.next();
                int ox = this.random.method_39332(-this.creditWidth / 2, this.creditWidth / 2);
                TextParticle particle = new TextParticle(text, (float)this.field_22789 * 0.5f + (float)ox, creditY + this.random.method_43048(10), (float)ox * 0.08f, -5.0f - this.random.method_43057() * 3.0f, color, 0.75f + this.random.method_43057() * 0.5f);
                this.particles.add(particle);
                if (this.festival != 99) continue;
                particle.age = 8.0f + this.random.method_43057() * 5.0f;
            }
        }
        this.creditHover.tick(partialTicks);
        this.creditHover.value = Math.min(0.6f, this.creditHover.value);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)this.field_22789 * 0.5f, (float)creditY, 0.0f);
        scale = 1.0f + this.creditHover.value * 0.2f;
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51448().method_46416((float)this.creditWidth * -0.5f, 0.0f, 0.0f);
        guiGraphics.method_27535(this.field_22793, this.credit, 0, 0, 0x55FFFFFF);
        guiGraphics.method_51448().method_22909();
        this.hovered = hover;
        this.particles.removeIf(p -> {
            p.tick(partialTicks);
            if (p.y > (float)this.field_22790) {
                return true;
            }
            p.render(guiGraphics, this.field_22793);
            return false;
        });
    }

    private void drawFancyTitle(class_332 guiGraphics, String text, float y, float expectY, float mouseX, float mouseY) {
        float distY = Math.abs(y - expectY);
        if (distY >= 9.0f) {
            return;
        }
        int color = IWailaConfig.IConfigOverlay.applyAlpha(0xAAAAAA, 1.0f - distY / 10.0f);
        ((JadeFont)this.field_22793).jade$setGlint((this.ticks - y / 5.0f) % 90.0f / 45.0f * (float)this.field_22789, mouseX);
        ((JadeFont)this.field_22793).jade$setGlintStrength(1.0f, 1.0f - class_3532.method_15363((float)(Math.abs(mouseY - y) / 20.0f), (float)0.0f, (float)1.0f));
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, y, 0.0f);
        guiGraphics.method_25303(this.field_22793, text, 0, 0, color);
        guiGraphics.method_51448().method_22909();
        ((JadeFont)this.field_22793).jade$setGlint(Float.NaN, Float.NaN);
    }

    private class TextParticle {
        private float age;
        private String text;
        private float x;
        private float y;
        private float motionX;
        private float motionY;
        private int color;
        private float scale;

        public TextParticle(String text, float x, float y, float motionX, float motionY, int color, float scale) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.motionX = motionX;
            this.motionY = motionY;
            this.color = color;
            this.scale = scale;
        }

        private void tick(float partialTicks) {
            this.x += this.motionX * partialTicks;
            this.y += this.motionY * partialTicks;
            this.motionY += 0.98f * partialTicks;
            if (HomeConfigScreen.this.festival == 99) {
                boolean geaterThanZero = this.age > 0.0f;
                this.age -= partialTicks;
                if (geaterThanZero && this.age <= 0.0f) {
                    this.text = HomeConfigScreen.this.random.method_43056() ? "\u2734" : "\u2733";
                    this.color = HomeConfigScreen.this.random.method_43056() ? 16765991 : 15778837;
                    Objects.requireNonNull(HomeConfigScreen.this.field_22787);
                    HomeConfigScreen.this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)(HomeConfigScreen.this.random.method_43056() ? class_3417.field_14917 : class_3417.field_15188), (float)0.7f));
                }
            }
        }

        private void render(class_332 guiGraphics, class_327 font) {
            if (HomeConfigScreen.this.festival == 99 && this.age < -4.0f) {
                return;
            }
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(this.x, this.y, 0.0f);
            guiGraphics.method_51448().method_22905(this.scale, this.scale, this.scale);
            guiGraphics.method_25303(font, this.text, 0, 0, this.color);
            guiGraphics.method_51448().method_22909();
        }
    }
}

