/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.IconUI;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.Color;

public class DisplayHelper
implements IDisplayHelper {
    public static final DisplayHelper INSTANCE = new DisplayHelper();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_2960 GUI_ICONS_LOCATION = new class_2960("textures/gui/icons.png");
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final Pattern STRIP_COLOR = Pattern.compile("(?i)\u00a7[0-9A-F]");
    public static DecimalFormat dfCommas = new DecimalFormat("0.##");
    public static final DecimalFormat[] dfCommasArray;
    private static boolean betterTextShadow;

    private static void renderGuiItemDecorations(class_332 guiGraphics, class_327 font, class_1799 stack, int i, int j, @Nullable String text) {
        if (stack.method_7960()) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        if (stack.method_7947() != 1 || text != null) {
            String s = text == null ? INSTANCE.humanReadableNumber(stack.method_7947(), "", false, null) : text;
            boolean smaller = s.length() > 3;
            float scale = smaller ? 0.5f : 0.75f;
            int x = smaller ? 32 : 22;
            int y = smaller ? 23 : 13;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
            int color = IThemeHelper.get().theme().itemAmountColor;
            guiGraphics.method_51433(font, s, i + x - font.method_1727(s), j + y, color, true);
            guiGraphics.method_51448().method_22909();
        }
        if (stack.method_31578()) {
            RenderSystem.disableDepthTest();
            int k = stack.method_31579();
            int l = stack.method_31580();
            int m = i + 2;
            int n = j + 13;
            guiGraphics.method_51739(class_1921.method_51785(), m, n, m + 13, n + 2, -16777216);
            guiGraphics.method_51739(class_1921.method_51785(), m, n, m + k, n + 1, l | 0xFF000000);
        }
        guiGraphics.method_51448().method_22909();
        ClientProxy.renderItemDecorationsExtra(guiGraphics, font, stack, i, j, text);
    }

    public static void drawTexturedModalRect(class_332 guiGraphics, float x, float y, int textureX, int textureY, int width, int height, int tw, int th) {
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(matrix, x, y + (float)height, zLevel).method_22913((float)textureX * f, (float)(textureY + th) * f1).method_1344();
        buffer.method_22918(matrix, x + (float)width, y + (float)height, zLevel).method_22913((float)(textureX + tw) * f, (float)(textureY + th) * f1).method_1344();
        buffer.method_22918(matrix, x + (float)width, y, zLevel).method_22913((float)(textureX + tw) * f, (float)textureY * f1).method_1344();
        buffer.method_22918(matrix, x, y, zLevel).method_22913((float)textureX * f, (float)textureY * f1).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    public static void renderIcon(class_332 guiGraphics, float x, float y, int sx, int sy, IconUI icon) {
        if (icon == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)OverlayRenderer.alpha);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_ICONS_LOCATION);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (icon.bu != -1) {
            DisplayHelper.drawTexturedModalRect(guiGraphics, x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayHelper.drawTexturedModalRect(guiGraphics, x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, class_1058 textureSprite, float maskTop, float maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= maskRight / 16.0f * (uMax - uMin);
        vMax -= maskTop / 16.0f * (vMax - vMin);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - maskRight, yCoord + maskTop, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord + maskTop, zLevel).method_22913(uMin, vMin).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void fill(class_332 guiGraphics, float minX, float minY, float maxX, float maxY, int color) {
        DisplayHelper.fill(guiGraphics.method_51448().method_23760().method_23761(), minX, minY, maxX, maxY, color);
    }

    private static void fill(Matrix4f matrix, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferbuilder.method_22918(matrix, minX, maxY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, maxX, maxY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, maxX, minY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, minX, minY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static boolean enableBetterTextShadow() {
        return betterTextShadow;
    }

    public static void setBetterTextShadow(boolean betterTextShadow) {
        DisplayHelper.betterTextShadow = betterTextShadow;
    }

    @Override
    public void drawItem(class_332 guiGraphics, float x, float y, class_1799 stack, float scale, @Nullable String text) {
        if (OverlayRenderer.alpha < 0.5f) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x, y, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51445(stack, 0, 0);
        DisplayHelper.renderGuiItemDecorations(guiGraphics, DisplayHelper.CLIENT.field_1772, stack, 0, 0, text);
        guiGraphics.method_51448().method_22909();
    }

    @Override
    public void drawGradientRect(class_332 guiGraphics, float left, float top, float width, float height, int startColor, int endColor) {
        this.drawGradientRect(guiGraphics, left, top, width, height, startColor, endColor, false);
    }

    public void drawGradientRect(class_332 guiGraphics, float left, float top, float width, float height, int startColor, int endColor, boolean horizontal) {
        if (startColor == -1 && endColor == -1) {
            return;
        }
        float zLevel = 0.0f;
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f * OverlayRenderer.alpha;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        if (horizontal) {
            buffer.method_22918(matrix, left + width, top, zLevel).method_22915(f5, f6, f7, f4).method_1344();
            buffer.method_22918(matrix, left, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top + height, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left + width, top + height, zLevel).method_22915(f5, f6, f7, f4).method_1344();
        } else {
            buffer.method_22918(matrix, left + width, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top + height, zLevel).method_22915(f5, f6, f7, f4).method_1344();
            buffer.method_22918(matrix, left + width, top + height, zLevel).method_22915(f5, f6, f7, f4).method_1344();
        }
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
        RenderSystem.disableBlend();
    }

    @Override
    public void drawBorder(class_332 guiGraphics, float minX, float minY, float maxX, float maxY, float width, int color, boolean corner) {
        DisplayHelper.fill(guiGraphics, minX + width, minY, maxX - width, minY + width, color);
        DisplayHelper.fill(guiGraphics, minX + width, maxY - width, maxX - width, maxY, color);
        if (corner) {
            DisplayHelper.fill(guiGraphics, minX, minY, minX + width, maxY, color);
            DisplayHelper.fill(guiGraphics, maxX - width, minY, maxX, maxY, color);
        } else {
            DisplayHelper.fill(guiGraphics, minX, minY + width, minX + width, maxY - width, color);
            DisplayHelper.fill(guiGraphics, maxX - width, minY + width, maxX, maxY - width, color);
        }
    }

    public void drawFluid(class_332 guiGraphics, float xPosition, float yPosition, JadeFluidObject fluid, float width, float height, long capacityMb) {
        if (fluid.isEmpty()) {
            return;
        }
        long amount = JadeFluidObject.bucketVolume();
        MutableFloat scaledAmount = new MutableFloat((float)amount * height / (float)capacityMb);
        if (amount > 0L && scaledAmount.floatValue() < 1.0f) {
            scaledAmount.setValue(1.0f);
        }
        if (scaledAmount.floatValue() > height) {
            scaledAmount.setValue(height);
        }
        ClientProxy.getFluidSpriteAndColor(fluid, (sprite, color) -> {
            if (sprite == null) {
                float maxY = yPosition + height;
                if (color == -1) {
                    color = -1431655766;
                }
                DisplayHelper.fill(guiGraphics, xPosition, maxY - scaledAmount.floatValue(), xPosition + width, maxY, (int)color);
            } else {
                if (OverlayRenderer.alpha != 1.0f) {
                    color = IWailaConfig.IConfigOverlay.applyAlpha(color, OverlayRenderer.alpha);
                }
                this.drawTiledSprite(guiGraphics, xPosition, yPosition, width, height, (int)color, scaledAmount.floatValue(), (class_1058)sprite);
            }
        });
    }

    private void drawTiledSprite(class_332 guiGraphics, float xPosition, float yPosition, float tiledWidth, float tiledHeight, int color, float scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        DisplayHelper.setGLColorFromInt(color);
        RenderSystem.enableBlend();
        int xTileCount = (int)(tiledWidth / 16.0f);
        float xRemainder = tiledWidth - (float)(xTileCount * 16);
        int yTileCount = (int)(scaledAmount / 16.0f);
        float yRemainder = scaledAmount - (float)(yTileCount * 16);
        float yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float width = xTile == xTileCount ? xRemainder : 16.0f;
                float height = yTile == yTileCount ? yRemainder : 16.0f;
                float x = xPosition + (float)(xTile * 16);
                float y = yStart - (float)((yTile + 1) * 16);
                if (!(width > 0.0f) || !(height > 0.0f)) continue;
                float maskTop = 16.0f - height;
                float maskRight = 16.0f - width;
                DisplayHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 0.0f);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli) {
        return this.humanReadableNumber(number, unit, milli, dfCommas);
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli, @Nullable Format formatter) {
        boolean n;
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        int exp = 0;
        if (number < 1000.0 || formatter == null && number < 10000.0) {
            formatter = dfCommasArray[2];
        } else {
            exp = (int)Math.log10(number) / 3;
            if (exp > 7) {
                exp = 7;
            }
            if (exp > 0) {
                number /= Math.pow(1000.0, exp);
            }
            if (formatter == null) {
                formatter = number < 10.0 ? dfCommasArray[0] : (number < 100.0 ? dfCommasArray[1] : dfCommasArray[2]);
            }
        }
        if (formatter instanceof NumberFormat) {
            NumberFormat numberFormat = (NumberFormat)formatter;
            sb.append(numberFormat.format(number));
        } else {
            sb.append(formatter.format(new Object[]{number}));
        }
        if (exp == 0) {
            if (milli && number != 0.0) {
                sb.append('m');
            }
        } else {
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }

    @Override
    public void drawText(class_332 guiGraphics, String text, float x, float y, int color) {
        this.drawText(guiGraphics, (class_5348)class_2561.method_43470((String)text), x, y, color);
    }

    @Override
    public void drawText(class_332 guiGraphics, class_5348 text, float x, float y, int color) {
        class_5481 sequence;
        if (text instanceof class_2561) {
            class_2561 component = (class_2561)text;
            sequence = component.method_30937();
        } else {
            sequence = class_2477.method_10517().method_30934(text);
        }
        this.drawText(guiGraphics, sequence, x, y, color);
    }

    @Override
    public void drawText(class_332 guiGraphics, class_5481 text, float x, float y, int color) {
        boolean shadow = Jade.CONFIG.get().getOverlay().getTheme().textShadow;
        if (OverlayRenderer.alpha != 1.0f) {
            color = IWailaConfig.IConfigOverlay.applyAlpha(color, OverlayRenderer.alpha);
        }
        betterTextShadow = true;
        guiGraphics.method_51430(DisplayHelper.CLIENT.field_1772, text, (int)x, (int)y, color, shadow);
        betterTextShadow = false;
    }

    public void drawGradientProgress(class_332 guiGraphics, float left, float top, float width, float height, float progress, int progressColor) {
        Color color = Color.rgb(progressColor);
        Color highlight = Color.hsl(color.getHue(), color.getSaturation(), Math.min(color.getLightness() + 0.2, 1.0), color.getOpacity());
        if (progress < 0.1f) {
            this.drawGradientRect(guiGraphics, left, top, width * progress, height, progressColor, highlight.toInt(), true);
        } else {
            float hlWidth = width * 0.1f;
            float normalWidth = width * progress - hlWidth;
            DisplayHelper.fill(guiGraphics, left, top, left + normalWidth, top + height, progressColor);
            this.drawGradientRect(guiGraphics, left + normalWidth, top, hlWidth, height, progressColor, highlight.toInt(), true);
        }
    }

    @Override
    public class_5250 stripColor(class_2561 component) {
        class_5250 mutableComponent = class_2561.method_43473();
        component.method_27658((style, string) -> {
            if (!string.isEmpty()) {
                class_5250 literal = class_2561.method_43470((String)STRIP_COLOR.matcher(string).replaceAll(""));
                literal.method_27696(style.method_27703((class_5251)null));
                mutableComponent.method_10852((class_2561)literal);
            }
            return Optional.empty();
        }, class_2583.field_24360);
        return mutableComponent;
    }

    static {
        for (DecimalFormat format : dfCommasArray = new DecimalFormat[]{dfCommas, new DecimalFormat("0.#"), new DecimalFormat("0")}) {
            format.setRoundingMode(RoundingMode.DOWN);
        }
    }
}

