/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mindfuldarkness.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.mindfuldarkness.MindfulDarkness;
import fuzs.mindfuldarkness.client.gui.screens.PixelConfigScreen;
import fuzs.mindfuldarkness.client.handler.ColorChangedAssetsManager;
import fuzs.mindfuldarkness.client.util.ScreenIdentifierHelper;
import fuzs.mindfuldarkness.config.ClientConfig;
import fuzs.mindfuldarkness.mixin.client.accessor.AbstractContainerMenuAccessor;
import fuzs.puzzleslib.api.client.screen.v2.ScreenHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_518;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DaytimeSwitcherHandler {
    public static final class_2960 TEXTURE_LOCATION = MindfulDarkness.id("textures/gui/daytime_switcher.png");
    private static class_339[] buttons;

    public static void onEndTick(class_310 minecraft) {
        DaytimeSwitcherHandler.setHorizontalButtonPosition(minecraft.field_1755);
    }

    public static void onAfterMouseClick(class_437 screen, double mouseX, double mouseY, int button) {
        DaytimeSwitcherHandler.setHorizontalButtonPosition(screen);
    }

    private static void setHorizontalButtonPosition(class_437 screen) {
        if (buttons == null) {
            return;
        }
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            if (screen instanceof class_518) {
                int leftPos = ScreenHelper.INSTANCE.getLeftPos(containerScreen);
                int imageWidth = ScreenHelper.INSTANCE.getImageWidth(containerScreen);
                buttons[0].method_46421(leftPos + imageWidth - 3 - 21);
                buttons[1].method_46421(leftPos + imageWidth - 3 - 40);
                buttons[2].method_46421(leftPos + imageWidth - 3 - 68);
                buttons[3].method_46421(leftPos + imageWidth - 3 - 95);
            }
        }
    }

    public static EventResult onScreenOpening(@Nullable class_437 oldScreen, DefaultedValue<class_437> newScreen) {
        String identifier;
        class_437 screen = (class_437)newScreen.get();
        if (screen == null) {
            buttons = null;
        }
        class_310 minecraft = class_310.method_1551();
        if (screen != null && ((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).debugAllScreens && (identifier = ScreenIdentifierHelper.getScreenIdentifier(screen)) != null) {
            class_5250 message = class_2561.method_43469((String)"screen.debug.identifier", (Object[])new Object[]{class_2564.method_10885((class_2561)class_2561.method_43470((String)identifier))});
            if (minecraft.field_1687 != null) {
                minecraft.field_1705.method_1743().method_1812((class_2561)message);
            } else {
                MindfulDarkness.LOGGER.info(message.getString());
            }
        }
        if (screen instanceof class_465) {
            class_3917<?> type;
            class_465 containerScreen = (class_465)screen;
            if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).debugContainerTypes && (type = ((AbstractContainerMenuAccessor)containerScreen.method_17577()).mindfuldarkness$getMenuType()) != null) {
                class_5250 component = class_2561.method_43470((String)class_7923.field_41187.method_10221(type).toString());
                class_5250 message = class_2561.method_43469((String)"screen.debug.menuType", (Object[])new Object[]{class_2564.method_10885((class_2561)component)});
                minecraft.field_1705.method_1743().method_1812((class_2561)message);
            }
        }
        return EventResult.PASS;
    }

    public static void onDrawBackground(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY) {
        if (DaytimeSwitcherHandler.supportsDaytimeSwitcher(screen)) {
            int leftPos = ScreenHelper.INSTANCE.getLeftPos(screen);
            int topPos = ScreenHelper.INSTANCE.getTopPos(screen);
            int imageWidth = ScreenHelper.INSTANCE.getImageWidth(screen);
            DaytimeSwitcherHandler.drawThemeBg(guiGraphics, leftPos, topPos, imageWidth);
        }
    }

    public static void drawThemeBg(class_332 guiGraphics, int leftPos, int topPos, int imageWidth) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25290(TEXTURE_LOCATION, leftPos + imageWidth - 3 - 101, topPos - 24, 0.0f, 226.0f, 101, 24, 256, 256);
    }

    private static boolean supportsDaytimeSwitcher(class_465<?> containerScreen) {
        if (((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).hideInGameSwitcher) {
            return false;
        }
        if (containerScreen.field_22790 >= ScreenHelper.INSTANCE.getImageHeight(containerScreen) + 48) {
            if (containerScreen instanceof class_481) {
                return false;
            }
            class_3917<?> type = ((AbstractContainerMenuAccessor)containerScreen.method_17577()).mindfuldarkness$getMenuType();
            return type == null || !((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).menuBlacklist.contains(type);
        }
        return false;
    }

    public static void onAfterInit(class_310 minecraft, class_437 screen, int screenWidth, int screenHeight, List<class_339> widgets, Consumer<class_339> addWidget, Consumer<class_339> removeWidget) {
        class_465 containerScreen;
        if (screen instanceof class_465 && DaytimeSwitcherHandler.supportsDaytimeSwitcher(containerScreen = (class_465)screen)) {
            int leftPos = ScreenHelper.INSTANCE.getLeftPos(containerScreen);
            int topPos = ScreenHelper.INSTANCE.getTopPos(containerScreen);
            int imageWidth = ScreenHelper.INSTANCE.getImageWidth(containerScreen);
            for (class_339 button : buttons = DaytimeSwitcherHandler.makeButtons(minecraft, screen, leftPos, topPos, imageWidth)) {
                addWidget.accept(button);
            }
        }
    }

    public static class_339[] makeButtons(class_310 minecraft, class_437 screen, int leftPos, int topPos, int imageWidth) {
        class_339[] abstractWidgets;
        abstractWidgets = new class_339[]{new class_344(leftPos + imageWidth - 3 - 21, topPos - 18, 15, 15, 224, 0, TEXTURE_LOCATION, button -> screen.method_25419()), new class_344(leftPos + imageWidth - 3 - 40, topPos - 18, 15, 15, 239, 0, TEXTURE_LOCATION, button -> {
            if (screen instanceof PixelConfigScreen) {
                PixelConfigScreen pixelConfigScreen = (PixelConfigScreen)screen;
                pixelConfigScreen.closeToLastScreen();
            } else {
                minecraft.method_1507((class_437)new PixelConfigScreen(screen));
            }
        }), new class_344(leftPos + imageWidth - 3 - 68, topPos - 20, 24, 19, 200, 0, TEXTURE_LOCATION, button -> DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], true)), new class_344(leftPos + imageWidth - 3 - 95, topPos - 20, 24, 19, 176, 0, TEXTURE_LOCATION, button -> DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], true))};
        DaytimeSwitcherHandler.toggleThemeButtons(abstractWidgets[3], abstractWidgets[2], false);
        return abstractWidgets;
    }

    private static void toggleThemeButtons(class_339 lightThemeWidget, class_339 darkThemeWidget, boolean toggleSetting) {
        boolean darkTheme;
        if (toggleSetting) {
            DaytimeSwitcherHandler.activateDaytimeSwitch();
        }
        lightThemeWidget.field_22763 = darkTheme = ((Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get()).booleanValue();
        darkThemeWidget.field_22763 = !darkTheme;
    }

    public static void activateDaytimeSwitch() {
        boolean darkTheme = (Boolean)((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.get();
        darkTheme = !darkTheme;
        ((ClientConfig)MindfulDarkness.CONFIG.get(ClientConfig.class)).darkTheme.set((Object)darkTheme);
        ColorChangedAssetsManager.INSTANCE.recordedReset();
    }
}

