/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.barrel;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.util.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5616;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class BarrelRenderer
implements class_827<BarrelBlockEntity> {
    private final int itemNameColor;

    public static void register(class_2591<? extends BarrelBlockEntity> type, int itemNameColor) {
        class_5616.method_32144(type, context -> new BarrelRenderer(itemNameColor));
    }

    public BarrelRenderer(int itemNameColor) {
        this.itemNameColor = itemNameColor;
    }

    public void render(@NotNull BarrelBlockEntity entity, float tickDelta, @NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int light, int overlay) {
        if (entity.isLocked()) {
            RenderHelper.drawLockedTexture(entity, matrices, vertexConsumers, this.itemNameColor);
        }
        if (!MIConfig.getConfig().enableBarrelContentRendering) {
            return;
        }
        class_2680 state = entity.method_11010();
        class_2338 pos = entity.method_11016();
        ItemVariant item = (ItemVariant)entity.getResource();
        if (!item.isBlank()) {
            String amount = entity.behaviour.isCreative() ? "\u221e" : String.valueOf(entity.getAmount());
            class_1799 toRender = item.toStack();
            for (int i = 0; i < 4; ++i) {
                class_2350 direction = class_2350.method_10139((int)i);
                if (entity.method_10997() != null && !class_2248.method_9607((class_2680)state, (class_1922)entity.method_10997(), (class_2338)pos, (class_2350)direction, (class_2338)pos.method_10093(direction))) continue;
                Object itemName = toRender.method_7964().getString();
                matrices.method_22903();
                class_327 textRenderer = class_310.method_1551().field_1772;
                matrices.method_22904(0.5, 1.14, 0.5);
                matrices.method_22907(class_7833.field_40716.rotationDegrees((float)(2 - i) * 90.0f));
                matrices.method_22904(0.0, 0.15, -0.505);
                matrices.method_22905(-0.01f, -0.01f, -0.01f);
                int maxWidth = 100;
                if (textRenderer.method_1727((String)itemName) > 100) {
                    itemName = textRenderer.method_27523((String)itemName, 100 - textRenderer.method_1727("...")) + "...";
                }
                float xPosition = -textRenderer.method_1727((String)itemName) / 2;
                textRenderer.method_27521((String)itemName, xPosition, 36.0f, this.itemNameColor, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_22904(0.5, 0.0, 0.5);
                matrices.method_22907(class_7833.field_40716.rotationDegrees((float)(-i) * 90.0f));
                matrices.method_22905(0.5f, 0.5f, 0.5f);
                matrices.method_22904(0.0, 1.125, 1.01);
                matrices.method_23760().method_23761().scale(1.0f, 1.0f, 0.01f);
                matrices.method_23760().method_23762().rotate(0.7853982f, -1.0f, 0.0f, 0.0f);
                class_310.method_1551().method_1480().method_23178(toRender, class_811.field_4317, 0xF000F0, class_4608.field_21444, matrices, vertexConsumers, entity.method_10997(), 0);
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_22904(0.5, 0.5, 0.5);
                matrices.method_22907(class_7833.field_40716.rotationDegrees((float)(2 - i) * 90.0f));
                matrices.method_22904(0.0, 0.0875, -0.505);
                matrices.method_22905(-0.01f, -0.01f, -0.01f);
                xPosition = -textRenderer.method_1727(amount) / 2;
                textRenderer.method_27521(amount, xPosition, 36.0f, 0, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
                matrices.method_22909();
            }
        }
    }
}

