/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank;

import aztech.modern_industrialization.blocks.storage.tank.AbstractTankBlockEntity;
import aztech.modern_industrialization.util.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2591;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5616;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class TankRenderer
implements class_827<AbstractTankBlockEntity> {
    private final int lockIconColor;

    public static void register(class_2591<? extends AbstractTankBlockEntity> type, int lockIconColor) {
        class_5616.method_32144(type, context -> new TankRenderer(lockIconColor));
    }

    private TankRenderer(int lockIconColor) {
        this.lockIconColor = lockIconColor;
    }

    public void render(AbstractTankBlockEntity tank, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (!((FluidVariant)tank.getResource()).isBlank()) {
            if (tank.behaviour.isCreative()) {
                RenderHelper.drawFluidInTank(tank, matrices, vertexConsumers, (FluidVariant)tank.getResource(), 1.0f);
            } else if (tank.getAmount() > 0L) {
                RenderHelper.drawFluidInTank(tank, matrices, vertexConsumers, (FluidVariant)tank.getResource(), (float)tank.getAmount() / (float)tank.getCapacity());
            } else if (tank.isLocked()) {
                RenderHelper.drawFluidInTank(tank, matrices, vertexConsumers, (FluidVariant)tank.getResource(), 0.01f);
            }
        }
        if (tank.isLocked()) {
            RenderHelper.drawLockedTexture(tank, matrices, vertexConsumers, this.lockIconColor);
        }
    }
}

