/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import aztech.modern_industrialization.recipe.json.RecipeJson;
import aztech.modern_industrialization.recipe.json.ShapelessRecipeJson;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class UpgradeProvider
extends MIRecipesProvider {
    private static final String[] STEEL_UPGRADE_MACHINES = new String[]{"compressor", "macerator", "cutting_machine", "water_pump", "mixer", "furnace", "boiler"};
    private static final Set<String> STEEL_NO_UNPACKER = Set.of("furnace", "boiler");
    private static final List<String> QUANTUM_ITEMS = List.of("helmet", "chestplate", "leggings", "boots", "sword");

    public UpgradeProvider(FabricDataOutput packOutput) {
        super(packOutput);
    }

    public void method_10419(Consumer<class_2444> consumer) {
        this.buildSteelUpgrades(consumer);
        this.buildQuantumUpgrades(consumer);
    }

    private void buildSteelUpgrades(Consumer<class_2444> consumer) {
        class_1792 upgrade = (class_1792)class_7923.field_41178.method_10223((class_2960)new MIIdentifier("steel_upgrade"));
        for (String machine : STEEL_UPGRADE_MACHINES) {
            class_1792 bronze = (class_1792)class_7923.field_41178.method_10223((class_2960)new MIIdentifier("bronze_" + machine));
            class_1792 steel = (class_1792)class_7923.field_41178.method_10223((class_2960)new MIIdentifier("steel_" + machine));
            ShapelessRecipeJson recipe = new ShapelessRecipeJson((class_1935)steel, 1).addIngredient((class_1935)bronze).addIngredient((class_1935)upgrade);
            recipe.offerTo(consumer, "upgrade/craft/steel/" + machine);
            Object recipePacker = ((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.PACKER, 2, 100).addItemInput((class_1935)bronze, 1).addItemInput((class_1935)upgrade, 1)).addItemOutput(steel, 1);
            ((RecipeJson)recipePacker).offerTo(consumer, "upgrade/packer/steel/" + machine);
            if (STEEL_NO_UNPACKER.contains(machine)) continue;
            Object recipeUnpacker = ((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.UNPACKER, 2, 100).addItemOutput(bronze, 1).addItemOutput(upgrade, 1)).addItemInput((class_1935)steel, 1);
            ((RecipeJson)recipeUnpacker).offerTo(consumer, "upgrade/unpacker/steel/" + machine);
        }
    }

    private void buildQuantumUpgrades(Consumer<class_2444> consumer) {
        for (String itemType : QUANTUM_ITEMS) {
            Object packerRecipe = ((MIRecipeJson)MIRecipeJson.create(MIMachineRecipeTypes.PACKER, 1000000, 200).addItemInput("minecraft:netherite_" + itemType, 1).addItemInput("modern_industrialization:quantum_upgrade", 1)).addItemOutput("modern_industrialization:quantum_" + itemType, 1);
            ((RecipeJson)packerRecipe).offerTo(consumer, "upgrade/packer/quantum/" + itemType);
        }
    }
}

