/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.RecipeEfficiencyBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public class ElectricCraftingMachineBlockEntity
extends AbstractCraftingMachineBlockEntity
implements EnergyComponentHolder {
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing = new CasingComponent();
    private final UpgradeComponent upgrades = new UpgradeComponent();
    private final EnergyComponent energy = new EnergyComponent((class_2586)this, this.casing::getEuCapacity);
    private final MIEnergyStorage insertable = this.energy.buildInsertable(cableTier -> this.casing.canInsertEu((CableTier)cableTier));

    public ElectricCraftingMachineBlockEntity(BEP bep, MachineRecipeType recipeType, MachineInventoryComponent inventory, MachineGuiParameters guiParams, EnergyBar.Parameters energyBarParams, ProgressBar.Parameters progressBarParams, RecipeEfficiencyBar.Parameters efficiencyBarParams, MachineTier tier, long euCapacity) {
        super(bep, recipeType, inventory, guiParams, progressBarParams, tier);
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(energyBarParams, this.energy::getEu, this.energy::getCapacity);
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new RecipeEfficiencyBar.Server(efficiencyBarParams, this.crafter));
        this.registerGuiComponent(new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withCasing(this.casing));
        this.registerComponents(this.redstoneControl, this.casing, this.upgrades, this.energy);
    }

    @Override
    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation(this);
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        return this.energy.consumeEu(max, simulation);
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        this.orientation.writeModelData(data);
        data.isActive = this.isActiveComponent.isActive;
        return data;
    }

    public static void registerEnergyApi(class_2591<?> bet) {
        EnergyApi.SIDED.registerForBlockEntities((be, direction) -> ((ElectricCraftingMachineBlockEntity)be).insertable, new class_2591[]{bet});
    }

    @Override
    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        class_1269 result = super.onUse(player, hand, face);
        if (!result.method_23665()) {
            result = this.redstoneControl.onUse(this, player, hand);
        }
        if (!result.method_23665()) {
            result = this.casing.onUse(this, player, hand);
        }
        if (!result.method_23665()) {
            result = this.upgrades.onUse(this, player, hand);
        }
        if (!result.method_23665()) {
            result = LubricantHelper.onUse(this.crafter, player, hand);
        }
        return result;
    }

    @Override
    public long getMaxRecipeEu() {
        return (long)this.tier.getMaxEu() + this.upgrades.getAddMaxEUPerTick();
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }
}

