/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class LargeTankFluidDisplay {

    public record Data(FluidVariant fluid, long amount, long capacity) {
    }

    public static class Server
    implements GuiComponent.Server<Data> {
        public final Supplier<Data> fluidDataSupplier;

        public Server(Supplier<Data> fluidDataSupplier) {
            this.fluidDataSupplier = fluidDataSupplier;
        }

        @Override
        public Data copyData() {
            return this.fluidDataSupplier.get();
        }

        @Override
        public boolean needsSync(Data cachedData) {
            Data newFluidData = this.fluidDataSupplier.get();
            return !cachedData.equals(newFluidData);
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            Data fluidData = this.fluidDataSupplier.get();
            fluidData.fluid.toPacket(buf);
            buf.writeLong(fluidData.amount);
            buf.writeLong(fluidData.capacity);
        }

        @Override
        public class_2960 getId() {
            return GuiComponents.LARGE_TANK_FLUID_DISPLAY;
        }
    }
}

