/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.util.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class SlotPanelClient
implements GuiComponentClient {
    private final List<SlotPanel.SlotType> slotTypes = new ArrayList<SlotPanel.SlotType>();

    public SlotPanelClient(class_2540 buf) {
        int slotCount = buf.method_10816();
        for (int i = 0; i < slotCount; ++i) {
            this.slotTypes.add((SlotPanel.SlotType)buf.method_10818(SlotPanel.SlotType.class));
        }
    }

    @Override
    public void readCurrentData(class_2540 buf) {
    }

    @Override
    public void setupMenu(final GuiComponent.MenuFacade menu) {
        for (int i = 0; i < this.slotTypes.size(); ++i) {
            final SlotPanel.SlotType type = this.slotTypes.get(i);
            @Environment(value=EnvType.CLIENT)
            class ClientSlot
            extends SlotWithBackground
            implements SlotTooltip {
                public ClientSlot(int i) {
                    super((class_1263)new class_1277(1), 0, SlotPanel.getSlotX(menuFacade.getGuiParams()), SlotPanel.getSlotY(i));
                }

                public boolean method_7680(class_1799 stack) {
                    return type.mayPlace(stack);
                }

                public int method_7675() {
                    return type.slotLimit;
                }

                @Override
                public int getBackgroundU() {
                    return !this.method_7681() ? type.u : 0;
                }

                @Override
                public int getBackgroundV() {
                    return !this.method_7681() ? type.v : 0;
                }

                @Override
                public class_2561 getTooltip() {
                    return MITooltips.line(type.tooltip).build();
                }
            }
            menu.addSlotToMenu(new ClientSlot(i), type.group);
        }
    }

    @Override
    public ClientComponentRenderer createRenderer(final MachineScreen machineScreen) {
        return new ClientComponentRenderer(){

            private Rectangle getBox(int leftPos, int topPos) {
                return new Rectangle(leftPos + machineScreen.getGuiParams().backgroundWidth, topPos + 10, 31, 14 + 20 * SlotPanelClient.this.slotTypes.size());
            }

            @Override
            public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
                rectangles.add(this.getBox(leftPos, topPos));
            }

            @Override
            public void renderBackground(class_332 guiGraphics, int x, int y) {
                Rectangle box = this.getBox(x, y);
                int textureX = box.x() - x - box.w();
                guiGraphics.method_25302(MachineScreen.BACKGROUND, box.x(), box.y(), textureX, 0, box.w(), box.h() - 4);
                guiGraphics.method_25302(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, textureX, 252, box.w(), 4);
            }

            @Override
            public void renderTooltip(MachineScreen screen, class_327 font, class_332 guiGraphics, int x, int y, int cursorX, int cursorY) {
                class_1735 class_17352 = screen.getFocusedSlot();
                if (class_17352 instanceof SlotTooltip) {
                    SlotTooltip st = (SlotTooltip)class_17352;
                    if (!screen.getFocusedSlot().method_7681()) {
                        guiGraphics.method_51438(font, st.getTooltip(), cursorX, cursorY);
                    }
                }
            }
        };
    }

    @Environment(value=EnvType.CLIENT)
    public static class SlotWithBackground
    extends class_1735
    implements BackgroundRenderedSlot {
        public SlotWithBackground(class_1263 container, int index, int x, int y) {
            super(container, index, x, y);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static interface SlotTooltip {
        public class_2561 getTooltip();
    }
}

