/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3736;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import virtuoel.pehkui.api.PehkuiConfig;
import virtuoel.pehkui.util.MulticonnectCompatibility;
import virtuoel.pehkui.util.PehkuiBlockStateExtensions;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @ModifyArg(method={"getEyeHeight"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getActiveEyeHeight(Lnet/minecraft/entity/EntityPose;Lnet/minecraft/entity/EntityDimensions;)F"))
    private class_4048 pehkui$getEyeHeight$dimensions(class_4048 dimensions) {
        return dimensions.method_18383(1.0f / ScaleUtils.getEyeHeightScale((class_1297)this));
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(floatValue=1.0f, ordinal=0)})
    private float pehkui$travel$fallDistance(float value) {
        float scale = ScaleUtils.getFallingScale((class_1297)this);
        if (scale != 1.0f && PehkuiConfig.COMMON.scaledFallDamage.get().booleanValue()) {
            return value / scale;
        }
        return value;
    }

    @Inject(method={"getEyeHeight"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$getEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> info) {
        float scale;
        if (pose != class_4050.field_18078 && (scale = ScaleUtils.getEyeHeightScale((class_1297)this)) != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setVelocity(DDD)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void pehkui$tickMovement$minVelocity(CallbackInfo info, class_243 velocity) {
        class_1309 self = (class_1309)this;
        float scale = ScaleUtils.getMotionScale((class_1297)self);
        if (scale < 1.0f) {
            double min = (double)scale * MulticonnectCompatibility.INSTANCE.getProtocolDependantValue(ver -> ver <= 47, 0.005, 0.003);
            double vX = velocity.field_1352;
            double vY = velocity.field_1351;
            double vZ = velocity.field_1350;
            if (Math.abs(vX) < min) {
                vX = 0.0;
            }
            if (Math.abs(vY) < min) {
                vY = 0.0;
            }
            if (Math.abs(vZ) < min) {
                vZ = 0.0;
            }
            self.method_18800(vX, vY, vZ);
        }
    }

    @ModifyVariable(method={"applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"}, at=@At(value="HEAD"), argsOnly=true)
    private float pehkui$applyArmorToDamage(float value, class_1282 source, float amount) {
        class_1297 attacker = source.method_5529();
        float attackScale = attacker == null ? 1.0f : ScaleUtils.getAttackScale(attacker);
        float defenseScale = ScaleUtils.getDefenseScale((class_1297)this);
        if (attackScale != 1.0f || defenseScale != 1.0f) {
            value = attackScale * value / defenseScale;
        }
        return value;
    }

    @Inject(method={"getMaxHealth"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$getMaxHealth(CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getHealthScale((class_1297)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @Inject(method={"getAttackDistanceScalingFactor"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$getAttackDistanceScalingFactor(@Nullable class_1297 entity, CallbackInfoReturnable<Double> info) {
        float scale = ScaleUtils.getVisibilityScale((class_1297)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)(info.getReturnValueD() * (double)scale));
        }
    }

    @Inject(method={"getJumpVelocity"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$getJumpVelocity(CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getJumpHeightScale((class_1297)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @Inject(method={"applyClimbingSpeed(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"}, at={@At(value="RETURN")}, cancellable=true)
    private void pehkui$applyClimbingSpeed(class_243 motion, CallbackInfoReturnable<class_243> info) {
        class_1309 self = (class_1309)this;
        if (!self.method_6101()) {
            return;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((class_1297)self);
        if (width > 1.0f) {
            class_238 bounds = self.method_5829();
            double halfUnscaledXLength = bounds.method_17939() / (double)width / 2.0;
            int minX = class_3532.method_15357((double)(bounds.field_1323 + halfUnscaledXLength));
            int maxX = class_3532.method_15357((double)(bounds.field_1320 - halfUnscaledXLength));
            int minY = class_3532.method_15357((double)bounds.field_1322);
            double halfUnscaledZLength = bounds.method_17941() / (double)width / 2.0;
            int minZ = class_3532.method_15357((double)(bounds.field_1321 + halfUnscaledZLength));
            int maxZ = class_3532.method_15357((double)(bounds.field_1324 - halfUnscaledZLength));
            for (class_2338 pos : class_2338.method_10094((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!(((PehkuiBlockStateExtensions)self.method_5770().method_8320(pos)).pehkui_getBlock() instanceof class_3736)) continue;
                class_243 prev = (class_243)info.getReturnValue();
                info.setReturnValue((Object)new class_243(prev.field_1352, Math.max(self.method_18798().field_1351, -0.15), prev.field_1350));
                break;
            }
        }
    }

    @Redirect(method={"tickCramming"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getBoundingBox()Lnet/minecraft/util/math/Box;"))
    private class_238 pehkui$tickCramming$getBoundingBox(class_1309 obj) {
        class_238 bounds = obj.method_5829();
        float interactionWidth = ScaleUtils.getInteractionBoxWidthScale((class_1297)obj);
        float interactionHeight = ScaleUtils.getInteractionBoxHeightScale((class_1297)obj);
        if (interactionWidth != 1.0f || interactionHeight != 1.0f) {
            double scaledXLength = bounds.method_17939() * 0.5 * (double)(interactionWidth - 1.0f);
            double scaledYLength = bounds.method_17940() * 0.5 * (double)(interactionHeight - 1.0f);
            double scaledZLength = bounds.method_17941() * 0.5 * (double)(interactionWidth - 1.0f);
            return bounds.method_1009(scaledXLength, scaledYLength, scaledZLength);
        }
        return bounds;
    }
}

