/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.config.Config;
import nx.pingwheel.common.networking.UpdateChannelPacketC2S;

public class ConfigHandler {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath;
    private Config config;
    private int configHash;

    public ConfigHandler(String configName, Path configDir) {
        this.configPath = configDir.resolve(configName);
        this.configHash = 0;
        this.config = new Config();
    }

    public void save() {
        if (this.configHash == this.config.hashCode()) {
            return;
        }
        new UpdateChannelPacketC2S(this.config.getChannel()).send();
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
                Files.createFile(this.configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                Global.LOGGER.error("Creating Config failed: " + e);
                return;
            }
        }
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);
            this.gson.toJson((Object)this.config, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            Global.LOGGER.error("Saving Config failed: " + e);
            return;
        }
        this.configHash = this.config.hashCode();
        Global.LOGGER.info("Saved " + this.config);
    }

    public void load() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.save();
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(this.configPath);
            this.config = (Config)this.gson.fromJson((Reader)reader, Config.class);
            reader.close();
        }
        catch (Exception e) {
            this.config = null;
        }
        if (this.config == null) {
            this.config = new Config();
            Global.LOGGER.error("Config is broken -> reset to defaults");
            this.save();
            return;
        }
        this.config.validate();
        this.configHash = this.config.hashCode();
        Global.LOGGER.info("Loaded " + this.config);
    }

    public Config getConfig() {
        return this.config;
    }
}

