/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3222;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.networking.PingLocationPacketC2S;
import nx.pingwheel.common.networking.PingLocationPacketS2C;
import nx.pingwheel.common.networking.UpdateChannelPacketC2S;

public class ServerCore {
    private static final HashMap<UUID, String> playerChannels = new HashMap();

    private ServerCore() {
    }

    public static void onPlayerDisconnect(class_3222 player) {
        playerChannels.remove(player.method_5667());
    }

    public static void onChannelUpdate(class_3222 player, class_2540 packet) {
        Optional<UpdateChannelPacketC2S> channelUpdatePacket = UpdateChannelPacketC2S.parse(packet);
        if (channelUpdatePacket.isEmpty()) {
            Global.LOGGER.warn("invalid channel update from " + String.format("%s (%s)", player.method_7334().getName(), player.method_5667()));
            player.method_7353(class_2561.method_30163((String)("\u00a7c[Ping-Wheel] Channel couldn't be updated. Make sure your version matches the server's version: " + Global.ModVersion)), false);
            return;
        }
        ServerCore.updatePlayerChannel(player, channelUpdatePacket.get().getChannel());
    }

    public static void onPingLocation(class_3222 player, class_2540 packet) {
        class_2540 packetCopy = new class_2540(packet.copy());
        Optional<PingLocationPacketC2S> pingLocationPacket = PingLocationPacketC2S.parse(packet);
        if (pingLocationPacket.isEmpty()) {
            Global.LOGGER.warn("invalid ping location from " + String.format("%s (%s)", player.method_7334().getName(), player.method_5667()));
            player.method_7353(class_2561.method_30163((String)("\u00a7c[Ping-Wheel] Ping couldn't be sent. Make sure your version matches the server's version: " + Global.ModVersion)), false);
            return;
        }
        String channel = pingLocationPacket.get().getChannel();
        if (!channel.equals(playerChannels.getOrDefault(player.method_5667(), ""))) {
            ServerCore.updatePlayerChannel(player, channel);
        }
        packetCopy.method_10797(player.method_5667());
        for (class_3222 p : player.method_51469().method_18456()) {
            if (!channel.equals(playerChannels.getOrDefault(p.method_5667(), ""))) continue;
            p.field_13987.method_14364((class_2596)new class_2658(PingLocationPacketS2C.ID, packetCopy));
        }
    }

    private static void updatePlayerChannel(class_3222 player, String channel) {
        if (channel.isEmpty()) {
            playerChannels.remove(player.method_5667());
            Global.LOGGER.info("Channel update: " + String.format("%s -> Global", player.method_7334().getName()));
        } else {
            playerChannels.put(player.method_5667(), channel);
            Global.LOGGER.info("Channel update: " + String.format("%s -> \"%s\"", player.method_7334().getName(), channel));
        }
    }
}

