/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.furnator;

import dev.architectury.hooks.item.ItemStackHooks;
import dev.architectury.registry.fuel.FuelRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.furnator.FurnatorBlock;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.util.Ticker;

public class FurnatorTile
extends AbstractEnergyProvider<FurnatorBlock>
implements IInventoryHolder {
    protected final Ticker carbon = Ticker.empty();
    protected boolean burning;

    public FurnatorTile(class_2338 pos, class_2680 state, Tier variant) {
        super(Tiles.FURNATOR.get(), pos, state, variant);
        this.inv.set(2);
    }

    public FurnatorTile(class_2338 pos, class_2680 state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readStorable(class_2487 nbt) {
        super.readStorable(nbt);
        this.carbon.read(nbt, "carbon");
    }

    @Override
    public class_2487 writeStorable(class_2487 nbt) {
        this.carbon.write(nbt, "carbon");
        return super.writeStorable(nbt);
    }

    @Override
    public void readSync(class_2487 nbt) {
        super.readSync(nbt);
        this.burning = nbt.method_10577("burning");
    }

    @Override
    public class_2487 writeSync(class_2487 nbt) {
        nbt.method_10556("burning", this.burning);
        return super.writeSync(nbt);
    }

    @Override
    protected int postTick(class_1937 world) {
        if (!this.isRemote() && this.checkRedstone()) {
            int burnTime;
            class_1799 stack;
            boolean flag = false;
            if (this.carbon.isEmpty() && !(stack = this.inv.getStackInSlot(1)).method_7960() && (burnTime = FuelRegistry.get((class_1799)stack)) > 0) {
                long perFuelTick = Powah.config().general.energy_per_fuel_tick;
                this.carbon.setAll((long)burnTime * perFuelTick);
                if (ItemStackHooks.hasCraftingRemainingItem((class_1799)stack)) {
                    this.inv.setStackInSlot(1, ItemStackHooks.getCraftingRemainingItem((class_1799)stack));
                } else {
                    stack.method_7934(1);
                }
                this.sync(4);
            }
            if (!this.carbon.isEmpty() && !this.energy.isFull()) {
                long toProduce = Math.min(this.energy.getEmpty(), Math.min(this.getGeneration(), (long)this.carbon.getTicks()));
                this.energy.produce(toProduce);
                this.carbon.back(toProduce);
                if (this.carbon.isEmpty()) {
                    this.carbon.setAll(0.0);
                }
                flag = true;
                this.sync(4);
            }
            if (this.burning != flag) {
                this.burning = flag;
                this.sync(4);
            }
        }
        return this.chargeItems(1) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public boolean canInsert(int index, class_1799 stack) {
        return index == 1 && FuelRegistry.get((class_1799)stack) > 0 || index == 0 && Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return true;
    }

    public Ticker getCarbon() {
        return this.carbon;
    }

    public boolean isBurning() {
        return this.burning;
    }
}

