/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.fabric.compat.rei;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.LiquidBlockHooks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.api.PowahAPI;
import owmii.powah.fabric.compat.rei.HeatSourceCategory;

public class HeatSourceDisplay
implements Display {
    private final List<EntryIngredient> inputs;
    private final int heat;

    public HeatSourceDisplay(Recipe recipe) {
        this.inputs = recipe.fluid == null ? List.of(EntryIngredients.of((class_1935)recipe.getBlock())) : List.of(EntryIngredients.of((class_3611)recipe.fluid));
        this.heat = recipe.getHeat();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return Collections.emptyList();
    }

    public CategoryIdentifier<HeatSourceDisplay> getCategoryIdentifier() {
        return HeatSourceCategory.ID;
    }

    public int getHeat() {
        return this.heat;
    }

    public static class Recipe {
        private final class_2248 block;
        private final int heat;
        @Nullable
        private final class_3611 fluid;

        public Recipe(class_2248 block, int heat) {
            if (block instanceof class_2404) {
                class_2404 liquidBlock = (class_2404)block;
                this.fluid = LiquidBlockHooks.getFluid((class_2404)liquidBlock);
            } else {
                this.fluid = null;
            }
            this.block = block;
            this.heat = heat;
            Powah.LOGGER.debug("HEAT SOURCE RECIPE INIT: " + this);
        }

        @Nullable
        public class_3611 getFluid() {
            return this.fluid;
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public int getHeat() {
            return this.heat;
        }

        public String toString() {
            return "HeatSourceRecipe{" + class_7923.field_41175.method_10221((Object)this.block) + (String)(this.fluid != null ? " (fluid " + class_7923.field_41173.method_10221((Object)this.fluid) + ")" : "") + " -> " + this.heat + "}";
        }
    }

    public static class Maker {
        public static List<Recipe> getBucketRecipes() {
            List<class_1799> allItemStacks = EntryRegistry.getInstance().getEntryStacks().filter(stack -> Objects.equals(stack.getType(), VanillaEntryTypes.ITEM)).map(EntryStack::castValue).toList();
            ArrayList<Recipe> recipes = new ArrayList<Recipe>();
            Powah.LOGGER.debug("HEAT SOURCE RECIPE ALL: [" + PowahAPI.HEAT_SOURCES.entrySet().stream().map(e -> e.getKey() + " -> " + e.getValue()).collect(Collectors.joining(", ")) + "]");
            allItemStacks.forEach(stack -> {
                class_1747 item;
                class_2248 block;
                if (stack.method_7909() instanceof class_1747 && PowahAPI.HEAT_SOURCES.containsKey(block = (item = (class_1747)stack.method_7909()).method_7711())) {
                    recipes.add(new Recipe(block, PowahAPI.getHeatSource(block)));
                }
            });
            List<FluidStack> allIngredients = EntryRegistry.getInstance().getEntryStacks().filter(stack -> Objects.equals(stack.getType(), VanillaEntryTypes.FLUID)).map(EntryStack::castValue).toList();
            allIngredients.forEach(fluidStack -> {
                class_2248 block;
                if (!fluidStack.isEmpty() && PowahAPI.HEAT_SOURCES.containsKey(block = fluidStack.getFluid().method_15785().method_15759().method_26204())) {
                    recipes.add(new Recipe(block, PowahAPI.getHeatSource(block)));
                }
            });
            return recipes;
        }
    }
}

