/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import owmii.powah.EnvHandler;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.item.Stacks;
import owmii.powah.lib.logistics.inventory.ItemHandlerHelper;
import owmii.powah.lib.logistics.inventory.ItemStackHandler;
import owmii.powah.lib.util.Util;

public class Inventory
extends ItemStackHandler {
    @Nullable
    private IInventoryHolder tile;
    private Object platformWrapper;
    private boolean sendUpdates = true;

    public Inventory(int size) {
        this(size, null);
    }

    public Inventory(Stacks stacks) {
        this(stacks, null);
    }

    public Inventory(Stacks stacks, @Nullable IInventoryHolder tile) {
        super(stacks);
        this.tile = tile;
    }

    Inventory(int size, @Nullable IInventoryHolder tile) {
        super(size);
        this.tile = tile;
    }

    public static <I extends AbstractTileEntity> Inventory create(int size, @Nullable I tile) {
        return new Inventory(size, (IInventoryHolder)((Object)tile));
    }

    public static <I extends AbstractTileEntity> Inventory createBlank(@Nullable I tile) {
        return new Inventory(0, (IInventoryHolder)((Object)tile));
    }

    public static Inventory create(int size) {
        return new Inventory(size, null);
    }

    public static Inventory createBlank() {
        return new Inventory(0, null);
    }

    public void setTile(@Nullable IInventoryHolder tile) {
        this.tile = tile;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        if (this.isBlank()) {
            return;
        }
        nbt.method_10569("Size", this.getSlots());
        super.deserializeNBT(nbt);
    }

    @Override
    public class_2487 serializeNBT() {
        return this.isBlank() ? new class_2487() : super.serializeNBT();
    }

    public Inventory set(int size) {
        this.stacks = Stacks.withSize(size, class_1799.field_8037);
        this.onContentsChanged(0);
        return this;
    }

    public Inventory add(int size) {
        this.stacks = Stacks.withSize(size + this.stacks.size(), class_1799.field_8037);
        return this;
    }

    public Stacks canPut(Stacks outputs, int ... slots) {
        return this.canPut(outputs, this.fromSlotArray(slots));
    }

    public Stacks canPut(Stacks outputs, Stacks slots) {
        Inventory inv = new Inventory(Stacks.from(slots).copy());
        Iterator iterator = outputs.iterator();
        while (iterator.hasNext()) {
            class_1799 stack = (class_1799)iterator.next();
            if (ItemHandlerHelper.insertItem(inv, stack.method_7972(), false).method_7960()) continue;
            return Stacks.create();
        }
        return inv.getStacks();
    }

    public Stacks fromSlotArray(int ... slots) {
        Stacks stacks = Stacks.create();
        for (int i : slots) {
            stacks.add(this.getStackInSlot(i));
        }
        return stacks;
    }

    @Override
    public int getSlotLimit(int slot) {
        if (this.tile != null) {
            return this.tile.getSlotLimit(slot);
        }
        return super.getSlotLimit(slot);
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        if (this.tile != null) {
            return this.tile.canInsert(slot, stack);
        }
        return super.isItemValid(slot, stack);
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        return this.canExtract(slot, this.getStackInSlot(slot)) ? super.extractItem(slot, amount, simulate) : class_1799.field_8037;
    }

    public class_1799 extractItemFromSlot(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public boolean canExtract(int slot, class_1799 stack) {
        if (this.tile != null) {
            return this.tile.canExtract(slot, stack);
        }
        return true;
    }

    public void setSendUpdates(boolean sendUpdates) {
        this.sendUpdates = sendUpdates;
    }

    @Override
    public void onContentsChanged(int slot) {
        if (this.tile != null && this.sendUpdates) {
            this.tile.onSlotChanged(slot);
        }
    }

    public class_1799 getFirst() {
        return this.getStackInSlot(0);
    }

    public class_1799 getLast() {
        return this.getStackInSlot(this.getLastSlot());
    }

    public int getLastSlot() {
        return this.getSlots() - 1;
    }

    public Stacks getLast(int count) {
        Stacks stacks = Stacks.create();
        int size = this.stacks.size();
        for (int i = size - count; i < count; ++i) {
            stacks.add((class_1799)this.stacks.get(i));
        }
        return stacks;
    }

    public boolean isEmpty() {
        for (class_1799 stack : this.stacks) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (class_1799 stack : this.stacks) {
            if (stack.method_7947() >= stack.method_7914()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEmptySlot() {
        for (class_1799 stack : this.stacks) {
            if (!stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    public boolean isSlotEmpty(int slot) {
        return ((class_1799)this.stacks.get(slot)).method_7960();
    }

    public class_1799 setSlotEmpty(int slot) {
        class_1799 stack = (class_1799)this.stacks.set(slot, (Object)class_1799.field_8037);
        this.onContentsChanged(slot);
        return stack;
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        class_1799 stack1 = (class_1799)this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public void clear() {
        this.set(this.getSlots());
    }

    public boolean isBlank() {
        return this.stacks.size() <= 0;
    }

    public Stacks getStacks() {
        return Stacks.from((class_2371<class_1799>)this.stacks);
    }

    public List<class_1799> getNonEmptyStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>((Collection<class_1799>)this.stacks);
        stacks.removeIf(class_1799::method_7960);
        return stacks;
    }

    public class_1799 addNext(class_1799 stack) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!this.isItemValid(i, stack)) continue;
            this.insertItem(i, stack.method_7972(), false);
            return stack.method_7972();
        }
        return class_1799.field_8037;
    }

    public class_1799 removeNext() {
        for (int i = this.getSlots() - 1; i >= 0; --i) {
            class_1799 stack = this.setSlotEmpty(i);
            if (stack.method_7960()) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public class_1799 insertItem(class_1799 stack, boolean simulate, int ... ex) {
        if (stack.method_7960()) {
            return stack;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (Util.anyMatch(ex, i) || !(stack = this.insertItem(i, stack, simulate)).method_7960()) continue;
            return class_1799.field_8037;
        }
        return stack;
    }

    public void drop(class_1937 world, class_2338 pos) {
        this.stacks.forEach(stack -> class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack));
        this.clear();
    }

    public void drop(int index, class_1937 world, class_2338 pos) {
        class_1799 stack = this.getStackInSlot(index);
        if (!stack.method_7960()) {
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack);
            this.setStackInSlot(index, class_1799.field_8037);
        }
    }

    public static int calcRedstone(ItemStackHandler inv) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            class_1799 itemstack = inv.getStackInSlot(j);
            if (itemstack.method_7960()) continue;
            f += (float)itemstack.method_7947() / (float)Math.min(inv.getSlotLimit(j), itemstack.method_7914());
            ++i;
        }
        return class_3532.method_15375((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public Object getPlatformWrapper() {
        if (this.platformWrapper == null) {
            this.platformWrapper = EnvHandler.INSTANCE.createInvWrapper(this);
        }
        return this.platformWrapper;
    }
}

