/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.IField;
import com.minelittlepony.common.client.gui.ScrollContainer;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.element.AbstractSlider;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.client.gui.element.EnumSlider;
import com.minelittlepony.common.client.gui.element.Label;
import com.minelittlepony.common.client.gui.element.Slider;
import com.minelittlepony.common.client.gui.element.Toggle;
import eu.ha3.mc.quick.update.Versions;
import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.VolumeOption;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.util.BlockReport;
import eu.ha3.presencefootsteps.util.ResourceUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5375;
import org.jetbrains.annotations.Nullable;

class PFOptionsScreen
extends GameGui {
    public static final class_2561 TITLE = class_2561.method_43471((String)"menu.pf.title");
    public static final class_2561 UP_TO_DATE = class_2561.method_43471((String)"pf.update.up_to_date");
    public static final class_2561 VOLUME_MIN = class_2561.method_43471((String)"menu.pf.volume.min");
    private final ScrollContainer content = new ScrollContainer();

    public PFOptionsScreen(@Nullable class_437 parent) {
        super((class_2561)class_2561.method_43469((String)"%s (%s)", (Object[])new Object[]{TITLE, PresenceFootsteps.getInstance().getOptionsKeyBinding().method_16007()}), parent);
        this.content.margin.top = 30;
        this.content.margin.bottom = 30;
        this.content.getContentPadding().top = 10;
        this.content.getContentPadding().right = 10;
        this.content.getContentPadding().bottom = 20;
        this.content.getContentPadding().left = 10;
    }

    protected void method_25426() {
        this.content.init(this::rebuildContent);
    }

    private void rebuildContent() {
        int left = this.content.field_22789 / 2 - 100;
        int wideLeft = this.content.field_22789 / 2 - 165;
        int wideRight = wideLeft + 160;
        int row = 0;
        PFConfig config = PresenceFootsteps.getInstance().getConfig();
        this.getChildElements().add(this.content);
        ((Label)this.addButton((class_364)new Label(this.field_22789 / 2, 10))).setCentered().getStyle().setText(this.method_25440());
        this.redrawUpdateButton(((Button)this.addButton((class_364)new Button(this.field_22789 - 30, this.field_22790 - 25, 25, 20))).onClick(sender -> {
            sender.setEnabled(false);
            sender.getStyle().setTooltip("pf.update.checking");
            PresenceFootsteps.getInstance().getUpdateChecker().checkNow().thenAccept(newVersions -> this.redrawUpdateButton((Button)sender));
        }));
        Toggle disabledToggle = new Toggle(wideLeft, row, config.getDisabled());
        ((Toggle)this.content.addButton((class_364)disabledToggle.onChange(disabled -> {
            this.updateDisableState(disabledToggle, config.setDisabled((boolean)disabled));
            return disabled;
        }))).getStyle().setText("menu.pf.disable_mod");
        ((Label)this.content.addButton((class_364)new Label(wideLeft, row += 24))).getStyle().setText("menu.pf.group.volume");
        AbstractSlider slider = ((Slider)this.content.addButton((class_364)new Slider(wideLeft, row += 24, 0.0f, 100.0f, (float)config.getGlobalVolume()))).onChange(config::setGlobalVolume).setTextFormat(this::formatVolume);
        slider.setBounds(new Bounds(row, wideLeft, 310, 20));
        slider.getStyle().setTooltip(Tooltip.of((String)"menu.pf.volume.tooltip", (int)210)).setTooltipOffset(0, 25);
        row += 10;
        this.addVolumeSlider(wideLeft, row += 24, config.clientPlayerVolume, "player");
        this.addVolumeSlider(wideRight, row, config.otherPlayerVolume, "other_players");
        this.addVolumeSlider(wideLeft, row += 24, config.hostileEntitiesVolume, "hostile_entities");
        this.addVolumeSlider(wideRight, row, config.passiveEntitiesVolume, "passive_entities");
        this.addVolumeSlider(wideLeft, row += 24, config.wetSoundsVolume, "wet");
        this.addVolumeSlider(wideRight, row, config.foliageSoundsVolume, "foliage");
        row += 10;
        slider = ((Slider)this.content.addButton((class_364)new Slider(wideLeft, row += 24, -100.0f, 100.0f, (float)config.getRunningVolumeIncrease()))).onChange(config::setRunningVolumeIncrease).setTextFormat(PFOptionsScreen.formatVolume("menu.pf.volume.running"));
        slider.setBounds(new Bounds(row, wideLeft, 310, 20));
        slider.getStyle().setTooltip(Tooltip.of((String)"menu.pf.volume.running.tooltip", (int)210)).setTooltipOffset(0, 25);
        ((Label)this.content.addButton((class_364)new Label(wideLeft, row += 25))).getStyle().setText("menu.pf.group.footsteps");
        ((AbstractSlider)this.content.addButton((class_364)new EnumSlider(left, row += 24, (Enum)config.getLocomotion()).onChange(config::setLocomotion).setTextFormat(v -> ((Locomotion)((Object)((Object)v.getValue()))).getOptionName()))).setTooltipFormat(v -> Tooltip.of((class_2561)((Locomotion)((Object)((Object)v.getValue()))).getOptionTooltip(), (int)250)).setBounds(new Bounds(row, wideLeft, 310, 20));
        ((Button)this.content.addButton((class_364)new Button(wideLeft, row += 24, 150, 20).onClick(sender -> sender.getStyle().setText("menu.pf.global." + config.cycleTargetSelector().name().toLowerCase())))).getStyle().setText("menu.pf.global." + config.getEntitySelector().name().toLowerCase());
        ((Button)this.content.addButton((class_364)new Button(wideRight, row, 150, 20).onClick(sender -> sender.getStyle().setText("menu.pf.multiplayer." + config.toggleMultiplayer())))).getStyle().setText("menu.pf.multiplayer." + config.getEnabledMP());
        ((Button)this.content.addButton((class_364)new Button(wideLeft, row += 24, 150, 20).onClick(sender -> sender.getStyle().setText("menu.pf.footwear." + (config.toggleFootwear() ? "on" : "off"))))).getStyle().setText("menu.pf.footwear." + (config.getEnabledFootwear() ? "on" : "off"));
        ((Button)this.content.addButton((class_364)new Button(wideRight, row, 150, 20).onClick(sender -> sender.getStyle().setText("menu.pf.exclusive_mode." + (config.toggleExclusiveMode() ? "on" : "off"))))).getStyle().setText("menu.pf.exclusive_mode." + (config.isExclusiveMode() ? "on" : "off"));
        ((Label)this.content.addButton((class_364)new Label(wideLeft, row += 25))).getStyle().setText("menu.pf.group.sound_packs");
        ((Button)this.content.addButton((class_364)new Button(wideLeft, row += 25, 150, 20).onClick(sender -> this.field_22787.method_1507((class_437)new class_5375(this.field_22787.method_1520(), manager -> {
            this.field_22787.field_1690.method_49598(manager);
            this.field_22787.method_1507((class_437)this);
        }, this.field_22787.method_1479(), (class_2561)class_2561.method_43471((String)"resourcePack.title")))))).getStyle().setText("options.resourcepack");
        ((Label)this.content.addButton((class_364)new Label(wideLeft, row += 25))).getStyle().setText("menu.pf.group.debugging");
        ((Button)this.content.addButton((class_364)new Button(wideLeft, row += 25, 150, 20).onClick(sender -> {
            sender.setEnabled(false);
            BlockReport.execute(PresenceFootsteps.getInstance().getEngine().getIsolator(), "report_concise", false).thenRun(() -> sender.setEnabled(true));
        }))).setEnabled(this.field_22787.field_1687 != null).getStyle().setText("menu.pf.report.concise");
        ((Button)this.content.addButton((class_364)new Button(wideRight, row, 150, 20).onClick(sender -> {
            sender.setEnabled(false);
            BlockReport.execute(PresenceFootsteps.getInstance().getEngine().getIsolator(), "report_full", true).thenRun(() -> sender.setEnabled(true));
        }))).setEnabled(this.field_22787.field_1687 != null).getStyle().setText("menu.pf.report.full");
        ((Button)this.content.addButton((class_364)new Button(wideLeft, row += 25, 150, 20).onClick(sender -> {
            sender.setEnabled(false);
            BlockReport.execute((full, writer, groups) -> ResourceUtils.forEach(Isolator.ACOUSTICS, this.field_22787.method_1478(), reader -> {
                HashMap<String, Acoustic> acoustics = new HashMap<String, Acoustic>();
                AcousticsFile file = AcousticsFile.read(reader, acoustics::put, true);
                if (file != null) {
                    try {
                        file.write(writer, acoustics);
                    }
                    catch (IOException e) {
                        PresenceFootsteps.logger.error("Error whilst exporting acoustics", (Throwable)e);
                    }
                }
            }), "acoustics", true).thenRun(() -> sender.setEnabled(true));
        }))).setEnabled(this.field_22787.field_1687 != null).getStyle().setText("menu.pf.report.acoustics");
        ((Button)this.addButton((class_364)new Button(left, this.field_22790 - 25).onClick(sender -> this.finish()))).getStyle().setText("gui.done");
        this.updateDisableState(disabledToggle, disabledToggle.getValue());
    }

    private void addVolumeSlider(int x, int y, VolumeOption option, String name) {
        AbstractSlider slider = ((Slider)this.content.addButton((class_364)new Slider(x, y, 0.0f, 100.0f, (float)option.get()))).onChange((IField.IChangeCallback)option).setTextFormat(PFOptionsScreen.formatVolume("menu.pf.volume." + name));
        slider.setBounds(new Bounds(y, x, 150, 20));
        slider.styled(s -> s.setTooltip(Tooltip.of((String)("menu.pf.volume." + name + ".tooltip"), (int)210)).setTooltipOffset(0, 25));
    }

    private void updateDisableState(Toggle disabledToggle, boolean disabled) {
        this.content.method_25396().forEach(child -> {
            if (child != disabledToggle && child instanceof Button) {
                Button button = (Button)child;
                button.setEnabled(!disabled);
            }
        });
    }

    private void redrawUpdateButton(Button button) {
        Optional<Versions> versions = PresenceFootsteps.getInstance().getUpdateChecker().getNewer();
        boolean hasUpdate = versions.isPresent();
        button.setEnabled(true);
        button.getStyle().setText(hasUpdate ? "\ud83d\ude41" : "\ud83d\ude42").setColor(hasUpdate ? 0xFF0000 : 0xFFFFFF).setTooltip(versions.map(Versions::latest).map(latest -> class_2561.method_43469((String)"pf.update.updates_available", (Object[])new Object[]{latest.version().getFriendlyString(), latest.minecraft().getFriendlyString()})).orElse(UP_TO_DATE));
    }

    private class_2561 formatVolume(AbstractSlider<Float> slider) {
        if (((Float)slider.getValue()).floatValue() <= 0.0f) {
            return VOLUME_MIN;
        }
        return class_2561.method_43469((String)"menu.pf.volume", (Object[])new Object[]{(int)Math.floor(((Float)slider.getValue()).floatValue())});
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, tickDelta);
        this.content.method_25394(context, mouseX, mouseY, tickDelta);
    }

    static Function<AbstractSlider<Float>, class_2561> formatVolume(String key) {
        return slider -> class_2561.method_43469((String)key, (Object[])new Object[]{(int)Math.floor(((Float)slider.getValue()).floatValue())});
    }
}

