/*
 * Decompiled with CFR 0.152.
 */
package elocindev.prominent_talents.util;

import com.faux.customentitydata.api.CustomDataHelper;
import elocindev.prominent_talents.registry.SoundRegistry;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.SkillsAPI;

public class TalentTree {
    public static final int MAX_LEVEL = 65;
    public static final int XP_LIMIT = 74513;
    public static final int XP_LIMIT_PRE_VI = 1235;
    public static final int XP_LIMIT_PRE_HE = 30000;
    public static final int MIGRATION_VOIDSINVASION = 30000;
    public static final float HP_GAIN_PER_LEVEL = 4.0f;
    private static final UUID HP_GAIN_UUID = UUID.fromString("2f53029f-325b-4831-b36d-c73019428dcd");
    public static int TALENT_TREE_LEVELS;
    public static int CURRENT_XP;
    public static int REQUIRED_XP;
    public static int XP_TO_NEXT;
    public static int CLIENT_PREV_LEVEL;

    public static void tick(class_3222 player) {
        class_2487 playerData;
        int lastExperience;
        class_2960 catId = new class_2960("puffish_skills:prom");
        Category category = (Category)SkillsAPI.getCategory((class_2960)catId).get();
        if (!category.getExperience().isPresent()) {
            return;
        }
        SkillsMod inst = SkillsMod.getInstance();
        int currentExperience = inst.getExperience(player, catId).orElse(0);
        if (currentExperience > 1235 && !TalentTree.hasUnlockedVoidsInvasion(player)) {
            inst.setExperience(player, catId, 1235);
            currentExperience = 1235;
        }
        if (currentExperience > 30000 && !TalentTree.hasUnlockedHasturianEra(player)) {
            inst.setExperience(player, catId, 30000);
            currentExperience = 30000;
        }
        if (currentExperience > 74513) {
            inst.setExperience(player, catId, 74513);
            currentExperience = 74513;
        }
        if (currentExperience != (lastExperience = (playerData = CustomDataHelper.getPersistentData((class_3222)player)).method_10550("prominence_lastPlayerXp"))) {
            TalentTree.updateServerPlayerLevel(player, currentExperience, lastExperience);
        }
        inst.addExperience(player, catId, 0);
    }

    public static void handleMigration(class_3222 player) {
        class_2487 playerData = CustomDataHelper.getPersistentData((class_3222)player);
        if (playerData.method_10545("playedHasturianEra")) {
            return;
        }
        class_2960 catId = new class_2960("puffish_skills:prom");
        SkillsMod inst = SkillsMod.getInstance();
        if (inst.getExperience(player, catId).orElse(0) > 30000) {
            inst.setExperience(player, catId, 30000);
        }
        inst.resetSkills(player, catId);
        playerData.method_10556("playedHasturianEra", true);
        CustomDataHelper.setPersistentData((class_3222)player, (class_2487)playerData);
    }

    public static int getServerPlayerLevel(class_3222 player) {
        class_2487 playerData = CustomDataHelper.getPersistentData((class_3222)player);
        int possibleLevel = playerData.method_10550("prominence_playerLevel");
        return possibleLevel == 0 ? 1 : possibleLevel;
    }

    @Environment(value=EnvType.CLIENT)
    public static int getClientLevel() {
        double experienceProgress = (double)CURRENT_XP / (double)REQUIRED_XP;
        int baseClientLevel = TALENT_TREE_LEVELS * 2;
        baseClientLevel = experienceProgress >= 0.5 ? (baseClientLevel += 2) : ++baseClientLevel;
        return baseClientLevel;
    }

    @Environment(value=EnvType.CLIENT)
    public static int getXpToNextLevel() {
        double experienceProgress = (double)CURRENT_XP / (double)REQUIRED_XP;
        int xpToNextLevel = experienceProgress >= 0.5 ? REQUIRED_XP - CURRENT_XP : (int)((double)REQUIRED_XP * 0.5) - CURRENT_XP;
        if (xpToNextLevel < 0) {
            xpToNextLevel = 0;
        }
        return xpToNextLevel;
    }

    public static void updateServerPlayerLevel(class_3222 player, int currentExperience, int lastExperience) {
        class_2960 catId = new class_2960("puffish_skills:prom");
        SkillsMod inst = SkillsMod.getInstance();
        class_2487 playerData = CustomDataHelper.getPersistentData((class_3222)player);
        boolean isLevelUp = false;
        int requiredXp = (Integer)inst.getRequiredExperience(player, catId, ((Integer)inst.getCurrentLevel(player, catId).get()).intValue()).get();
        double experienceProgress = (double)currentExperience / (double)requiredXp;
        int baseLevel = (Integer)inst.getCurrentLevel(player, catId).get() * 2;
        baseLevel = experienceProgress >= 0.5 ? (baseLevel += 2) : ++baseLevel;
        if (baseLevel > 65) {
            baseLevel = 65;
        }
        if (baseLevel > TalentTree.getServerPlayerLevel(player)) {
            isLevelUp = true;
        }
        playerData.method_10569("prominence_lastPlayerXp", currentExperience);
        playerData.method_10569("prominence_playerLevel", baseLevel);
        CustomDataHelper.setPersistentData((class_3222)player, (class_2487)playerData);
        if (isLevelUp && currentExperience > lastExperience && currentExperience < 74513) {
            TalentTree.triggerLevelUpServer(player, baseLevel);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void updateClientLevel() {
        int newClientLevel = TalentTree.getClientLevel();
        if (CLIENT_PREV_LEVEL == -1) {
            CLIENT_PREV_LEVEL = newClientLevel;
        } else if (newClientLevel > CLIENT_PREV_LEVEL) {
            CLIENT_PREV_LEVEL = newClientLevel;
            TalentTree.triggerLevelUpClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isTalentUnlockedOnTheCurrentClientLevelAlsoWhyIsThisMethodNameSoLongJavaMoment() {
        int currentLevel = TalentTree.getClientLevel();
        return currentLevel >= 3 && currentLevel % 2 == 1;
    }

    @Environment(value=EnvType.CLIENT)
    public static void triggerLevelUpClient() {
        class_310 mc = class_310.method_1551();
        int level = TalentTree.getClientLevel();
        if (level > 65) {
            return;
        }
        mc.field_1724.method_43496((class_2561)class_2561.method_43470((String)("Congratulations! You have reached level " + level + "!")).method_10862(class_2583.field_24360.method_10977(class_124.field_1065)));
        mc.field_1705.method_34001(5, 60, 20);
        String image = "\ue61d";
        if (TalentTree.isTalentUnlockedOnTheCurrentClientLevelAlsoWhyIsThisMethodNameSoLongJavaMoment()) {
            image = "\ue62d";
        }
        mc.field_1705.method_34004((class_2561)class_2561.method_43470((String)image));
        mc.field_1705.method_34002((class_2561)class_2561.method_43470((String)("Level " + TalentTree.getClientLevel())).method_10862(class_2583.field_24360.method_36139(16746533).method_30938(Boolean.valueOf(true))));
        mc.field_1724.method_5783(SoundRegistry.LEVEL_UP, 0.3f, 1.0f);
    }

    public static void triggerLevelUpServer(class_3222 player, int level) {
        TalentTree.applyLevelHealthBoost(player, true);
    }

    public static class_2561 getProgressBar(int size) {
        int totalBars = size;
        float progressPercentage = (float)CURRENT_XP / (float)REQUIRED_XP;
        int filledBars = (int)((float)totalBars * progressPercentage);
        class_5250 progressBarText = class_2561.method_43470((String)"");
        for (int i = 0; i < totalBars; ++i) {
            if (i < filledBars) {
                progressBarText.method_10852((class_2561)class_2561.method_43470((String)"\u23f9").method_10862(class_2583.field_24360.method_10977(class_124.field_1065)));
                continue;
            }
            progressBarText.method_10852((class_2561)class_2561.method_43470((String)"\u23f9").method_10862(class_2583.field_24360.method_10977(class_124.field_1063)));
        }
        return progressBarText;
    }

    public static void applyLevelHealthBoost(class_3222 player, boolean shouldHealMaxHealth) {
        int playerLevel = TalentTree.getServerPlayerLevel(player);
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        if (healthAttribute == null) {
            return;
        }
        int prevHpPercentage = (int)(player.method_6032() / player.method_6063() * 100.0f);
        healthAttribute.method_6200(HP_GAIN_UUID);
        healthAttribute.method_26835(new class_1322(HP_GAIN_UUID, "Player Level Health Gain", (double)(4.0f * (float)playerLevel), class_1322.class_1323.field_6328));
        if (shouldHealMaxHealth) {
            player.method_6033(999999.0f);
        } else {
            player.method_6033(player.method_6063() / 100.0f * (float)prevHpPercentage);
        }
    }

    private static boolean hasUnlockedVoidsInvasion(class_3222 player) {
        class_161 advancement = player.method_5682().method_3851().method_12896(new class_2960("prominent", "level_10"));
        class_161 advancement_alt = player.method_5682().method_3851().method_12896(new class_2960("bosses_of_mass_destruction", "adventure/night_lich_defeat"));
        if (advancement != null && advancement_alt != null) {
            class_167 progress = player.method_14236().method_12882(advancement);
            class_167 progress_alt = player.method_14236().method_12882(advancement_alt);
            if (progress.method_740() || progress_alt.method_740()) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasUnlockedHasturianEra(class_3222 player) {
        class_161 advancement = player.method_5682().method_3851().method_12896(new class_2960("prominent", "level_50"));
        class_161 advancement_alt = player.method_5682().method_3851().method_12896(new class_2960("prominent", "end_of_voids_invasion"));
        if (advancement != null && advancement_alt != null) {
            class_167 progress = player.method_14236().method_12882(advancement);
            class_167 progress_alt = player.method_14236().method_12882(advancement_alt);
            if (progress.method_740() || progress_alt.method_740()) {
                return true;
            }
        }
        return false;
    }

    public static boolean canLevelAfter10(class_3222 player) {
        return TalentTree.hasUnlockedVoidsInvasion(player);
    }

    public static boolean canLevelAfter50(class_3222 player) {
        return TalentTree.hasUnlockedHasturianEra(player);
    }

    public static void danger$resetPlayerLevel(class_3222 player) {
        class_2960 catId = new class_2960("puffish_skills:prom");
        SkillsMod inst = SkillsMod.getInstance();
        inst.resetSkills(player, catId);
        class_2487 playerData = CustomDataHelper.getPersistentData((class_3222)player);
        playerData.method_10551("prominence_lastPlayerXp");
        CustomDataHelper.setPersistentData((class_3222)player, (class_2487)playerData);
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        if (healthAttribute == null) {
            return;
        }
        healthAttribute.method_6200(HP_GAIN_UUID);
    }

    static {
        CLIENT_PREV_LEVEL = -1;
    }
}

