/*
 * Decompiled with CFR 0.152.
 */
package elocindev.protbalancer.math;

import elocindev.protbalancer.ProtBalancer;

public class FormulaParser {
    public static double evaluateFormula(final String formula) {
        try {
            return new Object(){
                int pos = -1;
                int ch;

                void nextChar() {
                    this.ch = ++this.pos < formula.length() ? (int)formula.charAt(this.pos) : -1;
                }

                boolean eat(int charToEat) {
                    while (this.ch == 32) {
                        this.nextChar();
                    }
                    if (this.ch == charToEat) {
                        this.nextChar();
                        return true;
                    }
                    return false;
                }

                double parse() {
                    this.nextChar();
                    double x = this.parseExpression();
                    if (this.pos < formula.length()) {
                        throw new RuntimeException("Unexpected: " + (char)this.ch + "in formula: " + formula);
                    }
                    return x;
                }

                double parseExpression() {
                    double x = this.parseTerm();
                    while (true) {
                        if (this.eat(43)) {
                            x += this.parseTerm();
                            continue;
                        }
                        if (!this.eat(45)) break;
                        x -= this.parseTerm();
                    }
                    return x;
                }

                double parseTerm() {
                    double x = this.parseFactor();
                    while (true) {
                        if (this.eat(42)) {
                            x *= this.parseFactor();
                            continue;
                        }
                        if (!this.eat(47)) break;
                        x /= this.parseFactor();
                    }
                    return x;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                double parseFactor() {
                    double x;
                    if (this.eat(43)) {
                        return this.parseFactor();
                    }
                    if (this.eat(45)) {
                        return -this.parseFactor();
                    }
                    int startPos = this.pos;
                    if (this.eat(40)) {
                        x = this.parseExpression();
                        this.eat(41);
                    } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                            this.nextChar();
                        }
                        x = Double.parseDouble(formula.substring(startPos, this.pos));
                    } else {
                        if (!(this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90)) {
                            if (this.ch != 95) throw new RuntimeException("Unexpected: " + (char)this.ch);
                        }
                        while (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90 || this.ch >= 48 && this.ch <= 57 || this.ch == 95) {
                            this.nextChar();
                        }
                        String func = formula.substring(startPos, this.pos);
                        if (func.equals("sqrt")) {
                            x = this.parseFactor();
                            x = Math.sqrt(x);
                        } else if (func.equals("sin")) {
                            x = this.parseFactor();
                            x = Math.sin(Math.toRadians(x));
                        } else if (func.equals("cos")) {
                            x = this.parseFactor();
                            x = Math.cos(Math.toRadians(x));
                        } else if (func.equals("tan")) {
                            x = this.parseFactor();
                            x = Math.tan(Math.toRadians(x));
                        } else if (func.equals("min")) {
                            this.eat(40);
                            x = Double.MAX_VALUE;
                            do {
                                x = Math.min(x, this.parseExpression());
                            } while (this.eat(44));
                            this.eat(41);
                        } else if (func.equals("max")) {
                            this.eat(40);
                            x = Double.MIN_VALUE;
                            do {
                                x = Math.max(x, this.parseExpression());
                            } while (this.eat(44));
                            this.eat(41);
                        } else {
                            if (!func.equals("clamp")) throw new RuntimeException("Unknown function: " + func);
                            this.eat(40);
                            double value = this.parseExpression();
                            this.eat(44);
                            double min = this.parseExpression();
                            this.eat(44);
                            double max = this.parseExpression();
                            x = Math.max(min, Math.min(value, max));
                            this.eat(41);
                        }
                    }
                    if (!this.eat(94)) return x;
                    return Math.pow(x, this.parseFactor());
                }
            }.parse();
        }
        catch (NumberFormatException e) {
            ProtBalancer.LOGGER.error("Error parsing formula: " + formula);
            return 0.0;
        }
    }
}

