/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v2;

import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.core.v1.ModLoader;
import fuzs.puzzleslib.api.init.v2.RegistryReference;
import fuzs.puzzleslib.api.init.v2.builder.ExtendedMenuSupplier;
import fuzs.puzzleslib.api.init.v2.builder.PoiTypeBuilder;
import fuzs.puzzleslib.impl.core.ModContext;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_7701;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public interface RegistryManager {
    public static RegistryManager instant(String modId) {
        return ModContext.get(modId).getRegistryManagerV2();
    }

    public class_2960 makeKey(String var1);

    public RegistryManager whenOn(ModLoader ... var1);

    default public RegistryManager whenNotOn(ModLoader ... forbiddenModLoaders) {
        Objects.checkIndex(0, forbiddenModLoaders.length);
        return this.whenOn((ModLoader[])EnumSet.complementOf(Sets.newEnumSet(Arrays.asList(forbiddenModLoaders), ModLoader.class)).toArray(ModLoader[]::new));
    }

    default public <T> RegistryReference<T> placeholder(class_5321<? extends class_2378<? super T>> registryKey, String path) {
        return RegistryReference.placeholder(registryKey, this.makeKey(path));
    }

    public <T> RegistryReference<T> register(class_5321<? extends class_2378<? super T>> var1, String var2, Supplier<T> var3);

    default public RegistryReference<class_2248> registerBlock(String path, Supplier<class_2248> entry) {
        return this.register(class_7924.field_41254, path, entry);
    }

    default public RegistryReference<class_1792> registerItem(String path, Supplier<class_1792> entry) {
        return this.register(class_7924.field_41197, path, entry);
    }

    default public RegistryReference<class_1792> registerBlockItem(RegistryReference<class_2248> blockReference) {
        return this.registerBlockItem(blockReference, new class_1792.class_1793());
    }

    default public RegistryReference<class_1792> registerBlockItem(RegistryReference<class_2248> blockReference, class_1792.class_1793 itemProperties) {
        return this.registerItem(blockReference.getResourceLocation().method_12832(), () -> new class_1747((class_2248)blockReference.get(), itemProperties));
    }

    default public RegistryReference<class_1792> registerSpawnEggItem(RegistryReference<? extends class_1299<? extends class_1308>> entityTypeReference, int backgroundColor, int highlightColor) {
        return this.registerSpawnEggItem(entityTypeReference, backgroundColor, highlightColor, new class_1792.class_1793());
    }

    public RegistryReference<class_1792> registerSpawnEggItem(RegistryReference<? extends class_1299<? extends class_1308>> var1, int var2, int var3, class_1792.class_1793 var4);

    default public RegistryReference<class_3611> registerFluid(String path, Supplier<class_3611> entry) {
        return this.register(class_7924.field_41270, path, entry);
    }

    default public RegistryReference<class_1291> registerMobEffect(String path, Supplier<class_1291> entry) {
        return this.register(class_7924.field_41208, path, entry);
    }

    default public RegistryReference<class_3414> registerSoundEvent(String path) {
        return this.register(class_7924.field_41225, path, () -> class_3414.method_47908((class_2960)this.makeKey(path)));
    }

    default public RegistryReference<class_1842> registerPotion(String path, Supplier<class_1842> entry) {
        return this.register(class_7924.field_41215, path, entry);
    }

    default public RegistryReference<class_1887> registerEnchantment(String path, Supplier<class_1887> entry) {
        return this.register(class_7924.field_41265, path, entry);
    }

    default public <T extends class_1297> RegistryReference<class_1299<T>> registerEntityType(String path, Supplier<class_1299.class_1300<T>> entry) {
        return this.register(class_7924.field_41266, path, () -> ((class_1299.class_1300)entry.get()).method_5905(path));
    }

    default public <T extends class_2586> RegistryReference<class_2591<T>> registerBlockEntityType(String path, Supplier<class_2591.class_2592<T>> entry) {
        return this.register(class_7924.field_41255, path, () -> ((class_2591.class_2592)entry.get()).method_11034(null));
    }

    default public <T extends class_1703> RegistryReference<class_3917<T>> registerMenuType(String path, Supplier<class_3917.class_3918<T>> entry) {
        return this.register(class_7924.field_41207, path, () -> new class_3917((class_3917.class_3918)entry.get(), class_7701.field_40183));
    }

    public <T extends class_1703> RegistryReference<class_3917<T>> registerExtendedMenuType(String var1, Supplier<ExtendedMenuSupplier<T>> var2);

    @Deprecated(forRemoval=true)
    public RegistryReference<class_4158> registerPoiTypeBuilder(String var1, Supplier<PoiTypeBuilder> var2);

    default public RegistryReference<class_4158> registerPoiType(String path, Supplier<Set<class_2248>> blocks) {
        return this.registerPoiType(path, () -> ((Set)blocks.get()).stream().flatMap(t -> t.method_9595().method_11662().stream()).collect(Collectors.toSet()), 0, 1);
    }

    public RegistryReference<class_4158> registerPoiType(String var1, Supplier<Set<class_2680>> var2, int var3, int var4);

    default public <T extends class_1860<?>> RegistryReference<class_3956<T>> registerRecipeType(final String path) {
        return this.register(class_7924.field_41217, path, () -> new class_3956<T>(){
            private final String id;
            {
                this.id = RegistryManager.this.makeKey(path).toString();
            }

            public String toString() {
                return this.id;
            }
        });
    }

    default public RegistryReference<class_5712> registerGameEvent(String path, int notificationRadius) {
        return this.register(class_7924.field_41273, path, () -> new class_5712(path, notificationRadius));
    }

    default public RegistryReference<class_2400> registerParticleType(String path) {
        return this.register(class_7924.field_41210, path, () -> new class_2400(false));
    }

    default public <T> class_6862<T> registerTag(class_5321<? extends class_2378<T>> registryKey, String path) {
        return class_6862.method_40092(registryKey, (class_2960)this.makeKey(path));
    }

    default public class_6862<class_2248> registerBlockTag(String path) {
        return this.registerTag(class_7924.field_41254, path);
    }

    default public class_6862<class_1792> registerItemTag(String path) {
        return this.registerTag(class_7924.field_41197, path);
    }

    default public class_6862<class_1299<?>> registerEntityTypeTag(String path) {
        return this.registerTag(class_7924.field_41266, path);
    }

    default public class_6862<class_5712> registerGameEventTag(String path) {
        return this.registerTag(class_7924.field_41273, path);
    }

    default public class_6862<class_8110> registerDamageTypeTag(String path) {
        return this.registerTag(class_7924.field_42534, path);
    }

    default public class_6862<class_1887> registerEnchantmentTag(String path) {
        return this.registerTag(class_7924.field_41265, path);
    }

    default public class_6862<class_1959> registerBiomeTag(String path) {
        return this.registerTag(class_7924.field_41236, path);
    }

    default public <T> class_5321<T> registerResourceKey(class_5321<? extends class_2378<T>> registryKey, String path) {
        return class_5321.method_29179(registryKey, (class_2960)this.makeKey(path));
    }

    default public class_5321<class_8110> registerDamageType(String path) {
        return this.registerResourceKey(class_7924.field_42534, path);
    }
}

