/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import reborncore.client.RenderUtil;
import reborncore.common.fluid.FluidSettings;
import reborncore.common.fluid.RebornFluid;
import reborncore.common.fluid.RebornFluidManager;
import reborncore.common.util.TemporaryLazy;

@Environment(value=EnvType.CLIENT)
public class RebornFluidRenderManager
implements SimpleSynchronousResourceReloadListener {
    private static final Map<class_3611, TemporaryLazy<class_1058[]>> spriteMap = new HashMap<class_3611, TemporaryLazy<class_1058[]>>();

    public static void setupClient() {
        RebornFluidRenderManager rebornFluidRenderManager = new RebornFluidRenderManager();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)rebornFluidRenderManager);
        RebornFluidManager.getFluidStream().forEach(RebornFluidRenderManager::setupFluidRenderer);
    }

    private static void setupFluidRenderer(RebornFluid fluid) {
        TemporaryLazy<class_1058[]> sprites = new TemporaryLazy<class_1058[]>(() -> {
            FluidSettings fluidSettings = fluid.getFluidSettings();
            return new class_1058[]{RenderUtil.getSprite(fluidSettings.getStillTexture()), RenderUtil.getSprite(fluidSettings.getFlowingTexture())};
        });
        spriteMap.put((class_3611)fluid, sprites);
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)fluid, (extendedBlockView, blockPos, fluidState) -> (class_1058[])sprites.get());
    }

    public class_2960 getFabricId() {
        return new class_2960("reborncore", "fluid_render_manager");
    }

    public void method_14491(class_3300 manager) {
        spriteMap.forEach((key, value) -> value.reset());
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singletonList(ResourceReloadListenerKeys.TEXTURES);
    }
}

