/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.util.Tank;

public abstract class RebornFluidRecipe
extends RebornRecipe {
    @NotNull
    private final FluidInstance fluidInstance;

    public RebornFluidRecipe(RebornRecipeType<?> type, class_2960 name, List<RebornIngredient> ingredients, List<class_1799> outputs, int power, int time, @NotNull FluidInstance fluidInstance) {
        super(type, name, ingredients, outputs, power, time);
        this.fluidInstance = fluidInstance;
    }

    public abstract Tank getTank(class_2586 var1);

    @Override
    public boolean canCraft(class_2586 be) {
        FluidInstance recipeFluid = this.fluidInstance;
        FluidInstance tankFluid = this.getTank(be).getFluidInstance();
        if (this.fluidInstance.isEmpty()) {
            return true;
        }
        if (tankFluid.isEmpty()) {
            return false;
        }
        return tankFluid.getFluid().equals(recipeFluid.getFluid()) && tankFluid.getAmount().equalOrMoreThan(recipeFluid.getAmount());
    }

    @Override
    public boolean onCraft(class_2586 be) {
        FluidInstance recipeFluid = this.fluidInstance;
        FluidInstance tankFluid = this.getTank(be).getFluidInstance();
        if (this.fluidInstance.isEmpty()) {
            return true;
        }
        if (tankFluid.isEmpty()) {
            return false;
        }
        if (tankFluid.getFluid().equals(recipeFluid.getFluid()) && tankFluid.getAmount().equalOrMoreThan(recipeFluid.getAmount())) {
            tankFluid.subtractAmount(recipeFluid.getAmount());
            return true;
        }
        return false;
    }

    @NotNull
    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }
}

