/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import reborncore.RebornCore;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeUtils;
import reborncore.common.crafting.serde.RecipeSerde;
import reborncore.common.crafting.serde.RecipeSerdeException;
import reborncore.common.util.serialization.SerializationUtil;

public record RebornRecipeType<R extends RebornRecipe>(RecipeSerde<R> recipeSerde, class_2960 name) implements class_3956<R>,
class_1865<R>
{
    public R read(class_2960 recipeId, JsonObject json) {
        class_2960 type = new class_2960(class_3518.method_15265((JsonObject)json, (String)"type"));
        if (!type.equals((Object)this.name)) {
            throw new RuntimeException("RebornRecipe type not supported!");
        }
        try {
            return this.recipeSerde.fromJson(json, this, recipeId);
        }
        catch (Throwable e) {
            throw new RecipeSerdeException(recipeId, e);
        }
    }

    public JsonObject toJson(R recipe, boolean networkSync) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.name.toString());
        try {
            this.recipeSerde.toJson(recipe, jsonObject, networkSync);
        }
        catch (Throwable e) {
            throw new RecipeSerdeException(((RebornRecipe)recipe).method_8114(), e);
        }
        return jsonObject;
    }

    public R read(class_2960 recipeId, class_2540 buffer) {
        String jsonSize = buffer.method_10800(buffer.readInt());
        return this.read(recipeId, (JsonObject)SerializationUtil.GSON_FLAT.fromJson(jsonSize, JsonObject.class));
    }

    public void write(class_2540 buffer, R recipe) {
        String output = SerializationUtil.GSON_FLAT.toJson((JsonElement)this.toJson(recipe, true));
        if (output.length() > Short.MAX_VALUE) {
            RebornCore.LOGGER.error("Recipe output string is too big. This breaks recipe books!");
            RebornCore.LOGGER.error("Recipe is:" + ((RebornRecipe)recipe).method_8114().toString());
            RebornCore.LOGGER.error("Output is:" + output);
        }
        buffer.writeInt(output.length());
        buffer.method_10814(output);
    }

    public List<R> getRecipes(class_1937 world) {
        return RecipeUtils.getRecipes(world, this);
    }
}

