/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3528;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.fluid.container.ItemFluidInfo;

public class FluidIngredient
extends RebornIngredient {
    private final class_3611 fluid;
    private final Optional<List<class_1792>> holders;
    private final Optional<Integer> count;
    private final class_3528<List<class_1799>> previewStacks;
    private final class_3528<class_1856> previewIngredient;

    public FluidIngredient(class_3611 fluid, Optional<List<class_1792>> holders, Optional<Integer> count) {
        this.fluid = fluid;
        this.holders = holders;
        this.count = count;
        this.previewStacks = new class_3528(() -> class_7923.field_41178.method_10220().filter(item -> item instanceof ItemFluidInfo).filter(item -> !holders.isPresent() || ((List)holders.get()).stream().anyMatch(i -> i == item)).map(item -> ((ItemFluidInfo)item).getFull(fluid)).peek(stack -> stack.method_7939(count.orElse(1).intValue())).collect(Collectors.toList()));
        this.previewIngredient = new class_3528(() -> class_1856.method_26964(((List)this.previewStacks.method_15332()).stream()));
    }

    public static RebornIngredient deserialize(JsonObject json) {
        class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)json, (String)"fluid"));
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(identifier);
        if (fluid == class_3612.field_15906) {
            throw new JsonParseException("Fluid could not be found: " + class_3518.method_15265((JsonObject)json, (String)"fluid"));
        }
        Optional<List<class_1792>> holders = Optional.empty();
        if (json.has("holder")) {
            if (json.get("holder").isJsonPrimitive()) {
                String ident = class_3518.method_15265((JsonObject)json, (String)"holder");
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(ident));
                if (item == class_1802.field_8162) {
                    throw new JsonParseException("could not find item:" + ident);
                }
                holders = Optional.of(Collections.singletonList(item));
            } else {
                JsonArray jsonArray = json.getAsJsonArray("holder");
                ArrayList<class_1792> itemList = new ArrayList<class_1792>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    String ident = jsonArray.get(i).getAsString();
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(ident));
                    if (item == class_1802.field_8162) {
                        throw new JsonParseException("could not find item:" + ident);
                    }
                    itemList.add(item);
                }
                holders = Optional.of(itemList);
            }
        }
        Optional<Integer> count = Optional.empty();
        if (json.has("count")) {
            count = Optional.of(json.get("count").getAsInt());
        }
        return new FluidIngredient(fluid, holders, count);
    }

    @Override
    public boolean test(class_1799 itemStack) {
        if (this.holders.isPresent() && this.holders.get().stream().noneMatch(item -> itemStack.method_7909() == item)) {
            return false;
        }
        if (this.count.isPresent() && itemStack.method_7947() < this.count.get()) {
            return false;
        }
        if (itemStack.method_7909() instanceof ItemFluidInfo) {
            return ((ItemFluidInfo)itemStack.method_7909()).getFluid(itemStack) == this.fluid;
        }
        return false;
    }

    @Override
    public class_1856 getPreview() {
        return (class_1856)this.previewIngredient.method_15332();
    }

    @Override
    public List<class_1799> getPreviewStacks() {
        return (List)this.previewStacks.method_15332();
    }

    @Override
    public JsonObject toJson(boolean networkSync) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("fluid", class_7923.field_41173.method_10221((Object)this.fluid).toString());
        if (this.holders.isPresent()) {
            List<class_1792> holderList = this.holders.get();
            if (holderList.size() == 1) {
                jsonObject.addProperty("holder", class_7923.field_41178.method_10221((Object)holderList.get(0)).toString());
            } else {
                JsonArray holderArray = new JsonArray();
                holderList.forEach(item -> holderArray.add((JsonElement)new JsonPrimitive(class_7923.field_41178.method_10221(item).toString())));
                jsonObject.add("holder", (JsonElement)holderArray);
            }
        }
        this.count.ifPresent(integer -> jsonObject.addProperty("count", (Number)integer));
        return jsonObject;
    }

    @Override
    public int getCount() {
        return this.count.orElse(1);
    }
}

