/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.serde;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RebornRecipeType;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.crafting.serde.AbstractRecipeSerde;

public abstract class RebornRecipeSerde<R extends RebornRecipe>
extends AbstractRecipeSerde<R> {
    public static final RebornRecipeSerde<RebornRecipe> BASIC = RebornRecipeSerde.create(RebornRecipe::new);

    protected abstract R fromJson(JsonObject var1, RebornRecipeType<R> var2, class_2960 var3, List<RebornIngredient> var4, List<class_1799> var5, int var6, int var7);

    @Override
    public final R fromJson(JsonObject jsonObject, RebornRecipeType<R> type, class_2960 name) {
        int power = this.getPower(jsonObject);
        int time = this.getTime(jsonObject);
        List<RebornIngredient> ingredients = this.getIngredients(jsonObject);
        List<class_1799> outputs = this.getOutputs(jsonObject);
        return this.fromJson(jsonObject, type, name, ingredients, outputs, power, time);
    }

    protected abstract void collectJsonData(R var1, JsonObject var2, boolean var3);

    @Override
    public final void toJson(R recipe, JsonObject jsonObject, boolean networkSync) {
        this.writePower(recipe, jsonObject);
        this.writeTime(recipe, jsonObject);
        this.writeIngredients(recipe, jsonObject, networkSync);
        this.writeOutputs(recipe, jsonObject);
        this.collectJsonData(recipe, jsonObject, networkSync);
    }

    public static <R extends RebornRecipe> RebornRecipeSerde<R> create(final SimpleRecipeFactory<R> factory) {
        return new RebornRecipeSerde<R>(){

            @Override
            protected R fromJson(JsonObject jsonObject, RebornRecipeType<R> type, class_2960 name, List<RebornIngredient> ingredients, List<class_1799> outputs, int power, int time) {
                return factory.create(type, name, ingredients, outputs, power, time);
            }

            @Override
            protected void collectJsonData(R recipe, JsonObject jsonObject, boolean networkSync) {
            }
        };
    }

    public static interface SimpleRecipeFactory<R extends RebornRecipe> {
        public R create(RebornRecipeType<R> var1, class_2960 var2, List<RebornIngredient> var3, List<class_1799> var4, int var5, int var6);
    }
}

