/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.fluid.container;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import reborncore.common.fluid.FluidValue;
import reborncore.common.util.NBTSerializable;

public class FluidInstance
implements NBTSerializable {
    public static final String FLUID_KEY = "Fluid";
    public static final String AMOUNT_KEY = "Amount";
    public static final String TAG_KEY = "Tag";
    public static final FluidInstance EMPTY = new FluidInstance(class_3612.field_15906, FluidValue.EMPTY);
    protected class_3611 fluid;
    protected FluidValue amount;
    protected class_2487 tag;

    public FluidInstance(class_3611 fluid, FluidValue amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public FluidInstance(class_3611 fluid) {
        this(fluid, FluidValue.EMPTY);
    }

    public FluidInstance() {
        this(class_3612.field_15906);
    }

    public FluidInstance(class_2487 tag) {
        this();
        this.read(tag);
    }

    public class_3611 getFluid() {
        return this.fluid;
    }

    public FluidValue getAmount() {
        return this.amount;
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public FluidInstance setFluid(class_3611 fluid) {
        this.fluid = fluid;
        return this;
    }

    public FluidInstance setAmount(FluidValue value) {
        this.amount = value;
        return this;
    }

    public FluidInstance subtractAmount(FluidValue amount) {
        this.amount = this.amount.subtract(amount);
        return this;
    }

    public FluidInstance addAmount(FluidValue amount) {
        this.amount = this.amount.add(amount);
        return this;
    }

    public void setTag(class_2487 tag) {
        this.tag = tag;
    }

    public boolean isEmpty() {
        return this.isEmptyFluid() || this.getAmount().isEmpty();
    }

    public boolean isEmptyFluid() {
        return this.getFluid() == class_3612.field_15906;
    }

    public FluidInstance copy() {
        return new FluidInstance().setFluid(this.fluid).setAmount(this.amount);
    }

    @Override
    public class_2487 write() {
        class_2487 tag = new class_2487();
        tag.method_10582(FLUID_KEY, class_7923.field_41173.method_10221((Object)this.fluid).toString());
        tag.method_10544(AMOUNT_KEY, this.amount.getRawValue());
        if (this.tag != null && !this.tag.method_33133()) {
            tag.method_10566(TAG_KEY, (class_2520)this.tag);
        }
        return tag;
    }

    @Override
    public void read(class_2487 tag) {
        this.fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(tag.method_10558(FLUID_KEY)));
        this.amount = FluidValue.fromRaw(tag.method_10537(AMOUNT_KEY));
        if (tag.method_10545(TAG_KEY)) {
            this.tag = tag.method_10562(TAG_KEY);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof FluidInstance && this.fluid == ((FluidInstance)obj).getFluid() && this.amount.equals(((FluidInstance)obj).getAmount());
    }

    public boolean isFluidEqual(FluidInstance instance) {
        return this.isEmpty() && instance.isEmpty() || this.fluid.equals(instance.getFluid());
    }

    public FluidVariant getVariant() {
        if (this.isEmpty()) {
            return FluidVariant.blank();
        }
        return FluidVariant.of((class_3611)this.fluid, (class_2487)this.tag);
    }
}

