/*
 * Decompiled with CFR 0.152.
 */
package elocindev.resistance_balancer.mixin;

import elocindev.resistance_balancer.config.ResistanceBalancerConfig;
import elocindev.resistance_balancer.math.FormulaParser;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Inject(method={"modifyAppliedDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/effect/StatusEffectInstance;getAmplifier()I", ordinal=0)}, cancellable=true)
    private void injectResistanceCalculation(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        class_1309 entity = (class_1309)this;
        if (entity.method_6059(class_1294.field_5907) && !source.method_48789(class_8103.field_42244)) {
            float reducedAmount;
            int resistanceLevel = entity.method_6112(class_1294.field_5907).method_5578() + 1;
            if (ResistanceBalancerConfig.INSTANCE.enable_custom_formula) {
                String formula = ResistanceBalancerConfig.INSTANCE.custom_formula;
                String parsedFormula = formula.replace("RESISTANCE", String.valueOf(resistanceLevel));
                float reductionFactor = (float)FormulaParser.evaluateFormula(parsedFormula);
                reducedAmount = amount * (1.0f - reductionFactor);
            } else {
                float fallbackReduction = (float)resistanceLevel * ResistanceBalancerConfig.INSTANCE.percentile_reduction_fallback;
                reducedAmount = amount * (1.0f - fallbackReduction);
            }
            float resistedDamage = amount - reducedAmount;
            if (resistedDamage > 0.0f && resistedDamage < Float.MAX_VALUE) {
                if (entity instanceof class_3222) {
                    ((class_3222)entity).method_7339(class_3468.field_15425, Math.round(resistedDamage * 10.0f));
                } else if (source.method_5529() instanceof class_3222) {
                    ((class_3222)source.method_5529()).method_7339(class_3468.field_15397, Math.round(resistedDamage * 10.0f));
                }
            }
            cir.setReturnValue((Object)Float.valueOf(Math.max(reducedAmount, 0.0f)));
        }
    }
}

