/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.sortilege.crafting.brewing;

import java.util.ArrayList;
import java.util.List;
import net.lyof.sortilege.config.ConfigEntries;
import net.lyof.sortilege.crafting.brewing.IBetterBrewingRecipe;
import net.lyof.sortilege.crafting.brewing.custom.AntidoteBrewingRecipe;
import net.lyof.sortilege.crafting.brewing.custom.PotionBrewingRecipe;
import net.minecraft.class_1799;

public class BetterBrewingRegistry {
    private static List<IBetterBrewingRecipe> RECIPES = new ArrayList<IBetterBrewingRecipe>();

    public static void register() {
        if (ConfigEntries.antidoteEnabled) {
            BetterBrewingRegistry.register(new AntidoteBrewingRecipe());
            BetterBrewingRegistry.register(new PotionBrewingRecipe());
        }
    }

    public static List<IBetterBrewingRecipe> getAll() {
        return RECIPES;
    }

    public static void clear() {
        RECIPES.clear();
    }

    public static void register(IBetterBrewingRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static boolean isRecipe(class_1799 input, class_1799 ingredient) {
        return BetterBrewingRegistry.findRecipe(input, ingredient) != null;
    }

    public static IBetterBrewingRecipe findRecipe(class_1799 input, class_1799 ingredient) {
        for (IBetterBrewingRecipe recipe : BetterBrewingRegistry.getAll()) {
            if (!recipe.isIngredient(ingredient) || !recipe.isInput(input)) continue;
            return recipe;
        }
        return null;
    }
}

