/*
 * Decompiled with CFR 0.152.
 */
package dev.booky.stackdeobf;

import dev.booky.stackdeobf.config.StackDeobfConfig;
import dev.booky.stackdeobf.mappings.CachedMappings;
import dev.booky.stackdeobf.mappings.providers.AbstractMappingProvider;
import dev.booky.stackdeobf.util.RemappingRewritePolicy;
import dev.booky.stackdeobf.util.VersionData;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StackDeobfMod
implements ModInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"StackDeobfuscator");
    private static final VersionData VERSION_DATA = VersionData.fromClasspath();
    private static CachedMappings mappings;

    public static Throwable remap(Throwable throwable) {
        if (mappings != null) {
            return mappings.remapThrowable(throwable);
        }
        return throwable;
    }

    public static void remap(StackTraceElement[] elements) {
        if (mappings != null) {
            mappings.remapStackTrace(elements);
        }
    }

    public static VersionData getVersionData() {
        return VERSION_DATA;
    }

    public void onInitialize() {
        StackDeobfConfig config = this.loadConfig();
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Path cacheDir = gameDir.resolve("stackdeobf_mappings");
        CachedMappings.create((Path)cacheDir, (AbstractMappingProvider)config.getMappingProvider()).thenAccept(mappings -> {
            StackDeobfMod.mappings = mappings;
            if (config.hasLogInjectEnabled()) {
                LOGGER.info("Injecting into root logger...");
                RemappingRewritePolicy policy = new RemappingRewritePolicy(mappings, config.shouldRewriteEveryLogMessage());
                policy.inject((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger());
            }
        });
    }

    private StackDeobfConfig loadConfig() {
        try {
            Path configPath = FabricLoader.getInstance().getConfigDir().resolve("stackdeobf.json");
            return StackDeobfConfig.load(VERSION_DATA, configPath);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Exception occurred while loading stack deobfuscator configuration", throwable);
        }
    }
}

