/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.storage.energy.lesu;

import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.powerSystem.RcEnergyTier;
import reborncore.common.screen.BuiltScreenHandler;
import reborncore.common.screen.BuiltScreenHandlerProvider;
import reborncore.common.screen.builder.ScreenHandlerBuilder;
import techreborn.blockentity.storage.energy.EnergyStorageBlockEntity;
import techreborn.blockentity.storage.energy.lesu.LSUStorageBlockEntity;
import techreborn.blockentity.storage.energy.lesu.LesuNetwork;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRBlockEntities;
import techreborn.init.TRContent;

public class LapotronicSUBlockEntity
extends EnergyStorageBlockEntity
implements BuiltScreenHandlerProvider {
    private int connectedBlocks = 0;
    private final ArrayList<LesuNetwork> countedNetworks = new ArrayList();

    public LapotronicSUBlockEntity(class_2338 pos, class_2680 state) {
        super(TRBlockEntities.LAPOTRONIC_SU, pos, state, "LESU", 2, TRContent.Machine.LAPOTRONIC_SU.block, RcEnergyTier.LOW, TechRebornConfig.lesuStoragePerBlock);
        this.checkOverfill = false;
        this.maxOutput = TechRebornConfig.lesuBaseOutput;
    }

    private void setMaxStorage() {
        this.maxStorage = (this.connectedBlocks + 1) * TechRebornConfig.lesuStoragePerBlock;
        if (this.maxStorage < 0 || this.maxStorage > Integer.MAX_VALUE) {
            this.maxStorage = Integer.MAX_VALUE;
        }
    }

    private void setIORate() {
        this.maxOutput = TechRebornConfig.lesuBaseOutput + this.connectedBlocks * TechRebornConfig.lesuExtraIOPerBlock;
        if (this.connectedBlocks < 32) {
            return;
        }
        this.maxInput = this.connectedBlocks < 128 ? RcEnergyTier.MEDIUM.getMaxInput() : RcEnergyTier.HIGH.getMaxInput();
    }

    private void checkNetwork() {
        this.countedNetworks.clear();
        this.connectedBlocks = 0;
        for (class_2350 dir : class_2350.values()) {
            LesuNetwork network;
            class_2586 adjacent = this.field_11863.method_8321(this.field_11867.method_10093(dir));
            if (!(adjacent instanceof LSUStorageBlockEntity) || (network = ((LSUStorageBlockEntity)adjacent).network) == null || this.countedNetworks.contains(network) || network.master != null && network.master != this) continue;
            this.connectedBlocks += network.storages.size();
            this.countedNetworks.add(network);
            network.master = this;
            break;
        }
    }

    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, MachineBaseBlockEntity blockEntity) {
        super.tick(world, pos, state, blockEntity);
        if (world == null || world.field_9236) {
            return;
        }
        if (world.method_8510() % 20L == 0L) {
            this.checkNetwork();
        }
        this.setMaxStorage();
        this.setIORate();
        if (this.getEnergy() > this.getMaxStoredPower()) {
            this.setEnergy(this.getMaxStoredPower());
        }
    }

    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return new ScreenHandlerBuilder("lesu").player(player.method_31548()).inventory().hotbar().armor().complete(8, 18).addArmor().addInventory().blockEntity((class_2586)this).energySlot(0, 62, 45).energySlot(1, 98, 45).syncEnergyValue().sync(this::getConnectedBlocksNum, this::setConnectedBlocksNum).addInventory().create((MachineBaseBlockEntity)this, syncID);
    }

    public int getConnectedBlocksNum() {
        return this.connectedBlocks;
    }

    public void setConnectedBlocksNum(int value) {
        this.connectedBlocks = value;
        if (this.field_11863.field_9236) {
            this.setMaxStorage();
            this.setIORate();
        }
    }
}

