/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blocks;

import com.finallion.graveyard.blockentities.GravestoneBlockEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2508;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2693;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_5712;
import net.minecraft.class_5953;
import net.minecraft.class_8232;
import net.minecraft.class_8233;
import net.minecraft.class_8234;
import net.minecraft.class_8242;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class GravestoneBlock
extends class_2508
implements class_2343 {
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 FLOOR = class_2741.field_16562;
    private static final class_265 SHAPE_FACING_EW = class_2248.method_9541((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final class_265 SHAPE_FACING_NS = class_2248.method_9541((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private final class_2960 texture;

    public GravestoneBlock(class_2960 texture) {
        super((class_4970.class_2251)FabricBlockSettings.create().noCollision().nonOpaque().sounds(class_2498.field_29034).strength(1.5f), class_4719.field_21676);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)FLOOR, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)field_11491, (Comparable)Boolean.valueOf(false)));
        this.texture = texture;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, FLOOR, field_11491, ROTATION});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (class_2350.field_11043 == state.method_11654((class_2769)FACING) || class_2350.field_11035 == state.method_11654((class_2769)FACING)) {
            return SHAPE_FACING_NS;
        }
        return SHAPE_FACING_EW;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GravestoneBlockEntity(pos, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        class_1792 item2 = itemStack.method_7909();
        class_8234 signChangingItem = item2 instanceof class_8234 ? (class_8234)item2 : null;
        class_8234 signChangingItem2 = signChangingItem;
        boolean bl = signChangingItem2 != null && player.method_7294();
        class_2586 var12 = world.method_8321(pos);
        if (!(var12 instanceof GravestoneBlockEntity)) return class_1269.field_5811;
        GravestoneBlockEntity signBlockEntity = (GravestoneBlockEntity)var12;
        if (world.field_9236) return !bl && !signBlockEntity.isWaxed() ? class_1269.field_21466 : class_1269.field_5812;
        class_8242 signText = signBlockEntity.getText();
        boolean bl3 = signBlockEntity.runCommandClickEvent(player, world, pos);
        if (signBlockEntity.isWaxed()) {
            world.method_45447(null, signBlockEntity.method_11016(), class_3417.field_43167, class_3419.field_15245);
            return class_1269.field_5811;
        }
        if (bl && !this.isOtherPlayerEditing(player, signBlockEntity) && signChangingItem2.method_49801(signText, player)) {
            boolean useOnSign = false;
            if (signChangingItem2 instanceof class_1769) {
                class_1769 dyeItem = (class_1769)signChangingItem2;
                useOnSign = this.useDyeOnSign(world, signBlockEntity, dyeItem.method_7802());
            } else if (signChangingItem2 instanceof class_8233) {
                useOnSign = this.useInkOnSign(world, signBlockEntity);
            } else if (signChangingItem2 instanceof class_5953) {
                useOnSign = this.useWaxOnSign(world, signBlockEntity);
            } else if (signChangingItem2 instanceof class_8232) {
                useOnSign = this.useGlowInkOnSign(world, signBlockEntity);
            }
            if (!useOnSign) return class_1269.field_5811;
            if (!player.method_7337()) {
                itemStack.method_7934(1);
            }
            world.method_43276(class_5712.field_28733, signBlockEntity.method_11016(), class_5712.class_7397.method_43286((class_1297)player, (class_2680)signBlockEntity.method_11010()));
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            return class_1269.field_5812;
        }
        if (bl3) {
            return class_1269.field_5812;
        }
        if (this.isOtherPlayerEditing(player, signBlockEntity) || !player.method_7294() || !this.isTextLiteralOrEmpty(player, signBlockEntity)) return class_1269.field_5811;
        this.openEditScreen(player, signBlockEntity, world, pos, state);
        return class_1269.field_5812;
    }

    public boolean useDyeOnSign(class_1937 world, GravestoneBlockEntity signBlockEntity, class_1767 color) {
        if (signBlockEntity.changeText(text -> text.method_49862(color))) {
            world.method_8396(null, signBlockEntity.method_11016(), class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean useInkOnSign(class_1937 world, GravestoneBlockEntity signBlockEntity) {
        if (signBlockEntity.changeText(text -> text.method_49867(false))) {
            world.method_8396(null, signBlockEntity.method_11016(), class_3417.field_28397, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean useGlowInkOnSign(class_1937 world, GravestoneBlockEntity signBlockEntity) {
        if (signBlockEntity.changeText(text -> text.method_49867(true))) {
            world.method_8396(null, signBlockEntity.method_11016(), class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean useWaxOnSign(class_1937 world, GravestoneBlockEntity signBlockEntity) {
        if (signBlockEntity.setWaxed(true)) {
            world.method_8444(null, 3003, signBlockEntity.method_11016(), 0);
            return true;
        }
        return false;
    }

    private boolean isTextLiteralOrEmpty(class_1657 player, GravestoneBlockEntity blockEntity) {
        class_8242 signText = blockEntity.getText();
        return Arrays.stream(signText.method_49877(player.method_33793())).allMatch(message -> message.equals(class_5244.field_39003) || message.method_10851() instanceof class_2585);
    }

    public void openEditScreen(class_1657 player, GravestoneBlockEntity blockEntity, class_1937 world, class_2338 pos, class_2680 state) {
        blockEntity.setEditor(player.method_5667());
        this.openScreen(world, pos, player);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            this.openScreen(world, pos, player);
        }
    }

    private void openScreen(class_1937 world, class_2338 pos, class_1657 placer) {
        GravestoneBlockEntity sign = (GravestoneBlockEntity)world.method_8321(pos);
        if (!world.field_9236) {
            sign.setEditor(placer.method_5667());
            ((class_3222)placer).field_13987.method_14364((class_2596)new class_2693(pos, true));
        }
    }

    private boolean isOtherPlayerEditing(class_1657 player, GravestoneBlockEntity blockEntity) {
        UUID uUID = blockEntity.getEditor();
        return uUID != null && !uUID.equals(player.method_5667());
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        class_2350 direction = ctx.method_8042();
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction.method_10153())).method_11657((class_2769)field_11491, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        return Collections.singletonList(new class_1799((class_1935)this));
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_51367();
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (class_2350.field_11043 == state.method_11654((class_2769)FACING) || class_2350.field_11035 == state.method_11654((class_2769)FACING)) {
            return SHAPE_FACING_NS;
        }
        return SHAPE_FACING_EW;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }
}

