/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.client;

import com.finallion.graveyard.blockentities.renders.BrazierBlockEntityRenderer;
import com.finallion.graveyard.blockentities.renders.GravestoneBlockEntityRenderer;
import com.finallion.graveyard.blockentities.renders.OssuaryBlockEntityRenderer;
import com.finallion.graveyard.blockentities.renders.SarcophagusBlockEntityRenderer;
import com.finallion.graveyard.client.gui.OssuaryScreen;
import com.finallion.graveyard.entities.models.CorruptedIllagerModel;
import com.finallion.graveyard.entities.renders.AcolyteRender;
import com.finallion.graveyard.entities.renders.CorruptedPillagerRenderer;
import com.finallion.graveyard.entities.renders.CorruptedVindicatorRenderer;
import com.finallion.graveyard.entities.renders.FallingCorpseRenderer;
import com.finallion.graveyard.entities.renders.GhoulRenderer;
import com.finallion.graveyard.entities.renders.GhoulingRenderer;
import com.finallion.graveyard.entities.renders.LichRenderer;
import com.finallion.graveyard.entities.renders.NamelessHangedRenderer;
import com.finallion.graveyard.entities.renders.NightmareRenderer;
import com.finallion.graveyard.entities.renders.ReaperRenderer;
import com.finallion.graveyard.entities.renders.RevenantRenderer;
import com.finallion.graveyard.entities.renders.SkeletonCreeperRender;
import com.finallion.graveyard.entities.renders.SkullEntityRenderer;
import com.finallion.graveyard.entities.renders.WraithRenderer;
import com.finallion.graveyard.init.TGBlocks;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGItems;
import com.finallion.graveyard.init.TGParticles;
import com.finallion.graveyard.init.TGScreens;
import com.finallion.graveyard.item.VialOfBlood;
import com.finallion.graveyard.network.GraveyardEntitySpawnPacket;
import com.finallion.graveyard.particles.GraveyardFogParticle;
import com.finallion.graveyard.particles.GraveyardHandParticle;
import com.finallion.graveyard.particles.GraveyardLineFogParticle;
import com.finallion.graveyard.particles.GraveyardSoulParticle;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1933;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_5601;
import net.minecraft.class_638;
import net.minecraft.class_7452;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TheGraveyardClient
implements ClientModInitializer {
    private static final class_1921 CUTOUT_MIPPED = class_1921.method_23579();
    public static final class_5601 CORRUPTED_ILLAGER_MODEL_LAYER = new class_5601(new class_2960("graveyard", "corrupted_illager"), "main");

    public void onInitializeClient() {
        ParticleFactoryRegistry.getInstance().register((class_2396)TGParticles.GRAVEYARD_FOG_PARTICLE, GraveyardFogParticle.FogFactory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)TGParticles.GRAVEYARD_SOUL_PARTICLE, GraveyardSoulParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)TGParticles.GRAVEYARD_HAND_PARTICLE, GraveyardHandParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)TGParticles.GRAVEYARD_LEFT_HAND_PARTICLE, GraveyardHandParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)TGParticles.GRAVEYARD_SOUL_BEAM_PARTICLE, class_7452.class_7453::new);
        ParticleFactoryRegistry.getInstance().register((class_2396)TGParticles.GRAVEYARD_LINE_FOG_PARTICLE, GraveyardLineFogParticle.Factory::new);
        class_3929.method_17542(TGScreens.OSSUARY_SCREEN_HANDLER, OssuaryScreen::new);
        BlockRenderLayerMap.INSTANCE.putBlocks(CUTOUT_MIPPED, new class_2248[]{TGBlocks.SKULL_WITH_RIB_CAGE, TGBlocks.WITHER_SKULL_WITH_RIB_CAGE, TGBlocks.LEANING_SKELETON, TGBlocks.LEANING_WITHER_SKELETON, TGBlocks.LYING_SKELETON, TGBlocks.LYING_WITHER_SKELETON, TGBlocks.BONE_REMAINS, TGBlocks.SKULL_ON_PIKE, TGBlocks.LATERALLY_LYING_SKELETON, TGBlocks.TORSO_PILE, TGBlocks.WITHER_BONE_REMAINS, TGBlocks.WITHER_SKULL_ON_PIKE, TGBlocks.LATERALLY_LYING_WITHER_SKELETON, TGBlocks.HANGED_SKELETON, TGBlocks.HANGED_WITHER_SKELETON, TGBlocks.WITHER_TORSO_PILE, TGBlocks.DARK_IRON_BARS, TGBlocks.TG_GRASS_BLOCK, TGBlocks.SOUL_FIRE_BRAZIER, TGBlocks.FIRE_BRAZIER, TGBlocks.CANDLE_HOLDER, TGBlocks.DARK_IRON_DOOR, TGBlocks.DARK_IRON_TRAPDOOR, TGBlocks.OSSUARY});
        BlockEntityRendererRegistry.register(TGBlocks.GRAVESTONE_BLOCK_ENTITY, GravestoneBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register(TGBlocks.SARCOPHAGUS_BLOCK_ENTITY, SarcophagusBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register(TGBlocks.BRAZIER_BLOCK_ENTITY, rendererDispatcherIn -> new BrazierBlockEntityRenderer());
        BlockEntityRendererRegistry.register(TGBlocks.OSSUARY_BLOCK_ENTITY, rendererDispatcherIn -> new OssuaryBlockEntityRenderer());
        ColorProviderRegistry.BLOCK.register((Object)new class_322(){

            public int getColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
                return world != null && pos != null ? class_1163.method_4962((class_1920)world, (class_2338)pos) : class_1933.method_8377((double)0.5, (double)1.0);
            }
        }, (Object[])new class_2248[]{TGBlocks.TG_GRASS_BLOCK});
        ColorProviderRegistry.ITEM.register((Object)new class_326(){

            public int getColor(class_1799 stack, int tintIndex) {
                return class_1933.method_8377((double)0.5, (double)1.0);
            }
        }, (Object[])new class_1935[]{TGBlocks.TG_GRASS_BLOCK});
        EntityRendererRegistry.register(TGEntities.SKELETON_CREEPER, SkeletonCreeperRender::new);
        EntityRendererRegistry.register(TGEntities.ACOLYTE, AcolyteRender::new);
        EntityRendererRegistry.register(TGEntities.GHOUL, GhoulRenderer::new);
        EntityRendererRegistry.register(TGEntities.REAPER, ReaperRenderer::new);
        EntityRendererRegistry.register(TGEntities.REVENANT, RevenantRenderer::new);
        EntityRendererRegistry.register(TGEntities.NIGHTMARE, NightmareRenderer::new);
        EntityRendererRegistry.register(TGEntities.CORRUPTED_PILLAGER, CorruptedPillagerRenderer::new);
        EntityRendererRegistry.register(TGEntities.CORRUPTED_VINDICATOR, CorruptedVindicatorRenderer::new);
        EntityRendererRegistry.register(TGEntities.WRAITH, WraithRenderer::new);
        EntityRendererRegistry.register(TGEntities.LICH, LichRenderer::new);
        EntityRendererRegistry.register(TGEntities.FALLING_CORPSE, FallingCorpseRenderer::new);
        EntityRendererRegistry.register(TGEntities.SKULL, SkullEntityRenderer::new);
        EntityRendererRegistry.register(TGEntities.GHOULING, GhoulingRenderer::new);
        EntityRendererRegistry.register(TGEntities.NAMELESS_HANGED, NamelessHangedRenderer::new);
        EntityModelLayerRegistry.registerModelLayer((class_5601)CORRUPTED_ILLAGER_MODEL_LAYER, CorruptedIllagerModel::getTexturedModelData);
        class_5272.method_27879((class_1792)TGItems.VIAL_OF_BLOOD, (class_2960)new class_2960("charged"), (stack, world, entity, seed) -> {
            if (entity != null && stack.method_31574(TGItems.VIAL_OF_BLOOD)) {
                return VialOfBlood.getBlood(stack);
            }
            return 0.0f;
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GraveyardEntitySpawnPacket.ID, (client, handler, buf, responseSender) -> EntityPacketOnClient.onPacket(client, buf));
    }

    public class EntityPacketOnClient {
        @Environment(value=EnvType.CLIENT)
        public static void onPacket(class_310 context, class_2540 byteBuf) {
            class_1299 type = (class_1299)class_7923.field_41177.method_10200(byteBuf.method_10816());
            UUID entityUUID = byteBuf.method_10790();
            int entityID = byteBuf.method_10816();
            double x = byteBuf.readDouble();
            double y = byteBuf.readDouble();
            double z = byteBuf.readDouble();
            float pitch = (float)(byteBuf.readByte() * 360) / 256.0f;
            float yaw = (float)(byteBuf.readByte() * 360) / 256.0f;
            context.execute(() -> {
                class_638 world = class_310.method_1551().field_1687;
                class_1297 entity = type.method_5883((class_1937)world);
                if (entity != null) {
                    entity.method_30634(x, y, z);
                    entity.method_43391(x, y, z);
                    entity.method_36457(pitch);
                    entity.method_36456(yaw);
                    entity.method_5838(entityID);
                    entity.method_5826(entityUUID);
                    world.method_2942(entityID, entity);
                }
            });
        }
    }
}

