/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.TheGraveyard;
import com.finallion.graveyard.blocks.AltarBlock;
import com.finallion.graveyard.entities.FallingCorpse;
import com.finallion.graveyard.entities.GhoulEntity;
import com.finallion.graveyard.entities.HostileGraveyardEntity;
import com.finallion.graveyard.entities.RevenantEntity;
import com.finallion.graveyard.entities.ai.goals.LichMeleeGoal;
import com.finallion.graveyard.entities.projectiles.SkullEntity;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGParticles;
import com.finallion.graveyard.init.TGSounds;
import com.finallion.graveyard.sounds.BossMusicPlayer;
import com.finallion.graveyard.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1669;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LichEntity
extends class_1588
implements GeoEntity {
    private final class_3213 bossBar;
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final class_4051 HEAD_TARGET_PREDICATE;
    private static final Predicate<class_1309> CAN_ATTACK_PREDICATE;
    private static final UUID ATTACKING_SPEED_BOOST_ID;
    private static final UUID ATTACKING_DMG_BOOST_ID;
    private static final UUID CRAWL_SPEED_BOOST_ID;
    private static final class_1322 ATTACKING_SPEED_BOOST;
    private static final class_1322 CRAWL_SPEED_BOOST;
    private static final class_1322 DMG_BOOST;
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    private final RawAnimation CORPSE_SPELL_ANIMATION = RawAnimation.begin().then("corpse_spell", Animation.LoopType.LOOP);
    private final RawAnimation START_PHASE_2_ANIMATION = RawAnimation.begin().then("phase_two", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation PHASE_2_IDLE_ANIMATION = RawAnimation.begin().then("phase_two_idle", Animation.LoopType.LOOP);
    private final RawAnimation PHASE_2_ATTACK_ANIMATION = RawAnimation.begin().then("phase_two_attack", Animation.LoopType.LOOP);
    private final RawAnimation START_PHASE_3_ANIMATION = RawAnimation.begin().then("phase_three", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation PHASE_3_ATTACK_ANIMATION = RawAnimation.begin().then("crawl", Animation.LoopType.LOOP);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation SHOOT_SKULL_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    private final RawAnimation SUMMON_ANIMATION = RawAnimation.begin().then("summon", Animation.LoopType.LOOP);
    private final RawAnimation CONJURE_FANG_ANIMATION = RawAnimation.begin().then("corpse_spell", Animation.LoopType.LOOP);
    private final RawAnimation STUNNED_ANIMATION = RawAnimation.begin().then("stunned", Animation.LoopType.LOOP);
    private final RawAnimation CRAWL_IDLE_ANIMATION = RawAnimation.begin().then("crawl_idle", Animation.LoopType.LOOP);
    protected static final int ANIMATION_SPAWN = 0;
    protected static final int ANIMATION_IDLE = 1;
    protected static final int ANIMATION_MELEE = 2;
    protected static final int ANIMATION_CORPSE_SPELL = 3;
    protected static final int ANIMATION_START_PHASE_2 = 4;
    protected static final int ANIMATION_PHASE_2_IDLE = 5;
    protected static final int ANIMATION_PHASE_2_ATTACK = 6;
    protected static final int ANIMATION_SHOOT_SKULL = 7;
    protected static final int ANIMATION_START_PHASE_3 = 8;
    protected static final int ANIMATION_PHASE_3_ATTACK = 9;
    protected static final int ANIMATION_STOP = 10;
    protected static final int ANIMATION_SUMMON = 11;
    protected static final int ANIMATION_CONJURE_FANG = 12;
    protected static final int ANIMATION_STUNNED = 13;
    protected static final int ANIMATION_CRAWL_IDLE = 14;
    private static final class_2940<Integer> INVUL_TIMER;
    private static final class_2940<Integer> PHASE_INVUL_TIMER;
    private static final class_2940<Integer> ATTACK_ANIM_TIMER;
    private static final class_2940<Integer> FIGHT_DURATION_TIMER;
    private static final class_2940<Integer> PHASE_TWO_START_ANIM_TIMER;
    private static final class_2940<Integer> PHASE_THREE_START_ANIM_TIMER;
    private static final class_2940<Integer> PHASE;
    private static final class_2940<Integer> ANIMATION;
    private static final class_2940<Integer> HUNT_TIMER;
    private static final class_2940<Boolean> CAN_HUNT_START;
    private static final class_2940<Boolean> CAN_MOVE;
    private static final class_2940<Integer> MUSIC_DELAY;
    private static final class_2940<Integer> CONJURE_FANG_TIMER;
    private static final class_2940<Integer> HEAL_DURATION_TIMER;
    private static final class_2940<Integer> CORPSE_SPELL_DURATION_TIMER;
    private static final class_2940<Integer> LEVITATION_DURATION_TIMER;
    private static final byte MUSIC_PLAY_ID = 67;
    private static final byte MUSIC_STOP_ID = 68;
    private static final int SPAWN_INVUL_TIMER = 490;
    private static final int DEFAULT_INVUL_TIMER = 200;
    private final float HEALTH_PHASE_01;
    private final float HEALTH_PHASE_02;
    public final int ATTACK_ANIMATION_DURATION = 40;
    private final int START_PHASE_TWO_ANIMATION_DURATION = 121;
    private final int START_PHASE_THREE_ANIMATION_DURATION = 220;
    private final int START_PHASE_TWO_PARTICLES = 80;
    private final int CORPSE_SPELL_DURATION;
    private final int HUNT_COOLDOWN = 600;
    private final int HUNT_DURATION;
    private final int HEALING_DURATION;
    private final int LEVITATION_DURATION;
    protected static final class_4048 CRAWL_DIMENSIONS;
    private int huntCooldownTicker;
    private class_2338 homePos;
    private class_2350 spawnDirection;
    private int phaseThreeAttackSoundAge;
    private int idleSoundAge;

    public LichEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.HEALTH_PHASE_01 = TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").healthInCastingPhase;
        this.HEALTH_PHASE_02 = TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").healthInHuntingPhase;
        this.ATTACK_ANIMATION_DURATION = 40;
        this.START_PHASE_TWO_ANIMATION_DURATION = 121;
        this.START_PHASE_THREE_ANIMATION_DURATION = 220;
        this.START_PHASE_TWO_PARTICLES = 80;
        this.CORPSE_SPELL_DURATION = TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").durationFallingCorpseSpell;
        this.HUNT_COOLDOWN = 600;
        this.HUNT_DURATION = TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").durationHuntingPhase;
        this.HEALING_DURATION = TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").durationHealingSpell;
        this.LEVITATION_DURATION = TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").durationLevitationSpell;
        this.huntCooldownTicker = 100;
        this.phaseThreeAttackSoundAge = 120;
        this.idleSoundAge = 0;
        this.bossBar = (class_3213)new class_3213(this.method_5476(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795).method_5406(true).method_5411(true);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            if (this.getAnimationState() == 0 && this.getInvulnerableTimer() >= 0) {
                event.getController().setAnimation(this.SPAWN_ANIMATION);
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        })});
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, event -> {
            if (this.getAnimationState() == 10) {
                return PlayState.STOP;
            }
            if (this.getAnimationState() == 2 && this.getAttackAnimTimer() == 39 && this.method_6510() && !this.method_29504() && !((double)this.method_6032() < 0.01) && this.canMeeleAttack() && this.getAnimationState() != 0) {
                this.setAttackAnimTimer(38);
                event.getController().setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 3 && this.getPhase() == 1) {
                event.getController().setAnimation(this.CORPSE_SPELL_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 7 && this.getPhase() == 1) {
                event.getController().setAnimation(this.SHOOT_SKULL_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 11 && this.getPhase() == 1) {
                event.getController().setAnimation(this.SUMMON_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 12 && this.getPhase() == 1) {
                event.getController().setAnimation(this.CONJURE_FANG_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getPhase() == 1) {
                if (this.getAnimationState() == 1 && this.getAttackAnimTimer() <= 0 && this.getInvulnerableTimer() <= 0 && this.getAnimationState() != 7) {
                    event.getController().setAnimation(this.IDLE_ANIMATION);
                    return PlayState.CONTINUE;
                }
                if ((this.getAnimationState() != 7 || this.getAnimationState() != 11 || this.getAnimationState() != 12 || this.getAnimationState() != 3) && this.getAttackAnimTimer() > 0) {
                    this.setAnimationState(2);
                }
            }
            if (this.getAnimationState() == 4 && this.getPhase() == 2) {
                event.getController().setAnimation(this.START_PHASE_2_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 13 && this.getPhase() == 3) {
                event.getController().setAnimation(this.STUNNED_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 5 && this.getPhase() == 3) {
                event.getController().setAnimation(this.PHASE_2_IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 6 && this.getPhase() == 3) {
                event.getController().setAnimation(this.PHASE_2_ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 8 && this.getPhase() == 4) {
                event.getController().setAnimation(this.START_PHASE_3_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (!(event.isMoving() || this.getPhase() != 5 || this.method_29504() || (double)this.method_6032() < 0.01)) {
                event.getController().setAnimation(this.CRAWL_IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 9 && this.getPhase() == 5 && !this.method_29504() && !((double)this.method_6032() < 0.01)) {
                event.getController().setAnimation(this.PHASE_3_ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.method_29504() || (double)this.method_6032() < 0.01) {
                event.getController().setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getPhase() == 1) {
                if (this.getAttackAnimTimer() <= 0 && this.getInvulnerableTimer() <= 0) {
                    this.setAnimationState(1);
                    return PlayState.STOP;
                }
                if (this.getAttackAnimTimer() > 0 && this.getAnimationState() == 1) {
                    return PlayState.STOP;
                }
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, (class_1352)new LichMeleeGoal(this, 1.0, false));
        this.field_6201.method_6277(4, (class_1352)new SummonFallenCorpsesGoal(this));
        this.field_6201.method_6277(5, (class_1352)new ConjureFangsGoal(this));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new ShootSkullGoal(this));
        this.field_6201.method_6277(8, (class_1352)new TeleportAndHealGoal(this));
        this.field_6201.method_6277(9, (class_1352)new LevitationGoal(this));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    public static class_5132.class_5133 createLichAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, (double)TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").healthInCastingPhase).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23721, TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").damageCastingPhase).method_26868(class_5134.field_23717, 25.0).method_26868(class_5134.field_23724, TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").armor).method_26868(class_5134.field_23725, TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").armorToughness).method_26868(class_5134.field_23718, 1.0);
    }

    public void method_5773() {
        if (!this.method_5770().field_9236 && this.getBossMusic() != null) {
            if (this.canPlayMusic() && this.field_6213 == 0) {
                this.method_5770().method_8421((class_1297)this, (byte)67);
            } else {
                this.method_5770().method_8421((class_1297)this, (byte)68);
            }
        }
        super.method_5773();
    }

    public void method_5711(byte id) {
        if (id == 67 && this.getMusicDelay() == 78) {
            BossMusicPlayer.playBossMusic(this);
        } else if (id == 68) {
            BossMusicPlayer.stopBossMusic(this);
        } else {
            super.method_5711(id);
        }
    }

    public void method_6007() {
        class_2680 altar;
        int i;
        this.randomDisplayTick(this.method_37908(), this.method_24515(), this.method_6051());
        int phaseTwoTimer = this.getStartPhaseTwoAnimTimer();
        if (phaseTwoTimer < 80 && phaseTwoTimer > 40) {
            float offset = 0.0f;
            for (i = 0; i < 25; ++i) {
                if (i < 7) {
                    offset += 0.15f;
                } else if (i > 12) {
                    offset -= 0.15f;
                }
                MathUtil.createParticleDisk(this.method_37908(), this.method_23317(), this.method_23318() + (double)((float)i / 10.0f), this.method_23321(), 0.0, 0.3, 0.0, 2.0f * offset, class_2398.field_22246, this.method_6051());
            }
        }
        if (this.getInvulnerableTimer() > 60 && this.field_5974.method_43048(6) == 0 && this.getPhase() == 1) {
            MathUtil.createParticleFlare(this.method_37908(), this.method_23317() - 0.75, this.method_23318() - 1.0 + 3.5 - (double)((float)this.getInvulnerableTimer() / 100.0f), this.method_23321() - 0.75, this.field_5974.method_43048(300) + 150, class_2398.field_23114, class_2398.field_22246, this.field_5974, false);
        }
        if (this.getInvulnerableTimer() > 20 && this.getPhase() == 1) {
            MathUtil.createParticleCircle(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0, 5.0f, class_2398.field_22246, this.method_6051(), 1.0f);
        }
        class_243 rotation = this.method_5828(1.0f);
        if (this.field_6213 > 0 && this.field_6213 <= 100 && this.field_5974.method_43048(4) == 0) {
            MathUtil.createParticleFlare(this.method_37908(), this.method_23317() - 0.75, this.method_23318() - 1.0, this.method_23321() - 0.75, this.field_5974.method_43048(300) + 150, class_2398.field_23114, class_2398.field_22246, this.field_5974, false);
        }
        if (this.getPhaseInvulnerableTimer() > 0 && this.getInvulnerableTimer() <= 0 && this.getPhase() == 1) {
            MathUtil.createParticleCircle(this.method_37908(), this.method_23317(), this.method_23318() + 1.5, this.method_23321(), 0.0, 0.0, 0.0, 2.5f, TGParticles.GRAVEYARD_SOUL_PARTICLE, this.method_6051(), 0.5f);
        }
        if (!this.canHuntStart() && this.getPhase() == 3 && this.getAnimationState() == 13 && this.field_5974.method_43048(7) == 0) {
            MathUtil.createParticleFlare(this.method_37908(), this.method_23317() - 0.75, this.method_23318() + 2.5, this.method_23321() - 0.75, this.field_5974.method_43048(100) + 150, class_2398.field_23114, class_2398.field_22246, this.field_5974, true);
        }
        if (this.getHealTimer() > 0 && this.getPhase() == 1) {
            MathUtil.createParticleSpiral(this.method_37908(), this.method_23317() + rotation.field_1352 * 3.5, this.method_23318() - 0.5, this.method_23321() + rotation.field_1350 * 3.5, 0.0, 0.0, 0.0, 350, class_2398.field_22246, this.field_5974);
        }
        if (this.getHealTimer() == 1 && this.getPhase() == 1) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_38830, class_3419.field_15251, 3.0f, -1.0f);
            for (i = 0; i < 20; ++i) {
                MathUtil.createParticleSpiral(this.method_37908(), this.method_23317() + rotation.field_1352 * 3.5, this.method_23318() - 0.5, this.method_23321() + rotation.field_1350 * 3.5, this.field_5974.method_43058() - this.field_5974.method_43058(), this.field_5974.method_43058() - this.field_5974.method_43058(), this.field_5974.method_43058() - this.field_5974.method_43058(), 350, class_2398.field_22246, this.field_5974);
            }
        }
        if (!this.method_5805() && this.homePos != null && (altar = this.method_37908().method_8320(this.homePos.method_10074())).method_26204() instanceof AltarBlock) {
            this.method_37908().method_8652(this.homePos.method_10074(), (class_2680)altar.method_11657((class_2769)AltarBlock.BLOODY, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (this.canHuntStart()) {
            List<class_1657> playersInRange = this.getPlayersInRange(30.0);
            for (class_1657 player : playersInRange) {
                if (this.getHuntTimer() != 0 && this.getHuntTimer() % 300 != 0 || player.method_7337() || !TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells) continue;
                player.method_5783(class_3417.field_14890, 2.5f, -5.0f);
                for (int i2 = 0; i2 < 10; ++i2) {
                    MathUtil.createParticleCircle(this.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), 0.0, 0.01, 0.0, 1.0f, TGParticles.GRAVEYARD_SOUL_PARTICLE, this.method_6051(), 0.5f);
                }
            }
        }
        if (!this.canHuntStart() && this.field_5974.method_43048(5) == 0) {
            this.method_5770().method_8396(null, this.method_24515(), class_3417.field_23060, class_3419.field_15251, 4.0f, -10.0f);
        }
        if (this.getMusicDelay() < 78) {
            this.setMusicDelay(this.getMusicDelay() + 1);
        }
        super.method_6007();
    }

    protected void method_5958() {
        class_1324 entityAttributeDmgInstance;
        class_1324 entityAttributeInstance;
        if (this.homePos == null) {
            this.homePos = class_2338.method_49637((double)((double)this.method_31477() + 0.5), (double)this.method_23318(), (double)((double)this.method_31479() + 0.5));
        }
        if (this.idleSoundAge <= 0) {
            this.method_5966();
            this.idleSoundAge = 100;
        }
        --this.idleSoundAge;
        int duration = this.getFightDurationTimer();
        this.setFightDurationTimer(duration + 1);
        if (duration > 400) {
            if (duration < TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").ghoulSpawnTimerInFight && duration % 400 == 0 && this.field_5974.method_43056()) {
                this.summonMob(false);
            } else if (duration >= TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").ghoulSpawnTimerInFight && duration < TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").ghoulSpawnTimerInFight * 2 && duration % 600 == 0 && this.field_5974.method_43056()) {
                this.summonMob(true);
            }
        }
        if (this.getPhase() == 5) {
            if (this.phaseThreeAttackSoundAge == 120) {
                this.playStartPhaseThreeAttackSound();
            }
            this.phaseThreeAttackSoundAge = this.phaseThreeAttackSoundAge == 20 ? 120 : --this.phaseThreeAttackSoundAge;
            entityAttributeInstance = this.method_5996(class_5134.field_23719);
            this.setCanMove(true);
            this.setAnimationState(9);
            if (!entityAttributeInstance.method_6196(CRAWL_SPEED_BOOST)) {
                entityAttributeInstance.method_26835(CRAWL_SPEED_BOOST);
            }
        }
        if (this.getPhase() == 3) {
            entityAttributeInstance = this.method_5996(class_5134.field_23719);
            entityAttributeDmgInstance = this.method_5996(class_5134.field_23721);
            if (this.getHuntCooldownTicker() > 0) {
                this.setHuntCooldownTicker(this.getHuntCooldownTicker() - 1);
            } else {
                this.setHuntStart(true);
            }
            if (this.canHuntStart()) {
                List<class_1657> playersInRange = this.getPlayersInRange(30.0);
                for (class_1657 player : playersInRange) {
                    if ((this.getHuntTimer() == 0 || this.getHuntTimer() % 300 == 0) && !player.method_7337() && TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells) {
                        for (int i = 0; i <= 5; ++i) {
                            class_2338 targetPos = class_2338.method_49637((double)(this.method_23317() + (double)class_3532.method_15395((class_5819)this.field_5974, (int)-10, (int)10)), (double)this.method_23318(), (double)(this.method_23321() + (double)class_3532.method_15395((class_5819)this.field_5974, (int)-10, (int)10)));
                            if (!this.method_5770().method_8320(targetPos).method_26215() || !this.method_5770().method_8320(targetPos.method_10084()).method_26215() || !this.method_5770().method_8320(targetPos.method_10074()).method_26212((class_1922)this.method_5770(), targetPos.method_10074())) continue;
                            player.method_20620((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260());
                            break;
                        }
                    }
                    if (this.getHuntTimer() % 50 != 0 || player.method_7337()) continue;
                    player.method_6092(new class_1293(class_1294.field_5919, 80, 2));
                }
                this.setCanMove(true);
                if (this.getHuntTimer() == 0) {
                    this.playHuntSound();
                    this.setHuntTimer(this.HUNT_DURATION);
                    if (TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells) {
                        this.setPhaseInvulTimer(this.HUNT_DURATION);
                    }
                }
                if (this.getHuntTimer() == 400) {
                    this.playHuntSound();
                }
                this.setAnimationState(6);
                if (!entityAttributeInstance.method_6196(ATTACKING_SPEED_BOOST)) {
                    entityAttributeInstance.method_26835(ATTACKING_SPEED_BOOST);
                }
                if (!entityAttributeDmgInstance.method_6196(DMG_BOOST)) {
                    entityAttributeDmgInstance.method_26835(DMG_BOOST);
                }
            }
            if (this.getHuntTimer() == 1 && this.getHuntCooldownTicker() == 0 && this.canHuntStart()) {
                this.method_20620((double)this.homePos.method_10263() + 0.5, (double)this.homePos.method_10264() + 0.5, (double)this.homePos.method_10260() + 0.5);
                this.setHuntCooldownTicker(600);
                this.setAnimationState(13);
                this.setHuntStart(false);
                this.setCanMove(false);
                entityAttributeInstance.method_6202(ATTACKING_SPEED_BOOST);
                entityAttributeDmgInstance.method_6202(DMG_BOOST);
            }
            if (this.getHuntTimer() > 0) {
                int timer = this.getHuntTimer() - 1;
                this.setHuntTimer(timer);
            }
        }
        if (this.getPhase() == 2) {
            int phaseTwoTimer = this.getStartPhaseTwoAnimTimer();
            if (this.getPhaseInvulnerableTimer() == 0) {
                this.method_20620((double)this.homePos.method_10263() + 0.5, (double)this.homePos.method_10264() + 0.5, (double)this.homePos.method_10260() + 0.5);
                this.setPhaseInvulTimer(121);
            }
            this.setAnimationState(4);
            if (phaseTwoTimer > 0) {
                if (phaseTwoTimer == 121) {
                    this.playStartPhaseTwoSound();
                }
                this.setStartPhaseTwoAnimTimer(phaseTwoTimer - 1);
            }
            if (phaseTwoTimer == 1) {
                this.setAnimationState(5);
                this.setPhase(this.getPhase() + 1);
            }
        }
        if (this.getPhase() == 4) {
            if (!TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells && this.canHuntStart()) {
                class_1324 entityAttributeInstance2 = this.method_5996(class_5134.field_23719);
                entityAttributeDmgInstance = this.method_5996(class_5134.field_23721);
                this.method_20620((double)this.homePos.method_10263() + 0.75, (double)this.homePos.method_10264() + 0.5, (double)this.homePos.method_10260() + 0.75);
                this.setHuntCooldownTicker(600);
                this.setAnimationState(13);
                this.setHuntStart(false);
                this.setCanMove(false);
                entityAttributeInstance2.method_6202(ATTACKING_SPEED_BOOST);
                entityAttributeDmgInstance.method_6202(DMG_BOOST);
            }
            int phaseThreeTimer = this.getStartPhaseThreeAnimTimer();
            if (this.getPhaseInvulnerableTimer() == 0) {
                this.setPhaseInvulTimer(220);
            }
            this.setAnimationState(8);
            if (phaseThreeTimer > 0) {
                if (phaseThreeTimer == 220) {
                    this.playStartPhaseThreeSound();
                }
                this.setStartPhaseThreeAnimTimer(phaseThreeTimer - 1);
            }
            if (phaseThreeTimer == 1) {
                this.setAnimationState(9);
                this.setPhase(this.getPhase() + 1);
            }
        }
        if (this.getPhaseInvulnerableTimer() > 0) {
            int timer = this.getPhaseInvulnerableTimer() - 1;
            this.setPhaseInvulTimer(timer);
        }
        if (this.getHealTimer() > 0) {
            List<class_1657> playersInRange = this.getPlayersInRange(30.0);
            for (class_1657 player : playersInRange) {
                if (this.getHealTimer() == this.HEALING_DURATION && !player.method_7337()) {
                    player.method_20620(this.method_23317(), this.method_23318() + (double)TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").playerTeleportYOffset, this.method_23321());
                }
                if (player.method_6059(class_1294.field_5901) || player.method_7337()) continue;
                player.method_6092(new class_1293(class_1294.field_5901, 40, 1));
                player.method_6092(new class_1293(class_1294.field_5920, 50, 1));
            }
        }
        this.setHealTimer(this.getHealTimer() - 1);
        this.setLevitationDurationTimer(this.getLevitationDurationTimer() - 1);
        this.setConjureFangTimer(this.getConjureFangTimer() - 1);
        this.setCorpseSpellTimer(this.getCorpseSpellTimer() - 1);
        if (this.getInvulnerableTimer() > 0) {
            int i = this.getInvulnerableTimer() - 1;
            int timer = this.getPhase() == 1 ? 490 : 200;
            if (this.getInvulnerableTimer() == 1 && this.getPhase() == 1) {
                this.setAnimationState(1);
            }
            this.bossBar.method_5408(1.0f - (float)i / (float)timer);
            this.setInvulTimer(i);
        } else {
            if (this.getAttackAnimTimer() == 40) {
                this.setAnimationState(2);
            }
            if (this.getAttackAnimTimer() > 0) {
                int animTimer = this.getAttackAnimTimer() - 1;
                this.setAttackAnimTimer(animTimer);
            }
            super.method_5958();
            this.bossBar.method_5408(this.method_6032() / this.getMaxHealthPerPhase());
        }
    }

    private float getMaxHealthPerPhase() {
        if (this.getPhase() == 1) {
            return this.HEALTH_PHASE_01;
        }
        return this.HEALTH_PHASE_02;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void onSummoned(class_2350 direction, class_2338 altarPos) {
        this.setAnimationState(0);
        this.applyInvulAndResetBossBar(490);
        this.homePos = class_2338.method_49637((double)((double)altarPos.method_10263() + 0.5), (double)altarPos.method_10264(), (double)((double)altarPos.method_10260() + 0.5));
        this.spawnDirection = direction;
        this.playSpawnSound();
    }

    private void applyInvulAndResetBossBar(int invul) {
        this.setInvulTimer(invul);
        this.bossBar.method_5408(0.0f);
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 == 5) {
            this.playDeathSound();
        }
        if (this.field_6213 == 160 && !this.method_5770().method_8608()) {
            this.method_5770().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public float method_18394(class_4050 pose, class_4048 dimensions) {
        if (pose == class_4050.field_18081) {
            return 2.0f;
        }
        return 4.0f;
    }

    public class_4048 method_18377(class_4050 pose) {
        if (pose == class_4050.field_18081) {
            this.method_18380(class_4050.field_18081);
            return CRAWL_DIMENSIONS;
        }
        return super.method_18377(pose);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_37222(class_1293 effect, @Nullable class_1297 source) {
        return false;
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!(this.getInvulnerableTimer() <= 0 && this.getPhaseInvulnerableTimer() <= 0 || source.method_48789(class_8103.field_42244))) {
            return false;
        }
        if (amount > this.method_6032() && this.getPhase() < 5 && !source.method_48789(class_8103.field_42244) && TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").isMultiphaseFight) {
            this.respawn();
            return false;
        }
        if (this.getHealTimer() > 0) {
            this.setHealTimer(1);
        } else {
            this.setHealTimer(0);
        }
        return super.method_5643(source, amount);
    }

    private void respawn() {
        this.setPhase(this.getPhase() + 1);
        this.setAnimationState(10);
        this.method_6012();
        this.applyInvulAndResetBossBar(200);
        this.method_6033(this.HEALTH_PHASE_02);
        this.setAttackAnimTimer(0);
        if (this.getPhase() == 4 || this.getPhase() == 5) {
            this.method_18377(class_4050.field_18081);
        }
    }

    public void randomDisplayTick(class_1937 world, class_2338 pos, class_5819 random) {
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        double d = (double)i + (double)random.method_43048(3) - (double)random.method_43048(3);
        double e = (double)j + 4.2;
        double f = (double)k + (double)random.method_43048(3) - (double)random.method_43048(3);
        world.method_8406((class_2394)class_2398.field_22247, d, e, f, 0.0, 0.0, 0.0);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_10103(i + class_3532.method_15395((class_5819)random, (int)-17, (int)17), j + random.method_43048(10), k + class_3532.method_15395((class_5819)random, (int)-17, (int)17));
        class_2680 blockState = world.method_8320((class_2338)mutable);
        if (!blockState.method_26234((class_1922)world, (class_2338)mutable)) {
            world.method_8406((class_2394)class_2398.field_11251, (double)mutable.method_10263() + random.method_43058(), (double)mutable.method_10264() + random.method_43058(), (double)mutable.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
        }
    }

    public List<class_1657> getPlayersInRange(double range) {
        class_238 box = new class_238(this.method_24515()).method_1014(range);
        return this.method_5770().method_18467(class_1657.class, box);
    }

    public boolean canMeeleAttack() {
        return this.getPhase() == 1 && this.getPhaseInvulnerableTimer() <= 0 && this.getInvulnerableTimer() <= 0 && this.getHealTimer() <= 0 && this.getLevitationDurationTimer() <= 0 && this.getConjureFangTimer() <= 0 && this.getCorpseSpellTimer() <= 0 && this.method_6032() > 35.0f;
    }

    public boolean canSpellCast() {
        return this.getPhase() == 1 && this.getAttackAnimTimer() <= 0 && this.getPhaseInvulnerableTimer() <= 0 && this.getInvulnerableTimer() <= 0 && this.getHealTimer() <= 0 && this.getLevitationDurationTimer() <= 0 && this.getConjureFangTimer() <= 0 && this.getCorpseSpellTimer() <= 0;
    }

    public boolean method_5659() {
        return true;
    }

    private boolean summonMob(boolean hard) {
        if (this.getHuntTimer() <= 1) {
            class_238 box = new class_238(this.method_24515()).method_1014(35.0);
            List mobs = this.method_37908().method_18467(HostileGraveyardEntity.class, box);
            if (mobs.size() >= TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").maxSummonedMobs) {
                return false;
            }
            for (int i = 10; i > 0; --i) {
                class_2338 pos = new class_2338(this.method_31477() + class_3532.method_15395((class_5819)this.field_5974, (int)-15, (int)15), this.method_31478(), this.method_31479() + class_3532.method_15395((class_5819)this.field_5974, (int)-15, (int)15));
                int amount = this.field_5974.method_43048(TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").maxGroupSizeSummonedMobs) + 1;
                if (!this.method_5770().method_8320(pos).method_26215() || !this.method_5770().method_8320(pos.method_10084()).method_26215() || !this.method_5770().method_8320(pos.method_10084().method_10084()).method_26215() || this.method_5770().method_8320(pos.method_10074()).method_26215()) continue;
                if (!hard) {
                    for (int ii = 0; ii < amount; ++ii) {
                        RevenantEntity revenant = (RevenantEntity)TGEntities.REVENANT.method_5883(this.method_5770());
                        revenant.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
                        revenant.setCanBurnInSunlight(false);
                        this.method_5770().method_8649((class_1297)revenant);
                    }
                } else {
                    for (int ii = 0; ii < amount - 1; ++ii) {
                        GhoulEntity ghoul = (GhoulEntity)TGEntities.GHOUL.method_5883(this.method_5770());
                        ghoul.setVariant((byte)9);
                        ghoul.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
                        ghoul.setCanBurnInSunlight(false);
                        this.method_5770().method_8649((class_1297)ghoul);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean method_17326() {
        return true;
    }

    public boolean canHuntStart() {
        return (Boolean)this.field_6011.method_12789(CAN_HUNT_START);
    }

    public void setHuntStart(boolean bool) {
        this.field_6011.method_12778(CAN_HUNT_START, (Object)bool);
    }

    public void setCanMove(boolean bool) {
        this.field_6011.method_12778(CAN_MOVE, (Object)bool);
    }

    public boolean canMove() {
        return (Boolean)this.field_6011.method_12789(CAN_MOVE);
    }

    public int getInvulnerableTimer() {
        return (Integer)this.field_6011.method_12789(INVUL_TIMER);
    }

    public void setInvulTimer(int ticks) {
        this.field_6011.method_12778(INVUL_TIMER, (Object)ticks);
    }

    public int getFightDurationTimer() {
        return (Integer)this.field_6011.method_12789(FIGHT_DURATION_TIMER);
    }

    public void setFightDurationTimer(int ticks) {
        this.field_6011.method_12778(FIGHT_DURATION_TIMER, (Object)ticks);
    }

    public int getLevitationDurationTimer() {
        return (Integer)this.field_6011.method_12789(LEVITATION_DURATION_TIMER);
    }

    public void setLevitationDurationTimer(int ticks) {
        this.field_6011.method_12778(LEVITATION_DURATION_TIMER, (Object)ticks);
    }

    public int getConjureFangTimer() {
        return (Integer)this.field_6011.method_12789(CONJURE_FANG_TIMER);
    }

    public void setConjureFangTimer(int ticks) {
        this.field_6011.method_12778(CONJURE_FANG_TIMER, (Object)ticks);
    }

    public int getCorpseSpellTimer() {
        return (Integer)this.field_6011.method_12789(CORPSE_SPELL_DURATION_TIMER);
    }

    public void setCorpseSpellTimer(int ticks) {
        this.field_6011.method_12778(CORPSE_SPELL_DURATION_TIMER, (Object)ticks);
    }

    public int getHealTimer() {
        return (Integer)this.field_6011.method_12789(HEAL_DURATION_TIMER);
    }

    public void setHealTimer(int ticks) {
        this.field_6011.method_12778(HEAL_DURATION_TIMER, (Object)ticks);
    }

    public int getPhaseInvulnerableTimer() {
        return (Integer)this.field_6011.method_12789(PHASE_INVUL_TIMER);
    }

    public void setPhaseInvulTimer(int ticks) {
        this.field_6011.method_12778(PHASE_INVUL_TIMER, (Object)ticks);
    }

    public int getHuntTimer() {
        return (Integer)this.field_6011.method_12789(HUNT_TIMER);
    }

    public void setHuntTimer(int ticks) {
        this.field_6011.method_12778(HUNT_TIMER, (Object)ticks);
    }

    public int getAnimationState() {
        return (Integer)this.field_6011.method_12789(ANIMATION);
    }

    public void setAnimationState(int state) {
        this.field_6011.method_12778(ANIMATION, (Object)state);
    }

    public int getPhase() {
        return (Integer)this.field_6011.method_12789(PHASE);
    }

    public void setPhase(int phase) {
        this.field_6011.method_12778(PHASE, (Object)phase);
    }

    public int getStartPhaseTwoAnimTimer() {
        return (Integer)this.field_6011.method_12789(PHASE_TWO_START_ANIM_TIMER);
    }

    public void setStartPhaseTwoAnimTimer(int startPhaseTwoAnimTimer) {
        this.field_6011.method_12778(PHASE_TWO_START_ANIM_TIMER, (Object)startPhaseTwoAnimTimer);
    }

    public int getStartPhaseThreeAnimTimer() {
        return (Integer)this.field_6011.method_12789(PHASE_THREE_START_ANIM_TIMER);
    }

    public void setStartPhaseThreeAnimTimer(int startPhaseThreeAnimTimer) {
        this.field_6011.method_12778(PHASE_THREE_START_ANIM_TIMER, (Object)startPhaseThreeAnimTimer);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.field_6011.method_12789(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.field_6011.method_12778(ATTACK_ANIM_TIMER, (Object)time);
    }

    public int getHuntCooldownTicker() {
        return this.huntCooldownTicker;
    }

    public void setHuntCooldownTicker(int huntCooldownTicker) {
        this.huntCooldownTicker = huntCooldownTicker;
    }

    public int getMusicDelay() {
        return (Integer)this.field_6011.method_12789(MUSIC_DELAY);
    }

    public void setMusicDelay(int time) {
        this.field_6011.method_12778(MUSIC_DELAY, (Object)time);
    }

    private void playSpawnSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_SPAWN, class_3419.field_15251, 15.0f, 1.0f);
    }

    public void playAttackSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_MELEE, class_3419.field_15251, 10.0f, 1.0f);
    }

    public void playHealSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_CAST_TELEPORT, class_3419.field_15251, 10.0f, 1.0f);
    }

    private void playCorpseSpellSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_CORPSE_SPELL, class_3419.field_15251, 10.0f, 1.0f);
    }

    private void playStartPhaseTwoSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_PHASE_02, class_3419.field_15251, 10.0f, 1.0f);
    }

    private void playStartPhaseThreeSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_PHASE_03, class_3419.field_15251, 10.0f, 1.0f);
    }

    private void playStartPhaseThreeAttackSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_PHASE_03_ATTACK, class_3419.field_15251, 10.0f, 1.0f);
    }

    private void playDeathSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_DEATH, class_3419.field_15251, 10.0f, 1.0f);
    }

    public void playScareSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_SCARE, class_3419.field_15251, 10.0f, 1.0f);
    }

    private void playHuntSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_HUNT, class_3419.field_15251, 10.0f, 1.0f);
    }

    private void playShootSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_CAST_SKULL, class_3419.field_15251, 10.0f, 1.0f);
    }

    private void playLevitationSound() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_CAST_LEVITATION, class_3419.field_15251, 10.0f, 1.0f);
    }

    public void method_5966() {
        this.method_5770().method_8396(null, this.method_24515(), TGSounds.LICH_IDLE, class_3419.field_15251, 15.0f, 1.0f);
    }

    protected class_3414 method_6011(class_1282 source) {
        return TGSounds.LICH_HURT;
    }

    public class_3414 getBossMusic() {
        return TGSounds.LICH_THEME_01;
    }

    protected boolean canPlayMusic() {
        return !this.method_5701();
    }

    public boolean canPlayerHearMusic(class_1657 player) {
        return player != null && this.method_5739((class_1297)player) < 2500.0f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CAN_MOVE, (Object)false);
        this.field_6011.method_12784(INVUL_TIMER, (Object)0);
        this.field_6011.method_12784(MUSIC_DELAY, (Object)0);
        this.field_6011.method_12784(HUNT_TIMER, (Object)0);
        this.field_6011.method_12784(FIGHT_DURATION_TIMER, (Object)0);
        this.field_6011.method_12784(HEAL_DURATION_TIMER, (Object)0);
        this.field_6011.method_12784(LEVITATION_DURATION_TIMER, (Object)0);
        this.field_6011.method_12784(CORPSE_SPELL_DURATION_TIMER, (Object)0);
        this.field_6011.method_12784(PHASE_INVUL_TIMER, (Object)0);
        this.field_6011.method_12784(ANIMATION, (Object)1);
        this.field_6011.method_12784(ATTACK_ANIM_TIMER, (Object)0);
        this.field_6011.method_12784(CONJURE_FANG_TIMER, (Object)0);
        this.field_6011.method_12784(PHASE_TWO_START_ANIM_TIMER, (Object)121);
        this.field_6011.method_12784(PHASE_THREE_START_ANIM_TIMER, (Object)220);
        this.field_6011.method_12784(PHASE, (Object)1);
        this.field_6011.method_12784(CAN_HUNT_START, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10569("Invul", this.getInvulnerableTimer());
        nbt.method_10569("PhaseInvul", this.getPhaseInvulnerableTimer());
        nbt.method_10569("Phase", Math.max(this.getPhase(), 1));
        nbt.method_10569("AttackTimer", this.getAttackAnimTimer());
        nbt.method_10569("FightTimer", this.getFightDurationTimer());
        nbt.method_10569("LevTimer", this.getLevitationDurationTimer());
        nbt.method_10569("HealTimer", this.getHealTimer());
        nbt.method_10569("CorpseSpellTimer", this.getCorpseSpellTimer());
        nbt.method_10569("ConjureTimer", this.getConjureFangTimer());
        nbt.method_10569("Anim", this.getAnimationState());
        nbt.method_10548("Health", this.method_6032());
        nbt.method_10556("CanMove", this.canMove());
        nbt.method_10556("CanHunt", this.canHuntStart());
        super.method_5652(nbt);
    }

    public void method_5749(class_2487 nbt) {
        if (!nbt.method_10545("Invul")) {
            this.setInvulTimer(0);
            this.setPhaseInvulTimer(0);
            this.setPhase(1);
            this.setAnimationState(1);
            this.method_6033(this.HEALTH_PHASE_01);
            this.setAttackAnimTimer(0);
            this.setHealTimer(0);
            this.setLevitationDurationTimer(0);
            this.setCorpseSpellTimer(0);
            this.setConjureFangTimer(0);
            this.setFightDurationTimer(0);
            this.setCanMove(false);
            this.setHuntStart(false);
        } else {
            this.setInvulTimer(nbt.method_10550("Invul"));
            this.setPhaseInvulTimer(nbt.method_10550("PhaseInvul"));
            this.setPhase(nbt.method_10550("Phase"));
            this.setAnimationState(nbt.method_10550("Anim"));
            this.method_6033(nbt.method_10583("Health"));
            this.setAttackAnimTimer(nbt.method_10550("AttackTimer"));
            this.setHealTimer(nbt.method_10550("HealTimer"));
            this.setLevitationDurationTimer(nbt.method_10550("LevTimer"));
            this.setCorpseSpellTimer(nbt.method_10550("CorpseSpellTimer"));
            this.setConjureFangTimer(nbt.method_10550("ConjureTimer"));
            this.setFightDurationTimer(nbt.method_10550("FightTimer"));
            this.setCanMove(nbt.method_10577("CanMove"));
            this.setHuntStart(nbt.method_10577("CanHunt"));
        }
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
        super.method_5749(nbt);
    }

    static {
        ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
        ATTACKING_DMG_BOOST_ID = UUID.fromString("120E0DFB-87AE-4653-9776-831010E291A1");
        CRAWL_SPEED_BOOST_ID = UUID.fromString("120E0DFB-87AE-1978-9776-831010E291A2");
        INVUL_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        PHASE_INVUL_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        HUNT_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        ATTACK_ANIM_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        PHASE_TWO_START_ANIM_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        PHASE_THREE_START_ANIM_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        ANIMATION = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        FIGHT_DURATION_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        HEAL_DURATION_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        CONJURE_FANG_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        CORPSE_SPELL_DURATION_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        LEVITATION_DURATION_TIMER = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        PHASE = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        CAN_HUNT_START = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13323);
        CAN_MOVE = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13323);
        MUSIC_DELAY = class_2945.method_12791(LichEntity.class, (class_2941)class_2943.field_13327);
        CAN_ATTACK_PREDICATE = class_1297::method_31747;
        HEAD_TARGET_PREDICATE = class_4051.method_36625().method_18418(20.0).method_18420(CAN_ATTACK_PREDICATE);
        CRAWL_DIMENSIONS = class_4048.method_18385((float)1.8f, (float)2.0f);
        CRAWL_SPEED_BOOST = new class_1322(CRAWL_SPEED_BOOST_ID, "Crawl speed boost", 0.18, class_1322.class_1323.field_6328);
        ATTACKING_SPEED_BOOST = new class_1322(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").speedInHuntPhase, class_1322.class_1323.field_6328);
        DMG_BOOST = new class_1322(ATTACKING_DMG_BOOST_ID, "Damage speed boost", TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").damageHuntingPhaseAddition, class_1322.class_1323.field_6328);
    }

    public class SummonFallenCorpsesGoal
    extends class_1352 {
        protected final LichEntity lich;
        private final int FALL_HEIGHT = 10;
        private final int SQUARE_SIZE = 30;
        private final int CORPSE_SPAWN_RARITY_PLAYER = 9;
        private class_2338 pos;
        private List<class_1657> list;
        private List<class_2338> positions = new ArrayList<class_2338>();

        public SummonFallenCorpsesGoal(LichEntity lich) {
            this.lich = lich;
        }

        public boolean method_6264() {
            return LichEntity.this.getCorpseSpellTimer() <= -TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").cooldownCorpseSpell && LichEntity.this.field_5974.method_43048(75) == 0 && LichEntity.this.canSpellCast();
        }

        public void method_6269() {
            if (TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells) {
                LichEntity.this.setPhaseInvulTimer(LichEntity.this.CORPSE_SPELL_DURATION);
            }
            LichEntity.this.setCorpseSpellTimer(LichEntity.this.CORPSE_SPELL_DURATION);
            LichEntity.this.playCorpseSpellSound();
            this.lich.method_20620((double)this.lich.homePos.method_10263() + 0.5, (double)this.lich.homePos.method_10264() + 0.5, (double)this.lich.homePos.method_10260() + 0.5);
            this.pos = this.lich.method_24515();
            this.list = LichEntity.this.getPlayersInRange(35.0);
            for (int i = -30; i < 30; ++i) {
                for (int ii = -30; ii < 30; ++ii) {
                    class_2338 position = this.lich.homePos.method_10074().method_10074().method_10069(i, 0, ii);
                    if (!LichEntity.this.method_5770().method_8320(position).method_26212((class_1922)LichEntity.this.method_5770(), position)) continue;
                    this.positions.add(this.pos.method_10069(i, 10, ii));
                }
            }
            super.method_6269();
        }

        public void method_6270() {
            LichEntity.this.setAnimationState(1);
            super.method_6270();
        }

        public boolean method_6266() {
            if (LichEntity.this.getCorpseSpellTimer() > 0) {
                return true;
            }
            return super.method_6266();
        }

        public void method_6268() {
            if (LichEntity.this.getCorpseSpellTimer() > 1) {
                LichEntity.this.setAnimationState(3);
                if (LichEntity.this.getCorpseSpellTimer() == 1) {
                    LichEntity.this.setAnimationState(1);
                }
            }
            if (LichEntity.this.getCorpseSpellTimer() % 200 == 0) {
                LichEntity.this.summonMob(true);
            }
            if (this.positions.size() <= 3) {
                LichEntity.this.setCorpseSpellTimer(0);
                LichEntity.this.setPhaseInvulTimer(0);
                this.method_6270();
                return;
            }
            class_3218 serverWorld = (class_3218)LichEntity.this.method_5770();
            FallingCorpse corpse = (FallingCorpse)TGEntities.FALLING_CORPSE.method_5883((class_1937)serverWorld);
            class_2338 blockPos = this.positions.get(LichEntity.this.field_5974.method_43048(this.positions.size()));
            corpse.method_23327((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.55, (double)blockPos.method_10260() + 0.5);
            serverWorld.method_8649((class_1297)corpse);
            if (LichEntity.this.field_5974.method_43048(9) == 0 && this.list.size() > 0) {
                FallingCorpse corpse2 = (FallingCorpse)TGEntities.FALLING_CORPSE.method_5883((class_1937)serverWorld);
                class_1657 target = this.list.get(LichEntity.this.field_5974.method_43048(this.list.size()));
                if (target != null && !target.method_7337()) {
                    class_2338 blockPos2 = target.method_24515().method_10069(0, 10, 0);
                    corpse2.method_23327((double)blockPos2.method_10263() + 0.5, (double)blockPos2.method_10264() + 0.55, (double)blockPos2.method_10260() + 0.5);
                    serverWorld.method_8649((class_1297)corpse2);
                }
            }
        }
    }

    public class ConjureFangsGoal
    extends class_1352 {
        private final LichEntity mob;

        public ConjureFangsGoal(LichEntity mob) {
            this.mob = mob;
        }

        public boolean method_6264() {
            return LichEntity.this.canSpellCast() && LichEntity.this.field_5974.method_43048(25) == 0 && this.mob.getConjureFangTimer() <= -100;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6270() {
            LichEntity.this.setAnimationState(1);
            super.method_6270();
        }

        public boolean method_6266() {
            if (LichEntity.this.getConjureFangTimer() > 0) {
                return true;
            }
            return super.method_6266();
        }

        public void method_6269() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity != null) {
                double d = Math.min(livingEntity.method_23318(), this.mob.method_23318());
                double e = Math.max(livingEntity.method_23318(), this.mob.method_23318()) + 1.0;
                float f = (float)class_3532.method_15349((double)(livingEntity.method_23321() - this.mob.method_23321()), (double)(livingEntity.method_23317() - this.mob.method_23317()));
                if (this.mob.method_5858((class_1297)livingEntity) <= 64.0) {
                    LichEntity.this.setConjureFangTimer(40);
                    for (int i = 0; i < 16; ++i) {
                        double h = 1.25 * (double)(i + 1);
                        int j = 1 * i;
                        this.conjureFangs(this.mob.method_23317() + (double)class_3532.method_15362((float)f) * h, this.mob.method_23321() + (double)class_3532.method_15374((float)f) * h, d, e, f, j);
                        this.conjureFangs(this.mob.method_23317() + (double)class_3532.method_15362((float)(-f)) * h, this.mob.method_23321() + (double)class_3532.method_15374((float)(-f)) * h, d, e, -f, j);
                        this.conjureFangs(this.mob.method_23317() + (double)class_3532.method_15374((float)f) * h, this.mob.method_23321() + (double)class_3532.method_15362((float)f) * h, d, e, f, j);
                        this.conjureFangs(this.mob.method_23317() + (double)class_3532.method_15374((float)(-f)) * h, this.mob.method_23321() + (double)class_3532.method_15362((float)(-f)) * h, d, e, -f, j);
                    }
                }
            }
        }

        public void method_6268() {
            if (LichEntity.this.getConjureFangTimer() > 1) {
                LichEntity.this.setAnimationState(12);
                if (LichEntity.this.getConjureFangTimer() == 1) {
                    LichEntity.this.setAnimationState(1);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
            boolean bl = false;
            double d = 0.0;
            do {
                class_2680 blockState2;
                class_265 voxelShape;
                class_2338 blockPos2 = blockPos.method_10074();
                class_2680 blockState = this.mob.method_5770().method_8320(blockPos2);
                if (!blockState.method_26206((class_1922)this.mob.method_5770(), blockPos2, class_2350.field_11036)) continue;
                if (!this.mob.method_5770().method_22347(blockPos) && !(voxelShape = (blockState2 = this.mob.method_5770().method_8320(blockPos)).method_26220((class_1922)this.mob.method_5770(), blockPos)).method_1110()) {
                    d = voxelShape.method_1105(class_2350.class_2351.field_11052);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
            if (bl) {
                this.mob.method_5770().method_8649((class_1297)new class_1669(this.mob.method_5770(), x, (double)blockPos.method_10264() + d, z, yaw, warmup, (class_1309)this.mob));
            }
        }
    }

    public class ShootSkullGoal
    extends class_1352 {
        private final LichEntity mob;
        public int cooldown;

        public ShootSkullGoal(LichEntity mob) {
            this.mob = mob;
        }

        public boolean method_6264() {
            return this.mob.method_5968() != null && LichEntity.this.canSpellCast();
        }

        public void method_6269() {
            this.cooldown = 0;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6270() {
            LichEntity.this.setAnimationState(1);
            super.method_6270();
        }

        public void method_6268() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity != null) {
                if (livingEntity.method_5858((class_1297)this.mob) < 8000.0 && livingEntity.method_5858((class_1297)this.mob) > 16.0) {
                    class_1937 world = this.mob.method_5770();
                    ++this.cooldown;
                    if (this.cooldown == 10) {
                        LichEntity.this.playShootSound();
                        LichEntity.this.setAnimationState(7);
                    }
                    if (this.cooldown == 20) {
                        class_243 vec3d3 = this.mob.method_5828(1.0f);
                        double d = this.mob.method_5858((class_1297)livingEntity) * 2.0;
                        double h = Math.sqrt(Math.sqrt(d)) * 0.5;
                        double e = livingEntity.method_23317() - this.mob.method_23317();
                        double f = livingEntity.method_23323(0.5) - this.mob.method_23323(0.5) - 1.25;
                        double g = livingEntity.method_23321() - this.mob.method_23321();
                        SkullEntity skull = new SkullEntity(this.mob.method_37908(), (class_1309)this.mob, e, f, g);
                        skull.method_5814(this.mob.method_23317() - vec3d3.field_1352 * 0.5, this.mob.method_23323(0.5) + 1.25, this.mob.method_23321() - vec3d3.field_1350 * 0.5);
                        world.method_8649((class_1297)skull);
                        int amount = LichEntity.this.field_5974.method_43048(TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").maxAmountSkullsInShootSkullSpell) + 2;
                        for (int i = 0; i < amount; ++i) {
                            SkullEntity devSkull = new SkullEntity(this.mob.method_37908(), (class_1309)this.mob, this.mob.method_6051().method_43385(e, 2.297 * h), f, this.mob.method_6051().method_43385(g, 2.297 * h));
                            devSkull.method_5814(this.mob.method_23317() - vec3d3.field_1352 * 0.5, this.mob.method_23323(0.5) + 1.25, this.mob.method_23321() - vec3d3.field_1350 * 0.5);
                            world.method_8649((class_1297)devSkull);
                        }
                        this.mob.method_5988().method_6226((class_1297)livingEntity, 10.0f, 10.0f);
                    }
                    if (this.cooldown == 45) {
                        this.cooldown = -40;
                        LichEntity.this.setAnimationState(1);
                    }
                } else if (this.cooldown > 0) {
                    --this.cooldown;
                }
            }
        }
    }

    public class TeleportAndHealGoal
    extends class_1352 {
        private final LichEntity mob;

        public TeleportAndHealGoal(LichEntity mob) {
            this.mob = mob;
        }

        public boolean method_6264() {
            return this.mob.method_6032() <= 300.0f && LichEntity.this.field_5974.method_43048(40) == 0 && this.mob.getHealTimer() <= -TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").cooldownTeleportPlayerAndHeal && LichEntity.this.canSpellCast();
        }

        public void method_6269() {
            LichEntity.this.setHealTimer(LichEntity.this.HEALING_DURATION);
            this.mob.method_20620((double)LichEntity.this.homePos.method_10263() + 0.5, (double)LichEntity.this.homePos.method_10264() + 0.5, (double)LichEntity.this.homePos.method_10260() + 0.5);
            LichEntity.this.playHealSound();
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6270() {
            LichEntity.this.setAnimationState(1);
            super.method_6270();
        }

        public boolean method_6266() {
            if (LichEntity.this.getHealTimer() > 0) {
                return true;
            }
            return super.method_6266();
        }

        public void method_6268() {
            if (LichEntity.this.getHealTimer() > 1) {
                LichEntity.this.setAnimationState(11);
                this.mob.method_6025(0.2f);
                if (LichEntity.this.getHealTimer() == 1) {
                    LichEntity.this.setAnimationState(1);
                }
            }
        }
    }

    public class LevitationGoal
    extends class_1352 {
        private final LichEntity mob;

        public LevitationGoal(LichEntity mob) {
            this.mob = mob;
        }

        public boolean method_6264() {
            return LichEntity.this.canSpellCast() && LichEntity.this.field_5974.method_43048(125) == 0 && this.mob.getLevitationDurationTimer() <= -TheGraveyard.config.corruptedChampionConfigEntries.get((Object)"corrupted_champion").cooldownLevitationSpell;
        }

        public void method_6269() {
            LichEntity.this.setLevitationDurationTimer(LichEntity.this.LEVITATION_DURATION);
            List<class_1657> player = LichEntity.this.getPlayersInRange(30.0);
            for (class_1657 playerEntity : player) {
                if (playerEntity.method_7337()) continue;
                playerEntity.method_6092(new class_1293(class_1294.field_5902, LichEntity.this.LEVITATION_DURATION, 1));
            }
            LichEntity.this.playLevitationSound();
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6270() {
            LichEntity.this.setAnimationState(1);
            super.method_6270();
        }

        public boolean method_6266() {
            if (LichEntity.this.getLevitationDurationTimer() > 0) {
                return true;
            }
            return super.method_6266();
        }

        public void method_6268() {
            if (LichEntity.this.getLevitationDurationTimer() > 1) {
                LichEntity.this.setAnimationState(11);
                if (LichEntity.this.getLevitationDurationTimer() == 1) {
                    LichEntity.this.setAnimationState(1);
                }
            }
        }
    }
}

