/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop;

import ht.treechop.TreeChop;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.ITreeChopBlockBehavior;
import ht.treechop.api.TreeChopAPI;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class TreeChopInternalAPI
implements TreeChopAPI {
    private static final Map<class_2248, ITreeChopBlockBehavior> choppableBlockBehaviors = new HashMap<class_2248, ITreeChopBlockBehavior>();
    private static final Map<class_2248, Boolean> choppableBlockOverrides = new HashMap<class_2248, Boolean>(){

        @Override
        public Boolean put(class_2248 block, Boolean isChoppable) {
            ConfigHandler.COMMON.choppableBlocks.reset();
            return super.put(block, isChoppable);
        }
    };
    private static final Map<class_2248, Boolean> leavesBlockOverrides = new HashMap<class_2248, Boolean>(){

        @Override
        public Boolean put(class_2248 block, Boolean isLeaves) {
            ConfigHandler.COMMON.leavesBlocks.reset();
            return super.put(block, isLeaves);
        }
    };
    private static final Map<class_1792, IChoppingItem> choppingItemBehaviors = new HashMap<class_1792, IChoppingItem>();
    private static final Map<class_1792, Boolean> choppingItemOverrides = new HashMap<class_1792, Boolean>();
    private static final Marker API_MARKER = MarkerManager.getMarker((String)"API");
    private final String modId;

    TreeChopInternalAPI(String modId) {
        this.modId = modId;
    }

    private void print(String message) {
        if (((Boolean)ConfigHandler.COMMON.verboseAPI.get()).booleanValue()) {
            TreeChop.LOGGER.info(API_MARKER, "API [{}] {}", (Object)this.modId, (Object)message);
        }
    }

    @Override
    public void overrideChoppableBlock(class_2248 block, boolean isChoppable) {
        choppableBlockOverrides.put(block, isChoppable);
        this.print(String.format("set isChoppable=%s for block %s", isChoppable, TreeChop.platform.getResourceLocationForBlock(block)));
    }

    @Override
    public void overrideLeavesBlock(class_2248 block, boolean isLeaves) {
        leavesBlockOverrides.put(block, isLeaves);
        this.print(String.format("set isLeaves=%s for block %s", isLeaves, TreeChop.platform.getResourceLocationForBlock(block)));
    }

    @Override
    public void overrideChoppingItem(class_1792 item, boolean canChop) {
        choppingItemOverrides.put(item, canChop);
        this.print(String.format("set canChop=%s for item %s", canChop, TreeChop.platform.getResourceLocationForItem(item)));
    }

    @Override
    public void registerChoppableBlockBehavior(class_2248 block, ITreeChopBlockBehavior handler) {
        choppableBlockBehaviors.put(block, handler);
        this.print(String.format("registered new behavior for block %s", TreeChop.platform.getResourceLocationForBlock(block)));
    }

    @Override
    public boolean deregisterChoppableBlockBehavior(class_2248 block) {
        ITreeChopBlockBehavior existing = choppableBlockBehaviors.remove(block);
        this.print(String.format("deregistered behavior for block %s", TreeChop.platform.getResourceLocationForBlock(block)));
        return existing == null;
    }

    @Override
    public ITreeChopBlockBehavior getRegisteredChoppableBlockBehavior(class_2248 block) {
        return choppableBlockBehaviors.get(block);
    }

    @Override
    public void registerChoppingItemBehavior(class_1792 item, IChoppingItem handler) {
        choppingItemBehaviors.put(item, handler);
        this.print(String.format("registered new behavior for item %s", TreeChop.platform.getResourceLocationForItem(item)));
    }

    @Override
    public boolean deregisterChoppingItemBehavior(class_1792 item) {
        IChoppingItem existing = choppingItemBehaviors.remove(item);
        this.print(String.format("deregistered behavior for item %s", TreeChop.platform.getResourceLocationForItem(item)));
        return existing == null;
    }

    @Override
    public IChoppingItem getRegisteredChoppingItemBehavior(class_1792 item) {
        return choppingItemBehaviors.get(item);
    }

    @Override
    public boolean isBlockChoppable(class_1937 level, class_2338 pos, class_2680 blockState) {
        return ChopUtil.isBlockALog(level, pos, blockState);
    }

    @Override
    public boolean isBlockLeaves(class_1937 level, class_2338 pos, class_2680 blockState) {
        return ChopUtil.isBlockLeaves(blockState);
    }

    @Override
    public boolean canChopWithItem(class_1657 player, class_1799 stack, class_1937 level, class_2338 pos, class_2680 blockState) {
        return ChopUtil.canChopWithTool(player, stack, level, pos, blockState);
    }

    public Stream<Pair<class_2248, Boolean>> getChoppableBlockOverrides() {
        return choppableBlockOverrides.entrySet().stream().map(entry -> Pair.of((Object)((class_2248)entry.getKey()), (Object)((Boolean)entry.getValue())));
    }

    public Stream<Pair<class_2248, Boolean>> getLeavesBlockOverrides() {
        return leavesBlockOverrides.entrySet().stream().map(entry -> Pair.of((Object)((class_2248)entry.getKey()), (Object)((Boolean)entry.getValue())));
    }

    public Stream<Pair<class_1792, Boolean>> getChoppingItemOverrides() {
        return choppingItemOverrides.entrySet().stream().map(entry -> Pair.of((Object)((class_1792)entry.getKey()), (Object)((Boolean)entry.getValue())));
    }
}

