/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChop;
import ht.treechop.client.Client;
import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.Setting;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ServerPermissionsPacket
implements CustomPacket {
    public static final class_2960 ID = TreeChop.resource("server_permissions");
    private final Permissions permissions;

    public ServerPermissionsPacket(Permissions permissions) {
        this.permissions = permissions;
    }

    @Override
    public class_2540 encode(class_2540 buffer) {
        Set<Setting> settings = this.permissions.getPermittedSettings();
        buffer.writeInt(settings.size());
        settings.forEach(setting -> setting.encode(buffer));
        return buffer;
    }

    public static ServerPermissionsPacket decode(class_2540 buffer) {
        int numSettings = buffer.readInt();
        List<Setting> settings = IntStream.range(0, numSettings).mapToObj($ -> Setting.decode(buffer)).collect(Collectors.toList());
        return new ServerPermissionsPacket(new Permissions(settings));
    }

    public static void handle(ServerPermissionsPacket message) {
        Client.updatePermissions(message.permissions);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }
}

