/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.mixin;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.DragonRespawnStage;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndPodiumFeature;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterEndSpawnPlatformFeature;
import com.yungnickyoung.minecraft.betterendisland.world.feature.BetterSpikeFeature;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_156;
import net.minecraft.class_174;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2700;
import net.minecraft.class_2874;
import net.minecraft.class_2876;
import net.minecraft.class_2881;
import net.minecraft.class_3037;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3666;
import net.minecraft.class_3902;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2881.class})
public abstract class EndDragonFightMixin
implements IDragonFight {
    @Shadow
    @Final
    private class_3213 field_13119;
    @Shadow
    private boolean field_13115;
    @Shadow
    private int field_13122;
    @Shadow
    @Final
    private class_3218 field_13108;
    @Shadow
    private boolean field_13111;
    @Shadow
    @Nullable
    private List<class_1511> field_13109;
    @Shadow
    private int field_13118;
    @Shadow
    @Nullable
    private class_2338 field_13117;
    @Shadow
    @Nullable
    private UUID field_13116;
    @Shadow
    private int field_13107;
    @Shadow
    private int field_13105;
    @Shadow
    private boolean field_13114;
    @Shadow
    private int field_13106;
    @Shadow
    @Nullable
    private class_2876 field_13120;
    @Shadow
    @Final
    private ObjectArrayList<Integer> field_13121;
    @Unique
    private DragonRespawnStage betterendisland$dragonRespawnStage;
    @Unique
    private boolean betterendisland$firstExitPortalSpawn = true;
    @Unique
    private boolean betterendisland$hasDragonEverSpawned;
    @Unique
    private int betterendisland$numberTimesDragonKilled = 0;

    @Shadow
    public abstract void method_12524();

    @Shadow
    public abstract void method_12522();

    @Shadow
    protected abstract void method_12520();

    @Shadow
    protected abstract boolean method_12533();

    @Shadow
    protected abstract void method_12525();

    @Shadow
    protected abstract void method_12535();

    @Shadow
    protected abstract class_1510 method_12523();

    @Shadow
    @Nullable
    protected abstract class_2700.class_2702 method_12531();

    @Shadow
    protected abstract void method_12529(List<class_1511> var1);

    @Shadow
    protected abstract boolean method_12514();

    @Shadow
    protected abstract void method_12519();

    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;JLnet/minecraft/world/level/dimension/end/EndDragonFight$Data;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="RETURN")})
    public void betterendisland_EndDragonFight(class_3218 level, long seed, class_2881.class_8576 data, class_2338 origin, CallbackInfo ci) {
        if (data.comp_1543()) {
            this.betterendisland$dragonRespawnStage = DragonRespawnStage.START;
        }
        this.field_13119.method_14091(false);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_tickFight(CallbackInfo ci) {
        this.field_13119.method_14091(!this.field_13115 && this.betterendisland$hasDragonEverSpawned);
        if (++this.field_13122 >= 20) {
            this.method_12520();
            this.field_13122 = 0;
        }
        if (!this.field_13119.method_14092().isEmpty()) {
            this.field_13108.method_14178().method_17297(class_3230.field_17264, new class_1923(0, 0), 9, (Object)class_3902.field_17274);
            boolean isArenaLoaded = this.method_12533();
            if (this.field_13111 && isArenaLoaded) {
                this.betterendisland$scanForInitialState();
                this.field_13111 = false;
            }
            if (this.betterendisland$dragonRespawnStage != null) {
                if (this.field_13109 == null && isArenaLoaded) {
                    this.betterendisland$dragonRespawnStage = null;
                    this.method_12522();
                }
                this.betterendisland$dragonRespawnStage.tick(this.field_13108, (class_2881)this, this.field_13109, this.field_13118++, this.field_13117);
            }
            if (!this.field_13115) {
                if ((this.field_13116 == null || ++this.field_13107 >= 1200) && isArenaLoaded && this.betterendisland$hasDragonEverSpawned) {
                    this.method_12525();
                    this.field_13107 = 0;
                }
                if (++this.field_13105 >= 100 && isArenaLoaded) {
                    this.method_12535();
                    this.field_13105 = 0;
                }
            }
        } else {
            this.field_13108.method_14178().method_17300(class_3230.field_17264, new class_1923(0, 0), 9, (Object)class_3902.field_17274);
        }
        ci.cancel();
    }

    @Override
    public void betterendisland$reset(boolean forcePortalPosReset) {
        List dragons = this.field_13108.method_18776();
        dragons.forEach(class_1297::method_31472);
        this.field_13119.method_5408(0.0f);
        this.field_13119.method_14091(false);
        if (this.field_13117 == null || this.field_13117.method_10264() < 5 || forcePortalPosReset) {
            BetterEndIslandCommon.LOGGER.info("Tried to reset, but need to find the portal first.");
            if (this.field_13117 == null) {
                BetterEndIslandCommon.LOGGER.info("Portal location is currently null.");
            } else if (this.field_13117.method_10264() < 5) {
                BetterEndIslandCommon.LOGGER.info("Portal location is currently too low: {}", (Object)this.field_13117.method_10264());
            } else {
                BetterEndIslandCommon.LOGGER.info("Forcing portal position reset...");
            }
            this.method_12531();
            if (this.field_13117 == null || this.field_13117.method_10264() < 5 || forcePortalPosReset) {
                if (this.field_13117 == null) {
                    BetterEndIslandCommon.LOGGER.info("Portal location is still null. Placing manually...");
                } else if (this.field_13117.method_10264() < 5) {
                    BetterEndIslandCommon.LOGGER.info("Portal location is still too low: {}. Placing manually...", (Object)this.field_13117.method_10264());
                }
                this.field_13117 = new class_2338(0, this.betterendisland$getSurfacePos(0, 0), 0);
                while (this.field_13108.method_8320(this.field_13117).method_27852(class_2246.field_9987) && this.field_13117.method_10264() > this.field_13108.method_8615()) {
                    this.field_13117 = this.field_13117.method_10074();
                }
                if (this.field_13117.method_10264() < 5) {
                    BetterEndIslandCommon.LOGGER.info("Portal was still placed too low! Force placing at y=65...");
                    this.field_13117 = new class_2338(this.field_13117.method_10263(), 65, this.field_13117.method_10260());
                }
            }
        }
        class_2338 portalPos = this.field_13117;
        this.field_13116 = null;
        this.field_13115 = false;
        this.field_13114 = false;
        this.betterendisland$firstExitPortalSpawn = false;
        this.betterendisland$hasDragonEverSpawned = false;
        this.betterendisland$numberTimesDragonKilled = 0;
        this.betterendisland$dragonRespawnStage = null;
        this.field_13120 = null;
        this.field_13118 = 0;
        this.field_13111 = true;
        this.field_13122 = 0;
        this.field_13107 = 0;
        this.field_13106 = 0;
        this.field_13105 = 0;
        if (this.field_13109 != null) {
            this.field_13109.forEach(class_1297::method_31472);
        }
        this.field_13109 = null;
        List<class_1511> remainingSummoningCrystals = this.betterendisland$checkRespawnCrystals(portalPos.method_10086(1));
        remainingSummoningCrystals.forEach(class_1297::method_31472);
        remainingSummoningCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.method_10087(2));
        remainingSummoningCrystals.forEach(class_1297::method_31472);
        List allSpikes = class_3310.method_14506((class_5281)this.field_13108);
        for (class_3310.class_3181 spike2 : allSpikes) {
            for (class_1511 crystal : this.field_13108.method_18467(class_1511.class, spike2.method_13968())) {
                crystal.method_31472();
            }
        }
        BetterEndPodiumFeature endPodiumFeature = new BetterEndPodiumFeature(true, false, false);
        class_2338 spawnPos = portalPos.method_10087(5);
        endPodiumFeature.method_40163((class_3037)class_3037.field_13603, (class_5281)this.field_13108, this.field_13108.method_14178().method_12129(), class_5819.method_43047(), spawnPos);
        this.betterendisland$clearVanillaPillars();
        allSpikes.forEach(spike -> {
            int resetRadius = 11;
            int verticalRadius = BetterEndIslandCommon.betterEnd ? 40 : 30;
            for (class_2338 blockPos : class_2338.method_10097((class_2338)new class_2338(spike.method_13966() - resetRadius, spike.method_13964() - verticalRadius, spike.method_13967() - resetRadius), (class_2338)new class_2338(spike.method_13966() + resetRadius, spike.method_13964() + verticalRadius, spike.method_13967() + resetRadius))) {
                if (this.field_13108.method_8320(blockPos).method_27852(class_2246.field_10471)) continue;
                this.field_13108.method_8650(blockPos, false);
            }
            class_3666 spikeConfig = new class_3666(true, (List)ImmutableList.of((Object)spike), null);
            BetterSpikeFeature.placeSpike((class_5425)this.field_13108, class_5819.method_43047(), spikeConfig, spike, true);
        });
        class_2338 platformPos = class_3218.field_25144.method_10074();
        BetterEndSpawnPlatformFeature.place(this.field_13108, platformPos);
        for (int i = 0; i < 20; ++i) {
            int x = class_3532.method_15357((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            int z = class_3532.method_15357((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i))));
            class_2338 gatePos = new class_2338(x, 75, z);
            class_2338.method_10097((class_2338)gatePos.method_10069(-1, -4, -1), (class_2338)gatePos.method_10069(1, 4, 1)).forEach(pos -> this.field_13108.method_8501(pos, class_2246.field_10124.method_9564()));
        }
        this.field_13121.clear();
        this.field_13121.addAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
        class_156.method_43028(this.field_13121, (class_5819)class_5819.method_43049((long)this.field_13108.method_8412()));
    }

    @Override
    public void betterendisland$clearVanillaPillars() {
        int obsidianRemoved = 0;
        class_5819 randomSource = class_5819.method_43049((long)this.field_13108.method_8412());
        long seed = randomSource.method_43055() & 0xFFFFL;
        IntArrayList indexes = class_156.method_43251((IntStream)IntStream.range(0, 10), (class_5819)class_5819.method_43049((long)seed));
        for (int i = 0; i < 10; ++i) {
            int x = class_3532.method_15357((double)(42.0 * Math.cos(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int z = class_3532.method_15357((double)(42.0 * Math.sin(2.0 * (-Math.PI + 0.3141592653589793 * (double)i))));
            int index = indexes.get(i);
            int radius = 2 + index / 3;
            int height = 76 + index * 3;
            boolean isGuarded = index == 1 || index == 2;
            class_238 topBoundingBox = new class_238((double)(x - radius), (double)class_2874.field_28136, (double)(z - radius), (double)(x + radius), (double)class_2874.field_28135, (double)(z + radius));
            this.field_13108.method_18467(class_1511.class, topBoundingBox).forEach(class_1297::method_31472);
            for (class_2338 pos : class_2338.method_10097((class_2338)new class_2338(x - radius, this.field_13108.method_31607(), z - radius), (class_2338)new class_2338(x + radius, height + 20, z + radius))) {
                class_2680 blockState;
                if (!(pos.method_40081((double)x, (double)pos.method_10264(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = this.field_13108.method_8320(pos)).method_27852(class_2246.field_10540) && !blockState.method_27852(class_2246.field_9987)) continue;
                this.field_13108.method_8501(pos, class_2246.field_10124.method_9564());
                if (!blockState.method_27852(class_2246.field_10540)) continue;
                ++obsidianRemoved;
            }
            if (obsidianRemoved > 10) {
                int offset = radius + 1;
                int topY = -1;
                int surfaceY = this.betterendisland$getSurfacePos(x - offset, z - offset);
                if (surfaceY > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x - offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x + offset, z - offset)) > topY) {
                    topY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getSurfacePos(x + offset, z + offset)) > topY) {
                    topY = surfaceY;
                }
                int bottomY = 255;
                surfaceY = this.betterendisland$getLowestBlockPos(x - offset, z - offset);
                if (surfaceY < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x - offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x + offset, z - offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if ((surfaceY = this.betterendisland$getLowestBlockPos(x + offset, z + offset)) < bottomY) {
                    bottomY = surfaceY;
                }
                if (topY != -1 && bottomY != 255) {
                    for (class_2338 pos : class_2338.method_10097((class_2338)new class_2338(x - radius, bottomY, z - radius), (class_2338)new class_2338(x + radius, topY, z + radius))) {
                        class_2680 blockState;
                        if (!(pos.method_40081((double)x, (double)pos.method_10264(), (double)z) <= (double)(radius * radius + 1)) || !(blockState = this.field_13108.method_8320(pos)).method_27852(class_2246.field_10124) || pos.method_10264() > topY || pos.method_10264() < bottomY) continue;
                        this.field_13108.method_8501(pos, class_2246.field_10471.method_9564());
                    }
                }
            }
            if (!isGuarded) continue;
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int fenceX = -2; fenceX <= 2; ++fenceX) {
                for (int fenceZ = -2; fenceZ <= 2; ++fenceZ) {
                    for (int fenceY = 0; fenceY <= 3; ++fenceY) {
                        if (class_3532.method_15382((int)fenceX) != 2 && class_3532.method_15382((int)fenceZ) != 2 && fenceY != 3) continue;
                        mutable.method_10103(x + fenceX, height + fenceY, z + fenceZ);
                        this.field_13108.method_8501((class_2338)mutable, class_2246.field_10124.method_9564());
                    }
                }
            }
        }
    }

    @Unique
    private int betterendisland$getLowestBlockPos(int x, int z) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int y = this.field_13108.method_31607(); y < this.field_13108.method_31600(); ++y) {
            mutable.method_10103(x, y, z);
            if (!this.field_13108.method_8320((class_2338)mutable).method_27852(class_2246.field_10471)) continue;
            return y;
        }
        return 255;
    }

    @Unique
    private int betterendisland$getSurfacePos(int x, int z) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int y = this.field_13108.method_31600(); y > this.field_13108.method_31607(); --y) {
            mutable.method_10103(x, y, z);
            if (!this.field_13108.method_8320((class_2338)mutable).method_27852(class_2246.field_10471)) continue;
            return y;
        }
        return -1;
    }

    @Unique
    private void betterendisland$scanForInitialState() {
        BetterEndIslandCommon.LOGGER.info("Scanning for legacy world dragon fight...");
        boolean hasActiveExitPortal = this.method_12514();
        if (hasActiveExitPortal) {
            BetterEndIslandCommon.LOGGER.info("Found that the dragon has been killed in this world already.");
            this.field_13114 = true;
        } else {
            BetterEndIslandCommon.LOGGER.info("Found that the dragon has not yet been killed in this world.");
            this.field_13114 = false;
            if (this.method_12531() == null) {
                this.betterendisland$spawnPortal(false, false);
            }
        }
        List dragons = this.field_13108.method_18776();
        if (dragons.isEmpty()) {
            this.field_13115 = true;
        } else {
            class_1510 dragon = (class_1510)dragons.get(0);
            this.field_13116 = dragon.method_5667();
            BetterEndIslandCommon.LOGGER.info("Found that there's a dragon still alive ({})", (Object)dragon);
            this.field_13115 = false;
            if (!hasActiveExitPortal) {
                BetterEndIslandCommon.LOGGER.info("But we didn't have a portal, so let's remove the dragon.");
                dragon.method_31472();
                this.field_13116 = null;
            }
        }
        if (!this.field_13114 && this.field_13115) {
            this.field_13115 = false;
        }
    }

    @Inject(method={"onCrystalDestroyed"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_onCrystalDestroyed(class_1511 crystal, class_1282 damageSource, CallbackInfo ci) {
        if (this.betterendisland$dragonRespawnStage != null && this.field_13109.contains(crystal)) {
            BetterEndIslandCommon.LOGGER.info("Aborting dragon respawn sequence");
            this.betterendisland$dragonRespawnStage = null;
            this.field_13118 = 0;
            this.method_12524();
        } else {
            this.method_12535();
            class_1297 dragonEntity = this.field_13108.method_14190(this.field_13116);
            if (dragonEntity instanceof class_1510) {
                ((class_1510)dragonEntity).method_6828(crystal, crystal.method_24515(), damageSource);
            }
        }
        ci.cancel();
    }

    @Inject(method={"tryRespawn"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_tryRespawn(CallbackInfo ci) {
        if (this.field_13115 && this.betterendisland$dragonRespawnStage == null) {
            List<class_1511> allCrystals;
            class_2338 portalPos = this.field_13117;
            if (portalPos == null) {
                BetterEndIslandCommon.LOGGER.info("Tried to respawn, but need to find the portal first.");
                class_2700.class_2702 portalPatternMatch = this.method_12531();
                if (portalPatternMatch == null) {
                    BetterEndIslandCommon.LOGGER.info("Couldn't find a portal, so we made one.");
                    this.betterendisland$spawnPortal(false, false);
                    this.betterendisland$spawnPortal(true, true);
                } else {
                    BetterEndIslandCommon.LOGGER.info("Found the exit portal & saved its location for next time.");
                }
                portalPos = this.field_13117;
            }
            if ((allCrystals = this.betterendisland$checkRespawnCrystals(portalPos.method_10086(1))).size() != 4 && (allCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.method_10087(2))).size() != 4) {
                return;
            }
            BetterEndIslandCommon.LOGGER.info("Found all crystals, respawning dragon.");
            this.method_12529(allCrystals);
        }
        ci.cancel();
    }

    @Override
    @Unique
    public void betterendisland$initialRespawn() {
        List<class_1511> allCrystals;
        BetterEndIslandCommon.LOGGER.info("Starting initial dragon fight!");
        class_2338 portalPos = this.field_13117;
        if (portalPos == null) {
            BetterEndIslandCommon.LOGGER.info("Tried to respawn, but need to find the portal first.");
            class_2700.class_2702 portalPatternMatch = this.method_12531();
            if (portalPatternMatch == null) {
                BetterEndIslandCommon.LOGGER.info("Couldn't find a portal, so we made one.");
                this.betterendisland$spawnPortal(false, false);
                this.betterendisland$spawnPortal(true, true);
            } else {
                BetterEndIslandCommon.LOGGER.info("Found the exit portal & saved its location for next time.");
            }
            portalPos = this.field_13117;
        }
        if ((allCrystals = this.betterendisland$checkRespawnCrystals(portalPos.method_10086(1))).size() != 4 && (allCrystals = this.betterendisland$checkVanillaRespawnCrystals(portalPos.method_10087(2))).size() != 4) {
            BetterEndIslandCommon.LOGGER.info("Unable to find all 4 summoning crystals. This shouldn't happen!");
            return;
        }
        BetterEndIslandCommon.LOGGER.info("Found all crystals, starting initial dragon spawn.");
        this.method_12529(allCrystals);
    }

    @Unique
    private List<class_1511> betterendisland$checkRespawnCrystals(class_2338 centerPos) {
        ArrayList foundCrystals = Lists.newArrayList();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_238 crystalCheckbox = new class_238(centerPos.method_10079(direction, 7));
            List crystalsInDirection = this.field_13108.method_18467(class_1511.class, crystalCheckbox);
            foundCrystals.addAll(crystalsInDirection);
        }
        return foundCrystals;
    }

    @Unique
    private List<class_1511> betterendisland$checkVanillaRespawnCrystals(class_2338 centerPos) {
        ArrayList foundCrystals = Lists.newArrayList();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_238 crystalCheckbox = new class_238(centerPos.method_10079(direction, 2));
            List crystalsInDirection = this.field_13108.method_18467(class_1511.class, crystalCheckbox);
            foundCrystals.addAll(crystalsInDirection);
        }
        return foundCrystals;
    }

    @Inject(method={"respawnDragon"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterendisland_respawnDragon(List<class_1511> crystals, CallbackInfo ci) {
        if ((this.field_13115 || !this.betterendisland$hasDragonEverSpawned) && this.betterendisland$dragonRespawnStage == null) {
            this.betterendisland$dragonRespawnStage = DragonRespawnStage.START;
            this.field_13118 = 0;
            this.field_13109 = crystals;
        }
        ci.cancel();
    }

    @Unique
    private void betterendisland$spawnPortal(boolean isActive, boolean isBottomOnly) {
        if (this.field_13117 == null || this.field_13117.method_10264() < 5) {
            if (this.field_13117 == null) {
                BetterEndIslandCommon.LOGGER.info("Portal location is null. Placing manually...");
            } else {
                BetterEndIslandCommon.LOGGER.info("Portal location is too low: {}. Placing manually...", (Object)this.field_13117.method_10264());
            }
            this.field_13117 = new class_2338(0, this.betterendisland$getSurfacePos(0, 0), 0);
            while (this.field_13108.method_8320(this.field_13117).method_27852(class_2246.field_9987) && this.field_13117.method_10264() > this.field_13108.method_8615()) {
                this.field_13117 = this.field_13117.method_10074();
            }
            if (this.field_13117.method_10264() < 5) {
                BetterEndIslandCommon.LOGGER.info("Portal was placed too low! Force placing at y=65...");
                this.field_13117 = new class_2338(this.field_13117.method_10263(), 65, this.field_13117.method_10260());
            }
        }
        BetterEndIslandCommon.LOGGER.info("Set the exit portal location to: {}", (Object)this.field_13117);
        BetterEndPodiumFeature endPodiumFeature = new BetterEndPodiumFeature(this.betterendisland$firstExitPortalSpawn, isBottomOnly, isActive);
        class_2338 spawnPos = this.field_13117.method_10087(5);
        endPodiumFeature.method_40163((class_3037)class_3037.field_13603, (class_5281)this.field_13108, this.field_13108.method_14178().method_12129(), class_5819.method_43047(), spawnPos);
        this.betterendisland$firstExitPortalSpawn = false;
    }

    @Inject(method={"resetSpikeCrystals"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_resetSpikeCrystals(CallbackInfo ci) {
        for (class_3310.class_3181 $$0 : class_3310.method_14506((class_5281)this.field_13108)) {
            for (class_1511 $$2 : this.field_13108.method_18467(class_1511.class, $$0.method_13968())) {
                $$2.method_5684(false);
                $$2.method_6837(null);
            }
        }
        if (this.field_13109 != null) {
            for (class_1511 crystal : this.field_13109) {
                crystal.method_5684(false);
                crystal.method_6837(null);
            }
        }
        ci.cancel();
    }

    @Inject(method={"setDragonKilled"}, at={@At(value="HEAD")}, cancellable=true)
    public void betterendisland_setDragonKilled(class_1510 dragon, CallbackInfo ci) {
        if (dragon.method_5667().equals(this.field_13116)) {
            this.field_13119.method_5408(0.0f);
            this.field_13119.method_14091(false);
            this.betterendisland$spawnPortal(true, true);
            this.field_13108.method_8437(null, (double)this.field_13117.method_10263(), (double)this.field_13117.method_10264(), (double)this.field_13117.method_10260(), 6.0f, class_1937.class_7867.field_40888);
            this.method_12519();
            if (!this.field_13114) {
                this.field_13108.method_8501(this.field_13117.method_10084(), class_2246.field_10081.method_9564());
            }
            int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
            List spikes = class_3310.method_14506((class_5281)this.field_13108);
            spikes.forEach(spike -> {
                int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset();
                this.field_13108.method_8652(new class_2338(spike.method_13966(), crystalY - 1, spike.method_13967()), class_2246.field_10540.method_9564(), 3);
            });
            this.field_13114 = true;
            this.field_13115 = true;
            ++this.betterendisland$numberTimesDragonKilled;
        }
        ci.cancel();
    }

    @Override
    public void betterendisland$setDragonRespawnStage(DragonRespawnStage stage) {
        if (this.betterendisland$dragonRespawnStage == null) {
            throw new IllegalStateException("Better Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.field_13118 = 0;
        if (stage == DragonRespawnStage.END) {
            this.betterendisland$dragonRespawnStage = null;
            this.field_13115 = false;
            class_1510 newDragon = this.method_12523();
            if (this.field_13114) {
                for (class_3222 serverPlayer : this.field_13119.method_14092()) {
                    class_174.field_1182.method_9124(serverPlayer, (class_1297)newDragon);
                }
            }
            this.betterendisland$spawnPortal(false, false);
            this.field_13108.method_8437(null, (double)this.field_13117.method_10263(), (double)(this.field_13117.method_10264() + 20), (double)this.field_13117.method_10260(), 6.0f, class_1937.class_7867.field_40888);
            this.field_13108.method_18456().forEach(player -> {
                this.field_13108.method_14166(player, (class_2394)class_2398.field_11221, true, (double)this.field_13117.method_10263(), (double)(this.field_13117.method_10264() + 20), (double)this.field_13117.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
                if (player.method_5649((double)this.field_13117.method_10263(), (double)(this.field_13117.method_10264() + 20), (double)this.field_13117.method_10260()) > 32.0) {
                    this.field_13108.method_8396(null, this.field_13117.method_10086(20), class_3417.field_15152, class_3419.field_15254, 24.0f, 1.0f);
                }
            });
            if (this.betterendisland$hasDragonEverSpawned) {
                this.betterendisland$spawnPortal(false, true);
                this.field_13108.method_8437(null, (double)this.field_13117.method_10263(), (double)this.field_13117.method_10264(), (double)this.field_13117.method_10260(), 6.0f, class_1937.class_7867.field_40888);
            }
            int dragonKills = class_3532.method_15340((int)this.betterendisland$numberTimesDragonKilled, (int)0, (int)10);
            float cryingChance = class_3532.method_16439((float)((float)dragonKills / 10.0f), (float)0.0f, (float)0.5f);
            ArrayList existingGateways = new ArrayList(ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            existingGateways.removeAll((Collection<?>)this.field_13121);
            existingGateways.forEach(gateway -> {
                int x = class_3532.method_15357((double)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)gateway.intValue()))));
                int z = class_3532.method_15357((double)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)gateway.intValue()))));
                class_2338 gatewayPos = new class_2338(x, 75, z);
                class_5819 gatewayRandom = class_5819.method_43049((long)class_3532.method_15389((class_2382)gatewayPos));
                class_2338.method_10097((class_2338)gatewayPos.method_10069(-1, -4, -1), (class_2338)gatewayPos.method_10069(1, 4, 1)).forEach(pos -> {
                    if (this.field_13108.method_8320(pos).method_27852(class_2246.field_10540) && gatewayRandom.method_43057() < cryingChance) {
                        this.field_13108.method_8501(pos, class_2246.field_22423.method_9564());
                    }
                });
            });
            class_2338 platformPos = class_3218.field_25144;
            class_5819 platformRandom = class_5819.method_43049((long)class_3532.method_15389((class_2382)platformPos));
            class_2338.method_10097((class_2338)platformPos.method_10069(-3, -15, -3), (class_2338)platformPos.method_10069(3, 4, 3)).forEach(pos -> {
                if (this.field_13108.method_8320(pos).method_27852(class_2246.field_10540) && platformRandom.method_43057() < cryingChance) {
                    this.field_13108.method_8501(pos, class_2246.field_22423.method_9564());
                }
            });
            this.betterendisland$hasDragonEverSpawned = true;
        } else {
            this.betterendisland$dragonRespawnStage = stage;
        }
    }

    @Override
    public void betterendisland$tickBellSound() {
        if (!this.betterendisland$hasDragonEverSpawned || this.betterendisland$dragonRespawnStage != null) {
            int soundY;
            long gameTime = this.field_13108.method_8510();
            int n = soundY = this.field_13117 == null ? 80 : this.field_13117.method_10264() + 15;
            if (gameTime % 100L == 0L) {
                this.field_13108.method_8396(null, new class_2338(0, soundY, 0), class_3417.field_17265, class_3419.field_15254, 24.0f, 0.5f);
                this.field_13108.method_8396(null, new class_2338(0, soundY, 0), class_3417.field_19167, class_3419.field_15254, 4.0f, 0.9f);
            }
            if (gameTime % 300L == 0L) {
                this.field_13108.method_8396(null, new class_2338(0, 80, 0), class_3417.field_19167, class_3419.field_15254, 24.0f, 0.8f);
            }
        }
    }

    @Override
    public DragonRespawnStage betterendisland$getDragonRespawnStage() {
        return this.betterendisland$dragonRespawnStage;
    }

    @Override
    public boolean betterendisland$firstExitPortalSpawn() {
        return this.betterendisland$firstExitPortalSpawn;
    }

    @Override
    public boolean betterendisland$hasDragonEverSpawned() {
        return this.betterendisland$hasDragonEverSpawned;
    }

    @Override
    public int betterendisland$numTimesDragonKilled() {
        return this.betterendisland$numberTimesDragonKilled;
    }

    @Override
    public void betterendisland$setFirstExitPortalSpawn(boolean bl) {
        this.betterendisland$firstExitPortalSpawn = bl;
    }

    @Override
    public void betterendisland$setHasDragonEverSpawned(boolean bl) {
        this.betterendisland$hasDragonEverSpawned = bl;
    }

    @Override
    public void betterendisland$setNumTimesDragonKilled(int i) {
        this.betterendisland$numberTimesDragonKilled = i;
    }
}

