/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.client.registry;

import java.io.Closeable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.random.RandomGenerator;
import java.util.stream.Stream;
import mod.chloeprime.aaaparticles.api.client.effekseer.EffekseerEffect;
import mod.chloeprime.aaaparticles.api.client.effekseer.EffekseerManager;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import net.minecraft.class_2960;
import org.joml.Vector3f;

public class EffectDefinition
implements Closeable {
    private EffekseerEffect effect;
    private final EnumMap<ParticleEmitter.Type, EffekseerManager> managers = new EnumMap(ParticleEmitter.Type.class);
    private final EnumMap<ParticleEmitter.Type, Set<ParticleEmitter>> oneShotEmitters = new EnumMap(ParticleEmitter.Type.class);
    private final EnumMap<ParticleEmitter.Type, Map<class_2960, ParticleEmitter>> namedEmitters = new EnumMap(ParticleEmitter.Type.class);
    private static final RandomGenerator RNG = new Random();
    private static final int GC_DELAY = 20;
    private final int magicLoadBalancer = Math.abs(RNG.nextInt() >>> 2) % 20;
    private int gcTicks;

    public EffectDefinition() {
        for (ParticleEmitter.Type type : ParticleEmitter.Type.values()) {
            this.oneShotEmitters.put(type, new LinkedHashSet());
            this.namedEmitters.put(type, new LinkedHashMap());
        }
    }

    public ParticleEmitter play() {
        return this.play(ParticleEmitter.Type.WORLD);
    }

    public ParticleEmitter play(class_2960 emitterName) {
        return this.play(ParticleEmitter.Type.WORLD, emitterName);
    }

    public ParticleEmitter play(ParticleEmitter.Type type) {
        ParticleEmitter emitter = this.getManager(type).createParticle(this.getEffect(), type);
        Set<ParticleEmitter> collection = Objects.requireNonNull(this.oneShotEmitters.get((Object)type));
        collection.add(emitter);
        return emitter;
    }

    public ParticleEmitter play(ParticleEmitter.Type type, class_2960 emitterName) {
        ParticleEmitter emitter = this.getManager(type).createParticle(this.getEffect(), type);
        Map<class_2960, ParticleEmitter> collection = Objects.requireNonNull(this.namedEmitters.get((Object)type));
        ParticleEmitter old = collection.put(emitterName, emitter);
        if (old != null) {
            old.stop();
        }
        return emitter;
    }

    public Optional<ParticleEmitter> getNamedEmitter(ParticleEmitter.Type type, class_2960 emitterName) {
        return Optional.ofNullable(this.namedEmitters.get((Object)type).get(emitterName));
    }

    public EffekseerManager getManager(ParticleEmitter.Type type) {
        return Objects.requireNonNull(this.managers.get((Object)type));
    }

    public Stream<ParticleEmitter> emitters() {
        return this.emitterContainers().flatMap(Collection::stream);
    }

    public Stream<ParticleEmitter> emitters(ParticleEmitter.Type type) {
        return this.emitterContainers(type).flatMap(Collection::stream);
    }

    public Stream<Collection<ParticleEmitter>> emitterContainers() {
        return Stream.concat(this.oneShotEmitters.values().stream(), this.namedEmitters.values().stream().map(Map::values));
    }

    public Stream<Collection<ParticleEmitter>> emitterContainers(ParticleEmitter.Type type) {
        Set<ParticleEmitter> oneshot = Objects.requireNonNull(this.oneShotEmitters.get((Object)type));
        Collection<ParticleEmitter> named = Objects.requireNonNull(this.namedEmitters.get((Object)type)).values();
        return Stream.of(oneshot, named);
    }

    public EffekseerEffect getEffect() {
        return this.effect;
    }

    public EffectDefinition setEffect(EffekseerEffect effect) {
        Objects.requireNonNull(effect);
        if (this.effect == effect) {
            return null;
        }
        if (this.effect != null) {
            this.emitters().forEach(ParticleEmitter::stop);
            this.managers().forEach(EffekseerManager::close);
            this.effect.close();
            this.managers.clear();
        }
        this.effect = effect;
        this.initManager();
        return this;
    }

    public Stream<EffekseerManager> managers() {
        return this.managers.values().stream();
    }

    public void draw(ParticleEmitter.Type type, Vector3f front, Vector3f pos, int w, int h, float[] camera, float[] projection, float deltaFrames, float partialTicks) {
        EffekseerManager manager = Objects.requireNonNull(this.managers.get((Object)type));
        manager.setViewport(w, h);
        manager.setCameraMatrix(camera);
        manager.setProjectionMatrix(projection);
        manager.setCameraParameter(front.x, front.y, front.z, pos.x, pos.y, pos.z);
        manager.startUpdate();
        manager.update(deltaFrames);
        manager.endUpdate();
        this.emitters(type).forEach(emitter -> emitter.runPreDrawCallbacks(partialTicks));
        manager.draw();
        if (type == ParticleEmitter.Type.WORLD) {
            this.gcTicks = (this.gcTicks + 1) % 20;
            if (this.gcTicks == this.magicLoadBalancer) {
                this.emitterContainers().forEach(container -> container.removeIf(emitter -> !emitter.exists()));
            }
        }
    }

    private void initManager() {
        for (ParticleEmitter.Type type : ParticleEmitter.Type.values()) {
            EffekseerManager old = this.managers.put(type, new EffekseerManager());
            Optional.ofNullable(old).ifPresent(EffekseerManager::close);
        }
        EffekseerManager worldManager = Objects.requireNonNull(this.managers.get((Object)ParticleEmitter.Type.WORLD));
        EffekseerManager fpvMhManager = Objects.requireNonNull(this.managers.get((Object)ParticleEmitter.Type.FIRST_PERSON_MAINHAND));
        EffekseerManager fpvOhManager = Objects.requireNonNull(this.managers.get((Object)ParticleEmitter.Type.FIRST_PERSON_OFFHAND));
        if (!worldManager.init(9000)) {
            throw new IllegalStateException("Failed to initialize EffekseerManager");
        }
        if (!fpvMhManager.init(500)) {
            throw new IllegalStateException("Failed to initialize (fpv mainhand) EffekseerManager");
        }
        if (!fpvOhManager.init(500)) {
            throw new IllegalStateException("Failed to initialize (fpv offhand) EffekseerManager");
        }
        worldManager.setupWorkerThreads(2);
        fpvMhManager.setupWorkerThreads(1);
        fpvOhManager.setupWorkerThreads(1);
    }

    @Override
    public void close() {
        this.managers.values().forEach(EffekseerManager::close);
        this.effect.close();
    }
}

