/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableMap;
import dev.emi.trinkets.api.SlotType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class SlotGroup {
    private final String name;
    private final int slotId;
    private final int order;
    private final Map<String, SlotType> slots;

    private SlotGroup(Builder builder) {
        this.name = builder.name;
        this.slots = builder.slots;
        this.slotId = builder.slotId;
        this.order = builder.order;
    }

    protected SlotGroup(String name, int slotId, int order, Map<String, SlotType> slots) {
        this.name = name;
        this.slotId = slotId;
        this.order = order;
        this.slots = slots;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, SlotType> getSlots() {
        return ImmutableMap.copyOf(this.slots);
    }

    public void write(class_2487 data) {
        class_2487 tag = new class_2487();
        tag.method_10582("Name", this.name);
        tag.method_10569("SlotId", this.slotId);
        tag.method_10569("Order", this.order);
        class_2487 typesTag = new class_2487();
        this.slots.forEach((id, slot) -> {
            class_2487 typeTag = new class_2487();
            slot.write(typeTag);
            typesTag.method_10566(id, (class_2520)typeTag);
        });
        tag.method_10566("SlotTypes", (class_2520)typesTag);
        data.method_10566("GroupData", (class_2520)tag);
    }

    public static SlotGroup read(class_2487 data) {
        class_2487 groupData = data.method_10562("GroupData");
        String name = groupData.method_10558("Name");
        int slotId = groupData.method_10550("SlotId");
        int order = groupData.method_10550("Order");
        class_2487 typesTag = groupData.method_10562("SlotTypes");
        Builder builder = new Builder(name, slotId, order);
        for (String id : typesTag.method_10541()) {
            class_2487 tag = (class_2487)typesTag.method_10580(id);
            if (tag == null) continue;
            builder.addSlot(id, SlotType.read(tag));
        }
        return builder.build();
    }

    public static class Builder {
        private final String name;
        private final int slotId;
        private final int order;
        public final Map<String, SlotType> slots = new HashMap<String, SlotType>();

        public Builder(String name, int slotId, int order) {
            this.name = name;
            this.slotId = slotId;
            this.order = order;
        }

        public Builder addSlot(String name, SlotType slot) {
            this.slots.put(name, slot);
            return this;
        }

        public SlotGroup build() {
            return new SlotGroup(this);
        }
    }
}

