/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.dimension.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.common.color.Color;
import earth.terrarium.ad_astra.client.dimension.renderer.StarInformation;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import earth.terrarium.ad_astra.common.world.LevelSeed;
import earth.terrarium.ad_astra.mixin.client.LevelRendererAccessor;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SkyUtil {
    public static float getScale() {
        class_310 minecraft = class_310.method_1551();
        float distance = (float)(-3000.0 + minecraft.field_1724.method_23318() * 4.5);
        float scale = 100.0f * (0.2f - distance / 10000.0f);
        return Math.max(scale, 0.5f);
    }

    public static void preRender(class_638 level, class_761 levelRenderer, class_4184 camera, Matrix4f projectionMatrix, class_287 bufferBuilder, PlanetSkyRenderer.SunsetColour colourType, int sunsetAngle, class_4587 poseStack, float tickDelta) {
        class_243 vec3d = level.method_23777(camera.method_19326(), tickDelta);
        float f = (float)vec3d.method_10216();
        float g = (float)vec3d.method_10214();
        float h = (float)vec3d.method_10215();
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        class_291 skyBuffer = ((LevelRendererAccessor)levelRenderer).getSkyBuffer();
        skyBuffer.method_1353();
        skyBuffer.method_34427(poseStack.method_23760().method_23761(), projectionMatrix, RenderSystem.getShader());
        class_291.method_1354();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        SkyUtil.renderColouring(colourType, bufferBuilder, poseStack, level, tickDelta, level.method_30274(tickDelta), sunsetAngle);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void postRender(class_757 renderer, class_638 level, float tickDelta) {
        class_243 vec3d = level.method_23777(renderer.method_19418().method_19326(), tickDelta);
        float f = (float)vec3d.method_10216();
        float g = (float)vec3d.method_10214();
        float h = (float)vec3d.method_10215();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (level.method_28103().method_28113()) {
            RenderSystem.setShaderColor((float)(f * 0.2f + 0.04f), (float)(g * 0.2f + 0.04f), (float)(h * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static boolean isSubmerged(class_4184 camera) {
        class_5636 cameraSubmersionType = camera.method_19334();
        if (cameraSubmersionType.equals((Object)class_5636.field_27887) || cameraSubmersionType.equals((Object)class_5636.field_27885)) {
            return true;
        }
        class_1297 class_12972 = camera.method_19331();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return livingEntity.method_6059(class_1294.field_5919) || livingEntity.method_6059(class_1294.field_38092);
        }
        return false;
    }

    public static void startRendering(class_4587 poseStack, Vector3f rotation) {
        poseStack.method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation.y()));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(rotation.z()));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(rotation.x()));
    }

    private static void endRendering(class_4587 poseStack) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    public static void render(class_4587 poseStack, class_287 bufferBuilder, class_2960 texture, Color colour, Vector3f rotation, float scale, boolean blending) {
        SkyUtil.startRendering(poseStack, rotation);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderColor((float)((float)colour.getIntRed() / 255.0f), (float)((float)colour.getIntGreen() / 255.0f), (float)((float)colour.getIntBlue() / 255.0f), (float)1.0f);
        if (blending) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        Matrix4f positionMatrix = poseStack.method_23760().method_23761();
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(positionMatrix, -scale, 100.0f, -scale).method_22913(1.0f, 0.0f).method_1336(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), 255).method_1344();
        bufferBuilder.method_22918(positionMatrix, scale, 100.0f, -scale).method_22913(0.0f, 0.0f).method_1336(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), 255).method_1344();
        bufferBuilder.method_22918(positionMatrix, scale, 100.0f, scale).method_22913(0.0f, 1.0f).method_1336(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), 255).method_1344();
        bufferBuilder.method_22918(positionMatrix, -scale, 100.0f, scale).method_22913(1.0f, 1.0f).method_1336(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), 255).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        SkyUtil.endRendering(poseStack);
    }

    public static class_287.class_7433 renderStars(class_287 buffer, int stars, boolean colouredStars) {
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        StarInformation info = (StarInformation)StarInformation.STAR_CACHE.apply((Object)LevelSeed.getSeed(), (Object)stars);
        for (int i = 0; i < stars; ++i) {
            Vector3f vec3f = info.getParam1(i);
            float d = vec3f.x();
            float e = vec3f.y();
            float f = vec3f.z();
            float g = info.getMultiplier(i);
            float h = d * d + e * e + f * f;
            if (h >= 1.0f || h <= 0.01f) continue;
            h = 1.0f / class_3532.method_15355((float)h);
            float j = (d *= h) * 100.0f;
            float k = (e *= h) * 100.0f;
            float l = (f *= h) * 100.0f;
            float m = (float)Math.atan2(d, f);
            float n = class_3532.method_15374((float)m);
            float o = class_3532.method_15362((float)m);
            float p = (float)Math.atan2(class_3532.method_15355((float)(d * d + f * f)), e);
            float q = class_3532.method_15374((float)p);
            float r = class_3532.method_15362((float)p);
            float s = info.getRandomPi(i);
            float t = class_3532.method_15374((float)s);
            float u = class_3532.method_15362((float)s);
            for (int v = 0; v < 4; ++v) {
                float x = (float)((v & 2) - 1) * g;
                float y = (float)((v + 1 & 2) - 1) * g;
                float aa = x * u - y * t;
                float ac = y * u + x * t;
                float ae = aa * -r;
                Color colour = info.getColour(i, v, colouredStars);
                buffer.method_22912((double)(j + ae * n - ac * o), (double)(k + aa * q), (double)(l + ac * n + ae * o)).method_1336(colour.getIntRed(), colour.getIntGreen(), colour.getIntBlue(), colour.getIntAlpha()).method_1344();
            }
        }
        return buffer.method_1326();
    }

    public static float[] getMarsColour(float skyAngle) {
        float[] colours = new float[4];
        float cosine = class_3532.method_15362((float)(skyAngle * ((float)Math.PI * 2))) - 0.0f;
        if (cosine >= -0.4f && cosine <= 0.4f) {
            float c = (cosine + 0.0f) / 0.4f * 0.5f + 0.5f;
            float sine = 1.0f - (1.0f - class_3532.method_15374((float)(c * (float)Math.PI))) * 0.99f;
            sine *= sine;
            colours[0] = c * 0.3f;
            colours[1] = c * c * 0.6f + 0.55f;
            colours[2] = c * c * 0.0f + 0.8f;
            colours[3] = sine;
            return colours;
        }
        return null;
    }

    public static void renderColouring(PlanetSkyRenderer.SunsetColour type, class_287 bufferBuilder, class_4587 poseStack, class_638 level, float tickDelta, float timeOfDay, int sunsetAngle) {
        float[] fogColours;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VANILLA: {
                float[] fArray = level.method_28103().method_28109(timeOfDay, tickDelta);
                break;
            }
            case MARS: {
                float[] fArray = fogColours = SkyUtil.getMarsColour(timeOfDay);
            }
        }
        if (fogColours != null) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            float sine = class_3532.method_15374((float)level.method_8442(tickDelta)) < 0.0f ? 180.0f : 0.0f;
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(sine));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(fogColours[0], fogColours[1], fogColours[2], fogColours[3]).method_1344();
            for (int i = 0; i <= 16; ++i) {
                float o = (float)i * ((float)Math.PI * 2) / 16.0f;
                float cosine = class_3532.method_15362((float)o);
                bufferBuilder.method_22918(matrix4f, class_3532.method_15374((float)o) * 120.0f, cosine * 120.0f, -cosine * 40.0f * fogColours[3]).method_22915(fogColours[0], fogColours[1], fogColours[2], 0.0f).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            poseStack.method_22909();
        }
    }
}

