/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.compat.rei;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public abstract class BaseClickArea<T extends class_437>
implements ClickArea<T> {
    public ClickArea.Result handle(ClickArea.ClickAreaContext<T> context) {
        if (this.test(context)) {
            return this.getSuccess(context.getScreen());
        }
        return this.getFail();
    }

    public abstract Rectangle getBounds(T var1);

    public abstract ClickArea.Result getSuccess(T var1);

    public ClickArea.Result getFail() {
        return ClickArea.Result.fail();
    }

    public boolean test(ClickArea.ClickAreaContext<T> context) {
        class_437 screen = context.getScreen();
        Point mouse = context.getMousePosition();
        return this.getBounds(screen).contains(mouse.getX(), mouse.getY());
    }

    public static ClickArea.Result category(CategoryIdentifier<?> category) {
        return ClickArea.Result.success().category(category);
    }

    public static ClickArea.Result category(List<CategoryIdentifier<?>> categories) {
        return ClickArea.Result.success().categories(categories);
    }

    public static ClickArea.Result categoryWithTooltip(CategoryIdentifier<?> category, class_2561 tooltip) {
        return BaseClickArea.categoryWithTooltip(category, Collections.singletonList(tooltip));
    }

    public static ClickArea.Result categoryWithTooltip(CategoryIdentifier<?> category, List<class_2561> tooltip) {
        return BaseClickArea.categoryWithTooltip(Collections.singletonList(category), tooltip);
    }

    public static ClickArea.Result categoryWithTooltip(List<CategoryIdentifier<?>> categories, class_2561 tooltip) {
        return BaseClickArea.categoryWithTooltip(categories, Collections.singletonList(tooltip));
    }

    public static ClickArea.Result categoryWithTooltip(List<CategoryIdentifier<?>> categories, List<class_2561> tooltip) {
        ClickArea.Result result = ClickArea.Result.success().categories(categories);
        ArrayList<class_2561> newTooltipBuilder = new ArrayList<class_2561>();
        newTooltipBuilder.addAll(tooltip);
        newTooltipBuilder.addAll(Arrays.stream(result.getTooltips()).toList());
        class_2561[] newTooltip = newTooltipBuilder.toArray(new class_2561[0]);
        return result.tooltip(() -> newTooltip);
    }
}

