/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.system;

import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.entity.system.EntityOxygenStatus;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModDamageSources;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class EntityOxygenSystem {
    @NotNull
    public static EntityOxygenStatus getOxygenStatus(class_1309 entity, class_1937 level) {
        boolean hasOxygenatedSpaceSuit;
        if (!AdAstraConfig.doOxygen) {
            return EntityOxygenStatus.IGNORE;
        }
        if (entity.method_5999()) {
            return EntityOxygenStatus.IGNORE;
        }
        if (ModUtils.checkTag((class_1297)entity, ModTags.LIVES_WITHOUT_OXYGEN)) {
            return EntityOxygenStatus.IGNORE;
        }
        if (OxygenUtils.levelHasOxygen(level) && !entity.method_5869()) {
            return EntityOxygenStatus.IGNORE;
        }
        boolean entityHasOxygen = OxygenUtils.entityHasOxygen(level, entity);
        boolean bl = hasOxygenatedSpaceSuit = SpaceSuit.hasOxygenatedSpaceSuit(entity) && SpaceSuit.hasFullSet(entity);
        if (entityHasOxygen && hasOxygenatedSpaceSuit && entity.method_5869() && !entity.method_6094() && !entity.method_6059(class_1294.field_5923)) {
            return EntityOxygenStatus.CONSUME;
        }
        if (!entityHasOxygen) {
            if (hasOxygenatedSpaceSuit) {
                return EntityOxygenStatus.CONSUME;
            }
            if (!ModUtils.armourIsOxygenated(entity)) {
                return EntityOxygenStatus.DAMAGE;
            }
        }
        return EntityOxygenStatus.IGNORE;
    }

    public static void oxygenTick(class_1309 entity, class_3218 level) {
        EntityOxygenStatus status = EntityOxygenSystem.getOxygenStatus(entity, (class_1937)level);
        if (status == EntityOxygenStatus.CONSUME) {
            EntityOxygenSystem.consumeOxygen(entity);
        } else if (status == EntityOxygenStatus.DAMAGE) {
            entity.method_5643(ModDamageSources.of((class_1937)level, ModDamageSources.OXYGEN), (float)AdAstraConfig.oxygenDamage);
            entity.method_5855(-40);
        }
    }

    private static void consumeOxygen(class_1309 entity) {
        if (entity.method_37908().method_8510() % 3L == 0L) {
            entity.method_5855(Math.min(entity.method_5748(), entity.method_5669() + 40));
            SpaceSuit.consumeSpaceSuitOxygen(entity, FluidHooks.buckets((double)1.0) / 1000L);
        }
    }
}

