/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ParticleInit;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1510;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class EnderwarthogEntity
extends class_1588 {
    public static final class_2940<Boolean> RARE_VARIANT = class_2945.method_12791(EnderwarthogEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> BITE_ATTACK = class_2945.method_12791(EnderwarthogEntity.class, (class_2941)class_2943.field_13323);
    private int sprintedTicker = 0;

    public EnderwarthogEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.field_6194 = 10;
    }

    public static class_5132.class_5133 createEnderwarthogAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 60.0).method_26868(class_5134.field_23719, 0.26).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23721, 9.0).method_26868(class_5134.field_23722, 5.0).method_26868(class_5134.field_23717, 38.0);
    }

    public static boolean canSpawn(class_1299<EnderwarthogEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2680 blockState = world.method_8320(pos);
        return world.method_8407() != class_1267.field_5801 && class_1588.method_20679((class_5425)world, (class_2338)pos, (class_5819)random) && class_1588.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && random.method_43048(6) == 0 && class_1948.method_8662((class_1922)world, (class_2338)pos, (class_2680)blockState, (class_3610)blockState.method_26227(), EntityInit.ENDERWARTHOG);
    }

    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new SprintAttackGoal(this));
        this.field_6201.method_6277(2, (class_1352)new HeadAttackGoal((class_1314)this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 0.85));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[]{EnderwarthogEntity.class}));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[]{class_1510.class}));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)this, new Class[]{class_1560.class}));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[]{class_1559.class}));
        this.field_6185.method_6277(6, (class_1352)new class_1399((class_1314)this, new Class[]{class_1606.class}));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("SprintTicker", this.sprintedTicker);
        tag.method_10556("RareVariant", ((Boolean)this.field_6011.method_12789(RARE_VARIANT)).booleanValue());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.sprintedTicker = tag.method_10550("SprintTicker");
        this.field_6011.method_12778(RARE_VARIANT, (Object)tag.method_10577("RareVariant"));
    }

    public void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(RARE_VARIANT, (Object)false);
        this.field_6011.method_12784(BITE_ATTACK, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608() && this.sprintedTicker > 0) {
            --this.sprintedTicker;
        }
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_31472();
        }
    }

    protected class_3414 method_5994() {
        return SoundInit.ENDERWARTHOG_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.ENDERWARTHOG_HURT_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundInit.ENDERWARTHOG_DEATH_EVENT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.ENDERWARTHOG_WALK_EVENT, 0.15f, 1.0f);
    }

    public boolean method_6121(class_1297 target) {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), SoundInit.ENDERWARTHOG_ATTACK_EVENT, class_3419.field_15251, 1.0f, 0.8f + this.method_37908().method_8409().method_43057() * 0.4f);
        return super.method_6121(target);
    }

    @Nullable
    public class_1315 method_5943(class_5425 serverWorldAccess, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        entityData = super.method_5943(serverWorldAccess, difficulty, spawnReason, entityData, entityTag);
        if (spawnReason.equals((Object)class_3730.field_16462)) {
            this.field_6011.method_12778(RARE_VARIANT, (Object)true);
        }
        if ((spawnReason.equals((Object)class_3730.field_16459) || spawnReason.equals((Object)class_3730.field_16472)) && this.method_37908().method_8409().method_43057() <= ConfigInit.CONFIG.warthog_rare_chance) {
            this.field_6011.method_12778(RARE_VARIANT, (Object)true);
            this.method_5996(class_5134.field_23716).method_6192(this.method_26826(class_5134.field_23716) + 20.0);
        }
        return entityData;
    }

    private class SprintAttackGoal
    extends class_1352 {
        private final EnderwarthogEntity enderwarthogEntity;
        private class_243 targetPos;
        private int cooldown;

        public SprintAttackGoal(EnderwarthogEntity enderwarthogEntity2) {
            this.enderwarthogEntity = enderwarthogEntity2;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.cooldown-- > 0) {
                return false;
            }
            class_1309 livingEntity = this.enderwarthogEntity.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (this.enderwarthogEntity.method_6057((class_1297)livingEntity) && Math.abs(livingEntity.method_23318() - this.enderwarthogEntity.method_23318()) <= 3.0 && livingEntity.method_24828()) {
                this.targetPos = livingEntity.method_19538();
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.enderwarthogEntity.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (this.attack(livingEntity, this.enderwarthogEntity.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321()))) {
                return false;
            }
            if (this.enderwarthogEntity.method_5649(this.targetPos.method_10216(), this.targetPos.method_10214(), this.targetPos.method_10215()) < 10.0) {
                return false;
            }
            if (!(livingEntity instanceof class_1657) || livingEntity.method_7325() || ((class_1657)livingEntity).method_7337()) {
                return false;
            }
            class_243 vec3d = new class_243(this.enderwarthogEntity.method_23317(), this.enderwarthogEntity.method_23320(), this.enderwarthogEntity.method_23321());
            class_243 vec3d2 = new class_243(this.targetPos.method_10216() - this.enderwarthogEntity.method_23317(), this.targetPos.method_10214() + 1.8, this.targetPos.method_10215() - this.enderwarthogEntity.method_23321()).method_1029().method_18805(8.0, 0.0, 8.0);
            class_3965 blockHitResult = this.enderwarthogEntity.method_37908().method_17742(new class_3959(vec3d, vec3d.method_1019(vec3d2), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.enderwarthogEntity));
            return blockHitResult.method_17783() != class_239.class_240.field_1332 && !this.enderwarthogEntity.method_37908().method_8320(blockHitResult.method_17777().method_10087(3)).method_26215();
        }

        public void method_6269() {
            double d = this.targetPos.method_10216() - this.enderwarthogEntity.method_23317();
            double e = this.targetPos.method_10215() - this.enderwarthogEntity.method_23321();
            this.targetPos = this.targetPos.method_1031(new class_243((double)d, (double)0.0, (double)e).method_1029().field_1352 * 10.0, 0.0, new class_243((double)d, (double)0.0, (double)e).method_1029().field_1350 * 10.0);
        }

        public void method_6268() {
            double d = this.targetPos.method_10216() - this.enderwarthogEntity.method_23317();
            double e = this.targetPos.method_10215() - this.enderwarthogEntity.method_23321();
            float q = (float)(class_3532.method_15349((double)e, (double)d) * 57.2957763671875) - 90.0f;
            this.enderwarthogEntity.method_36456(this.wrapDegrees(this.enderwarthogEntity.method_36454(), q, 90.0f));
            this.enderwarthogEntity.method_5784(class_1313.field_6308, new class_243(d, 0.0, e).method_1029().method_1021(0.6));
            if (!this.enderwarthogEntity.method_37908().method_8608()) {
                class_243 vec3d2 = new class_243(this.targetPos.method_10216() - this.enderwarthogEntity.method_23317(), this.targetPos.method_10214() + 1.8, this.targetPos.method_10215() - this.enderwarthogEntity.method_23321()).method_1029();
                ((class_3218)EnderwarthogEntity.this.method_37908()).method_14199((class_2394)ParticleInit.SPRINT_PARTICLE, this.enderwarthogEntity.method_23322(0.7), this.enderwarthogEntity.method_23319(), this.enderwarthogEntity.method_23325(0.7), 0, vec3d2.field_1352, 0.0, vec3d2.field_1350, 1.0);
            }
        }

        public void method_6270() {
            this.cooldown = 100 + this.enderwarthogEntity.method_37908().method_8409().method_43048(100);
            this.enderwarthogEntity.method_19540(false);
            this.enderwarthogEntity.sprintedTicker = 40;
            super.method_6270();
        }

        private boolean attack(class_1309 target, double squaredDistance) {
            double d = this.enderwarthogEntity.method_17681() * 1.5f * this.enderwarthogEntity.method_17681() * 1.5f + target.method_17681();
            if (squaredDistance <= d) {
                this.enderwarthogEntity.method_6104(class_1268.field_5808);
                if (this.enderwarthogEntity.method_6121((class_1297)target)) {
                    class_243 attackedPos = new class_243(target.method_23317(), target.method_23318(), target.method_23321());
                    if (!this.enderwarthogEntity.method_37908().method_8320(class_2338.method_49638((class_2374)attackedPos).method_10074()).method_26215()) {
                        for (int i = 0; i < 30; ++i) {
                            ((class_3218)EnderwarthogEntity.this.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, this.enderwarthogEntity.method_37908().method_8320(class_2338.method_49638((class_2374)attackedPos).method_10074())), attackedPos.method_10216() + this.enderwarthogEntity.method_37908().method_8409().method_43058() * 2.5 - 1.25, attackedPos.method_10214() + this.enderwarthogEntity.method_37908().method_8409().method_43058() * 0.2, attackedPos.method_10215() + this.enderwarthogEntity.method_37908().method_8409().method_43058() * 2.5 - 1.25, 4, 0.0, this.enderwarthogEntity.method_37908().method_8409().method_43058() * 0.15, 0.0, 1.0);
                        }
                    }
                    target.method_18799(target.method_18798().method_1031(0.0, 0.1, 0.0));
                    target.method_6005(3.0, (double)class_3532.method_15374((float)(this.enderwarthogEntity.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.enderwarthogEntity.method_36454() * ((float)Math.PI / 180)))));
                }
                return true;
            }
            return false;
        }

        private float wrapDegrees(float from, float to, float max) {
            float g;
            float f = class_3532.method_15393((float)(to - from));
            if (f > max) {
                f = max;
            }
            if (f < -max) {
                f = -max;
            }
            if ((g = from + f) < 0.0f) {
                g += 360.0f;
            } else if (g > 360.0f) {
                g -= 360.0f;
            }
            return g;
        }
    }

    private class HeadAttackGoal
    extends class_1366 {
        private final EnderwarthogEntity enderwarthogEntity;
        private int cooldown;

        public HeadAttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
            this.enderwarthogEntity = (EnderwarthogEntity)mob;
        }

        public boolean method_6264() {
            if (this.enderwarthogEntity.sprintedTicker > 0) {
                return false;
            }
            return super.method_6264();
        }

        protected double method_6289(class_1309 entity) {
            return this.field_6503.method_17681() * 1.6f * this.field_6503.method_17681() * 1.5f + entity.method_17681();
        }

        protected void method_6288(class_1309 target, double squaredDistance) {
            double d = this.method_6289(target);
            if (squaredDistance <= d && this.cooldown <= 0) {
                this.enderwarthogEntity.field_6011.method_12778(BITE_ATTACK, (Object)true);
                this.method_28346();
                this.field_6503.method_6104(class_1268.field_5808);
                this.field_6503.method_6121((class_1297)target);
            }
        }

        public void method_6270() {
            super.method_6270();
            this.enderwarthogEntity.field_6011.method_12778(BITE_ATTACK, (Object)false);
        }
    }
}

